
/* file to declare variables for action selection functions */

/* the animal's action chosen by the strategy */
int action;

/* the function choosing the strategy */
int select_action();

/* properties of current situation of environment */
double fat_minus,
	  carbo_minus,
	  protein_minus,
	  water_minus,
	  an_temp_minus,
	  an_temp_plus,
	  sqr_temp_minus,
	  sqr_temp_plus,
	  mate_courtedness,
	  cleanliness,
	  night_prox,
	  variance,
	  den_distance;

/* maximum values (over all directions) of all stimuli that are direction
dependent */
double max_food_perc_stimulus,
	   max_food_memory_stimulus,
	   max_water_perc_stimulus,
	   max_water_memory_stimulus,
	   max_shelter_perc_stimulus,
	   max_shade_perc_stimulus,
	   max_p1_perc_stimulus,
	   max_p2_perc_stimulus,
	   max_dp_perc_stimulus,
	   max_irr_perc_stimulus,
	   max_mate_perc_stimulus,
	   max_den_perc_stimulus,
	   max_den_memory_stimulus,
	   max_edge_perc_stimulus;

/* directions of closest instances of different features from animal */
int food_dir;
int remembered_food_dir;
int water_dir;
int remembered_water_dir;
int shelter_dir;
int shade_dir;
int p1_dir;
int p2_dir;
int dp_dir;
int irr_dir;
int mate_dir;
int den_dir;
int remembered_den_dir;
int edge_dir;

void get_maxs_and_dirs();

/* `boolean' variables indicating which sort of food is in animal's square*/
extern int prey_in_animal_square,
		   cf_in_animal_square,
		   ff_in_animal_square;

/*g*//* declarations for longitudinal profiles display */
/*g*/
/*g*/Frame long_profile_frame;
/*g*/
/*g*/Canvas long_profile_canvas;
/*g*/
/*g*/Pixwin *long_profile_pw;
/*g*/
/*g*//* fonts for program */
/*g*/struct pixfont *screen_r_7;
/*g*/
/*g*//* arrays for colourmap */
/*g*/extern u_char red[CMAP_SIZE], green[CMAP_SIZE], blue[CMAP_SIZE];
/*g*/
/*g*/void set_up_long_profile(),
/*g*/	 update_strategy_display(),
/*g*/	 update_long_profile(),
/*g*/	 draw_lpd_blob(),
/*g*/	 delete_lpd_blobs();
/*g*/
/*g*//* position in which to plot activations for each system on each */
/*g*//* longitudinal profile */
/*g*/int lpd_position;
/*g*/
/*g*//* activations used for drawing longitudinal profiles */
/*g*/double lpd_acts[NUM_SYSTEMS_FOR_LPD];
/*g*/
/*g*/void profile_change_proc();
/*g*/int profile_display_on;

/* utility functions enabling certain types of behaviour */
void approach(),
	 avoid(),
	 run_away_from(),
	 explore(),
	 look_in_direction();



