
/* file containing declarations and definitions for master function */

#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/fcntl.h>
#include <sys/errno.h>
#include <netinet/in.h>
#include <netdb.h>
#include <strings.h>
#include "structures.h"
#include "util_fns.h"
#include "../asm/asm_defs.h"


#define TRUE  1
#define FALSE 0

#define NUM_TESTS				1650
#define TOTAL_NUM_TESTS			NUM_TESTS
/*#define TOTAL_NUM_TESTS			(NUM_TESTS*4)*/
#define MASTER_PORTNUM			3008

#define STD						0
#define V1						1
#define V2						2
#define V3						3

/* functions */
void init_master(),
	 master(),
	 set_up_all(),
	 print_results(),
	 get_and_process_slave_result(),
	 give_slave_more_work();

int num_indvdls_left_to_farm_out();

double get_max_gf(),
	   get_min_gf(),
	   get_average_gf(),
	   get_variance();

int done_indvdls[TOTAL_NUM_TESTS];		/* whether or not each individual
				has been calculated (TRUE/FALSE) */

int started_indvdls[TOTAL_NUM_TESTS];		/* number of slaves that have been
				assigned to calculate each indvdl (0-3) */

int curr_indvdl;					/* individual currently being worked
				upon */

int num_indvdls_calculated;			/* number of individuals whose
				genetic fitness has been calculated */

WORK_STRUCT work_packet;			/* what to send out to a slave */
GF_STRUCT reply_packet;				/* what is received back from a slave */

int master_socket_id,
	slave_socket_id = 2345;

/* array of doubles holding results of evaluations (g_f's and lifespans for
each individual) */
double g[TOTAL_NUM_TESTS];
double l[TOTAL_NUM_TESTS];

/* the type of SE of each test */
int types[TOTAL_NUM_TESTS];

