
/* this file contains those definitions that directly relate to the set up
of the environment.  That is to say those that have a large effect on the
nature of the problem the animal faces.  Other definitions are in env_defs.h
and animal_defs.h, but changing the definitions in those files should not
greatly effect the environment */


/* size of array that contains environmental features */
#define ENV_ARR_COLS    25              /* number of columns */
#define ENV_ARR_ROWS    25              /* number of rows */

/* initial number of each type of environmental feature */
#define INIT_NUM_CEREAL_FOOD     ((int) (45.0 + rnd(26.0)))
#define INIT_NUM_COVER           ((int) (25.0 + rnd(26.0)))
#define INIT_NUM_DANGEROUS_PLACE ((int) (5.0 + rnd(16.0)))
#define INIT_NUM_DEN             1
#define INIT_NUM_FRUIT_FOOD      ((int) (50.0 + rnd(31.0)))
#define INIT_NUM_IRRELEVANT      ((int) (5.0 + rnd(16.0)))
#define INIT_NUM_LANDMARK        ((int) (7.0 + rnd(9.0)))
#define INIT_NUM_MATE            ((int) (12.0 + rnd(11.0)))
#define INIT_NUM_PREDATOR_1      ((int) (1.0))
#define INIT_NUM_PREDATOR_2      ((int) (1.0 + rnd(2.0)))
#define INIT_NUM_PREY            ((int) (25.0 + rnd(11.0)))
#define INIT_NUM_SHADE           ((int) (20.0 + rnd(21.0)))
#define INIT_NUM_WATER           ((int) (20.0 + rnd(16.0)))

/* size of clusters features should appear in (if they are clustered at all) */
#define COVER_CLUSTER_SIZE              12
#define DANGEROUS_PLACE_CLUSTER_SIZE    3
#define FRUIT_FOOD_CLUSTER_SIZE         5
#define IRRELEVANT_CLUSTER_SIZE         8
#define PREDATOR_1_CLUSTER_SIZE         ((int) (1.0 + rnd(2.5)))
#define SHADE_CLUSTER_SIZE              5

/* width (or 'concentratedness') of clusters */
#define COVER_CLUSTER_WIDTH             3
#define DANGEROUS_PLACE_CLUSTER_WIDTH   1
#define FRUIT_FOOD_CLUSTER_WIDTH        1
#define IRRELEVANT_CLUSTER_WIDTH        3
#define PREDATOR_1_CLUSTER_WIDTH        2
#define SHADE_CLUSTER_WIDTH             2

/* 'recuperation rates' for cereal food and water which signify how quickly
they recover from eating or drinking by the animal or from drought (value
of 1.0 signifies immediate recovery, 0.0 signifies no recovery).  Water
recuperation every 10 timesteps as opposed to every day for others. */
#define C_F_RECUP_RATE			0.20
#define F_F_RECUP_RATE			0.30
#define WATER_RECUP_RATE		0.03

/* the maximum distance (in squares) at which an animal can perceive
something in daytime (this defines the size of the display for the animal's
perception).  This value should not be set to greater than 3 at the moment.
M_A_P = maximum distance of animal perception */
#define M_A_P                   3

/* the number of squares the animal can perceive with this value of
M_A_P */
#define NUM_PERC_SQUARES		29

/* the maximum distance (in squares) at which predator_1's can spot the
animal (M_P1_P = maximum predator_1 perception) */
#define M_P1_P                  2.5

/* the above squared */
#define M_P1_P_SQRD             (M_P1_P * M_P1_P)

/* the maximum distance (in squares) at which predator_2's can spot the
animal (M_P2_P = maximum predator_2 perception) */
#define M_P2_P                  3.0

/* the above squared */
#define M_P2_P_SQRD             M_P2_P * M_P2_P

/* the number of timesteps in a day (must be a multiple of 10) */
#define DAY_LENGTH              500

/* maximum distances animal is allowed to move if it's action is MOVING or
MOVING_FAST.  1.414 < 1.5 < 2.0.  2.828 < 2.9 < 3.0. */
#define MAX_MOVING_DISTANCE             1.5
#define MAX_MOVING_FAST_DISTANCE        2.9

/* probabilities of new instances of different animals appearing in the
environment at each timestep during the day (morning, afternoon, midday) */
#define IRRELEVANT_DAY_APPEARANCE_PROB		0.003
#define MATE_DAY_APPEARANCE_PROB			0.07
#define PREDATOR_1_DAY_APPEARANCE_PROB		0.003
#define PREDATOR_2_DAY_APPEARANCE_PROB		0.0003
#define PREY_DAY_APPEARANCE_PROB			0.008

/* probabilities of new instances of different animals appearing in the
environment at each timestep during the dusk (sunset, sunrise) */
#define IRRELEVANT_DUSK_APPEARANCE_PROB		0.003
#define MATE_DUSK_APPEARANCE_PROB			0.03
#define PREDATOR_1_DUSK_APPEARANCE_PROB     0.004
#define PREDATOR_2_DUSK_APPEARANCE_PROB		0.006
#define PREY_DUSK_APPEARANCE_PROB			0.01

/* probabilities of new instances of different animals appearing in the
environment at each timestep during the night */
#define IRRELEVANT_NIGHT_APPEARANCE_PROB	0.00
#define MATE_NIGHT_APPEARANCE_PROB			0.00
#define PREDATOR_1_NIGHT_APPEARANCE_PROB	0.0025
#define PREDATOR_2_NIGHT_APPEARANCE_PROB	0.012
#define PREY_NIGHT_APPEARANCE_PROB			0.00

/* the number of instances that will arrive together (in packs?) */
#define IRRELEVANT_APPEARANCE_NUMBER()	((int) (4.0 + rnd(7.0)))
#define MATE_APPEARANCE_NUMBER()  		((int) (1.0 + rnd(2.0)))
#define PREDATOR_1_APPEARANCE_NUMBER()  ((int) (1.0 + rnd(3.5)))
#define PREDATOR_2_APPEARANCE_NUMBER()  ((int) (1.0 + rnd(2.0)))
#define PREY_APPEARANCE_NUMBER()  		((int) (2.0 + rnd(4.0)))

/* the probabilities of instances of each feature type moving at each
timestep */
#define IRRELEVANT_MOVE_PROB    0.50
#define MATE_MOVE_PROB          0.35
#define PREDATOR_1_MOVE_PROB    0.50
#define PREDATOR_2_MOVE_PROB    0.75
#define PREY_MOVE_PROB          0.30

/* probabilities of feature instances being placed in the vicinity of water
sources, as opposed to just occuring randomly anywhere in the environment */
#define CEREAL_FOOD_NEAR_WATER_PROB			0.20
#define COVER_NEAR_WATER_PROB				0.80
#define DEN_NEAR_WATER_PROB					0.80
#define FRUIT_FOOD_NEAR_WATER_PROB			0.70
#define SHADE_NEAR_WATER_PROB				0.40

/* if a feature instance is to be placed close to a water source, the
distance within which it has to lie */
#define CEREAL_FOOD_TO_WATER_DIST           2
#define COVER_TO_WATER_DIST                 1
#define DEN_TO_WATER_DIST                   2
#define FRUIT_FOOD_TO_WATER_DIST            2
#define SHADE_TO_WATER_DIST                 2

/* probabilities of removing/changing cereal food instances at each timestep*/
#define CEREAL_FOOD_REMOVE_CREATE_PROB          0.00005
#define CEREAL_FOOD_CHANGE_CONDITIONS_PROB      0.00002
#define CEREAL_FOOD_CHANGE_TOXICITY_PROB        0.00005

/* probabilities of removing/changing cover instances at each timestep */
#define COVER_REMOVE_CREATE_PROB                0.00002
#define COVER_CHANGE_THICKNESS_PROB             0.00002

/* probabilities of changing fruit food instances at each timestep */
#define FRUIT_FOOD_REMOVE_CREATE_PROB           0.00002
#define FRUIT_FOOD_CHANGE_CONDITIONS_PROB       0.00002
#define FRUIT_FOOD_CHANGE_TOXICITY_PROB         0.00005

/* probabilities of removing/changing shade instances at each timestep */
#define SHADE_REMOVE_CREATE_PROB                0.00001
#define SHADE_CHANGE_THICKNESS_PROB             0.00005

/* probabilities of removing/changing water instances at each timestep */
#define WATER_REMOVE_CREATE_PROB                0.0001
#define WATER_CHANGE_SIZE_PROB                  0.00002
#define WATER_CHANGE_TOXICITY_PROB              0.00005

/* how much food animal can eat from different food types per timestep */
#define CEREAL_FOOD_EATEN_PER_TIMESTEP          0.02
#define FRUIT_FOOD_EATEN_PER_TIMESTEP           0.04

/* how much water animal can drink per timestep */
#define WATER_DRUNK_PER_TIMESTEP                0.06

/* initial value of timestep (don't need to start at beginning of day) */
#define INIT_TIMESTEP_VALUE                     125

/* probabilities of food and water being toxic */
#define CEREAL_FOOD_TOXICITY_PROB               0.05
#define FRUIT_FOOD_TOXICITY_PROB                0.10
#define WATER_TOXICITY_PROB                     0.05

/* probabilities of changing from one weather state to the next at each
timestep */
#define RAIN_TO_CLOUD_PROB                      0.240
#define RAIN_TO_SUN_PROB                        0.045
#define CLOUD_TO_RAIN_PROB                      0.180
#define CLOUD_TO_SUN_PROB                       0.180
#define SUN_TO_CLOUD_PROB                       0.240
#define SUN_TO_RAIN_PROB                        0.045

/* minimum and maximum temperatures for different weather states */
#define MIN_RAIN_TEMP                           -1.0
#define MAX_RAIN_TEMP                           0.35
#define MIN_CLOUD_TEMP                          -0.7
#define MAX_CLOUD_TEMP                          0.7
#define MIN_SUN_TEMP                            -0.35
#define MAX_SUN_TEMP                            1.0

/* increments to temperature according to part of day */
#define NIGHT_TEMP_INCR                         -0.1
#define DUSK_TEMP_INCR                          0.0
#define DAY_TEMP_INCR                           0.1

/* optimal value of homeostatic variables */
#define FOOD_OPT_VALUE          0.5
#define WATER_OPT_VALUE         0.5
#define TEMPERATURE_OPT_VALUE   0.5

/* ranges of homeostatic variables for which they are acceptable, i.e. for
which they don't affect the health of the animal */
#define MIN_OK_FAT				0.25
#define MAX_OK_FAT				0.75
#define MIN_OK_CARBO			0.25
#define MAX_OK_CARBO			0.75
#define MIN_OK_PROTEIN			0.25
#define MAX_OK_PROTEIN			0.75
#define MIN_OK_WATER			0.25	
#define MAX_OK_WATER			0.75
#define MIN_OK_TEMP 			0.25
#define MAX_OK_TEMP 			0.75

/* the maximum number of days the animal can live before it dies of old age */
#define MAX_ANIMAL_LIFESPAN		10.0

/* the maximum rate at which the animal's health can recover */
#define RECOVERY_RATE			0.003

/* factors to apply to distance animal can see dependent on part of day */
#define NIGHT_PERCEPTION_FACTOR         0.0
#define DUSK_PERCEPTION_FACTOR          0.70
#define DAY_PERCEPTION_FACTOR           1.00

/* factor by which difference between perfect and existing perception is
reduced if the animal is looking in a specific direction */
#define LOOKING_DIRECTION_PERC_FACTOR   0.50

/* maximum decrements to food and water (e.g. when the animal is mating) */
#define MAX_FAT_DECREMENT						0.00135
#define MAX_CARBO_DECREMENT						0.0018
#define MAX_PROTEIN_DECREMENT					0.0009
#define MAX_WATER_DECREMENT						0.0020

/* the number of previous days' temperature that is taken into account when
considering water levels, etc */
#define T_H_LENGTH              5               /* 20 */

/* the number of previous days' rainfall that is taken into account when
considering plant growth, etc */
#define R_H_LENGTH              5               /* 20 */

/* the `closeness' of the packs of different animals which determines how
large the `magnetic' attraction towards the centre (ie. leader) of the pack
is.  These values should not be more than 20.0 */
#define IRRELEVANT_PACK_CLOSENESS               10.0
#define PREDATOR_1_PACK_CLOSENESS               15.0

/* largest possible number of packs in existence at any one time for each
animal feature type */
#define MAX_NUM_IRRELEVANT_PACKS                30
#define MAX_NUM_PREDATOR_1_PACKS                30

/* probability of an action not being correctly executed */
#define FAULTY_ACTION_PROB						0.01

/* maximum movement capacities for predators when chasing animal (they
normally only move one square per timestep) */
#define P_1_MOVEMENT()						((int) (1.2 + rnd(1.9)))
#define P_2_MOVEMENT()						((int) (1.4 + rnd(2.7)))

/* the number of different locations `remembered' by the animal = the size
of the animal's `map' */
#define MAP_SIZE				100

/* a factor by which to multiply the strength of each memory each update.
If this value is 1.0, then no decay occurs, if less than 1.0 then decays
more as value gets further from 1.0 */
#define MEMORY_DECAY_FACTOR		0.9870

/* with each step the animal incurs a normally distributed random error in
its estimate of where it is.  This error has variance NAV_ERROR */
#define NAV_ERROR				0.05

/* the make-up of different types of food in terms of the proportions of
fat, carbohydrate and protein */
#define CEREAL_FOOD_FAT_RATIO			0.27
#define CEREAL_FOOD_CARBO_RATIO			0.55
#define CEREAL_FOOD_PROTEIN_RATIO		0.18
#define FRUIT_FOOD_FAT_RATIO			0.35
#define FRUIT_FOOD_CARBO_RATIO			0.47
#define FRUIT_FOOD_PROTEIN_RATIO		0.18
#define PREY_FAT_RATIO					0.40
#define PREY_CARBO_RATIO				0.30
#define PREY_PROTEIN_RATIO				0.30

/* the maximum amounts the animal's temperature can increase or decrease
each timestep */
#define MAX_AN_TEMP_INCREASE			0.10
#define MAX_AN_TEMP_DECREASE			0.10


