
/*  this file contains declarations for variables in the bits of program
that define how the environment works */

#include "env_spec.h"

double behave();			/* the top level function */

int animal_alive;        /* boolean to indicate whether animal is
                         alive or dead */

/*g*/
/*g*/int win_width,                  /* frame dimensions */
/*g*/    win_height,
/*g*/    half_win_width,
/*g*/	half_win_height,
/*g*/    weather_display_on,         /* boolean to show if weather being displayed*/
/*g*/    paused = FALSE,         	/* boolean to show if pause activated */
/*g*/    step = FALSE,				/* boolean to show if step activated */
/*g*/    user_wants_rerun;          /* boolean to show if user wants another run */

int env_weather,
    timestep,
    daystep,
    part_of_day;

/*g*/unsigned delay = 0;				/* amount to slow down execution for user */
/*g*/
/*g*/FILE *analysis_info_f;

double rainfall_history,         /* average of recent rainfall */
      recent_rainfall[R_H_LENGTH],  /* rainfall totals for previous days */
      env_rainfall,             /* rainfall at a point in the day */
      total_day_rainfall,       /* sum of all rainfall during a day */      
      temp_history,             /* average of recent temperature */
      recent_temp[T_H_LENGTH],  /* recent temperatures */
      env_temp,                 /* temperature at a time in the day */
      total_day_temp,           /* sum of temperatures at ten times in day */
      min_temp,                 /* min. possible temperature for this weather*/
      max_temp,                 /* max. possible temperature for this weather*/
      env_dryness;              /* a measure of the lack of rainfall and
                                evaporation due to heat during recent past */

char text[100];			/* general purpose text buffer */

/* number of packs for each feature currently in env. */
int current_num_irrelevant_packs = 0;
int current_num_predator_1_packs = 0;

/*g*/Frame env_frame,
/*g*/      weather_frame,
/*g*/      key_frame,
/*g*/      analysis_frame;
/*g*/extern Frame perception_frame,
/*g*/             nav_frame,
/*g*/             map_frame,
/*g*/             animal_frame,
/*g*/             long_profile_frame;
/*g*/
/*g*/Canvas env_canvas,
/*g*/       weather_canvas,
/*g*/       key_canvas;
/*g*/extern Canvas perception_canvas,
/*g*/              nav_canvas,
/*g*/              map_canvas,
/*g*/              animal_canvas;
/*g*/
/*g*/Pixwin *env_pw,
/*g*/       *weather_pw,
/*g*/       *key_pw;
/*g*/extern Pixwin *perception_pw,
/*g*/              *nav_pw,
/*g*/              *map_pw,
/*g*/              *animal_pw;
/*g*/
/*g*/Panel env_panel,
/*g*/      weather_panel,
/*g*/      analysis_panel;
/*g*/
/*g*/Panel_item temp_slider,
/*g*/           temp_history_slider,
/*g*/           rainfall_slider,
/*g*/           rainfall_history_slider,
/*g*/           day_message,
/*g*/           time_message,
/*g*/           action_message,
/*g*/           daynight_message;
/*g*/
/*g*/Textsw analysis_text_win;
/*g*/
/*g*//* pixrects containing pictures of different environmental features */
/*g*/struct pixrect *feature_pr[NUM_FEATURE_TYPES];
/*g*/
/*g*//* pixrects containing weather images */
/*g*/struct pixrect *rain_pr, *cloud_pr, *ssun_pr;
/*g*/
/*g*/colormap_t *null_cmap = NULL;   /* null colormap */
/*g*/
/*g*//* fonts for program */
/*g*/struct pixfont *serif_r_12, *serif_r_14;
/*g*/
/*g*//* arrays for colourmap */
/*g*/u_char red[CMAP_SIZE], green[CMAP_SIZE], blue[CMAP_SIZE];
/*g*/
/*g*//* foreground and background colour */
/*g*/struct singlecolor fg_clr, *fg_clr_ptr, bg_clr, *bg_clr_ptr;
/*g*/
/*g*//* array of integers to hold rasterops */
/*g*/int op[CMAP_SIZE];
/*g*/
/*g*//* icon for program */
/*g*/Icon env_icon;
/*g*/
/*g*//* make icon equal to image in file */
/*g*/static short icon_image[] = {
/*gn*/
#include "icons/prog_icon"
/*g*/};
/*g*/mpr_static(icon_pixrect, 64, 64, 1, icon_image);
/*g*/
/*g*/void process_command_line_args(),
/*g*/     read_in_images(),
/*g*/     set_up_graphics(),
/*g*/     set_up_fonts(),
/*g*/     env_win_proc(),
/*g*/     set_colourmap(),
/*g*/     set_ops();
void init_feature_lists(),
     f_list_add(),
     f_list_remove(),
     init_weather(),
     init_rainfall(),
     init_temp(),
     init_dryness(),
     set_up_env(),
     get_rnd_pos(),
     get_rnd_side_pos(),
/*g*/     redraw_square(),
/*g*/     redraw_square_without_clearing(),
/*g*/     add_to_square(),
     update_1_env(),
     update_10_env(),
     update_day_env(),
	 update_1_time_variables(),
     update_weather(),
     update_rainfall(),
     update_temp(),
/*g*/     update_weather_display(),
     update_1_cereal_food(),
     update_1_cover(),
     update_1_fruit_food(),
     update_1_shade(),
     update_1_water(),
     update_1_irrelevant(),
     update_1_mate(),
     update_1_predator_1(),
     update_1_predator_2(),
     update_1_prey(),
     update_10_water(),
     update_graded_features(),
     update_day_rainfall(),
     update_day_temp(),
     update_day_dryness(),
     update_day_cereal_food(),
     update_day_fruit_food(),
     update_day_water();
/*g*/
/*g*/void	  make_icon(),
/*g*/     set_up_weather_display(),
/*g*/     set_up_key_display(),
/*g*/     set_up_analysis_display(),
/*g*/     show_analysis(),
/*g*/     weather_change_proc(),
/*g*/     key_change_proc(),
/*g*/     quit_proc(),
/*g*/     rerun_proc(),
/*g*/     redisplay_end_proc(),
/*g*/     pause_proc(),
/*g*/     restart_proc(),
/*g*/     step_proc(),
/*g*/     faster_proc(),
/*g*/     slower_proc(),
/*g*/     turn_off_weather_proc();

double get_cereal_food_conditions();
double get_cereal_food_value();
double get_cereal_food_toxicity();
int get_cereal_food_toxicity_delay();

double get_cover_thickness();

double get_fruit_food_conditions();
int get_fruit_food_cycle_length();
double get_fruit_food_ripe_time();
int get_fruit_food_cycle_state();
double get_fruit_food_value();
double get_fruit_food_toxicity();
int get_fruit_food_toxicity_delay();

double get_irrelevant_north_prob();
double get_irrelevant_east_prob();
double get_irrelevant_south_prob();
double get_irrelevant_west_prob();

int get_mate_receptive();
int get_mate_courted();
double get_mate_north_prob();
double get_mate_east_prob();
double get_mate_south_prob();
double get_mate_west_prob();

double get_predator_1_size();
double get_predator_1_damage();
double get_predator_1_persistence();
double get_predator_1_time_chasing();
int get_predator_1_animal_spotted();
int get_predator_1_chasing_animal();
int get_predator_1_hungry();
double get_predator_1_north_prob();
double get_predator_1_east_prob();
double get_predator_1_south_prob();
double get_predator_1_west_prob();

double get_predator_2_damage();
double get_predator_2_persistence();
double get_predator_2_time_chasing();
int get_predator_2_animal_spotted();
int get_predator_2_chasing_animal();
int get_predator_2_hungry();
double get_predator_2_north_prob();
double get_predator_2_east_prob();
double get_predator_2_south_prob();
double get_predator_2_west_prob();

double get_prey_value();
double get_prey_north_prob();
double get_prey_east_prob();
double get_prey_south_prob();
double get_prey_west_prob();

double get_shade_thickness();

double get_water_average_size();
double get_water_value();
double get_water_toxicity();
int get_water_toxicity_delay();

int get_direction();

int square_in_env();

int new_weather();

double new_temp();

/* the environment consists of a 2D-array of structures containing
descriptions of the individual areas */
ENV_SQUARE env_arr[ENV_ARR_COLS][ENV_ARR_ROWS];

/* make an array of feature_lists, one for each type of feature (some will
not be used) */ 
FEATURE_LIST f_list[NUM_FEATURE_TYPES];

/* functions that return instantiated environmental features */
void get_cereal_food(),
     get_cover(),
     get_dangerous_places(),
     get_dens(),
     get_fruit_food(),
     get_irrelevants(),
     get_landmarks(),
     get_mates(),
     get_predator_1s(),
     get_predator_2s(),
     get_prey(),
     get_shade(),
     get_water();

/*g*/extern Panel_item fat_shortage_slider,
/*g*/		   carbo_shortage_slider,
/*g*/		   protein_shortage_slider,
/*g*/		   water_shortage_slider,
/*g*/		   low_temp_slider,
/*g*/		   high_temp_slider,
/*g*/		   predator_1_proximity_slider,
/*g*/		   predator_2_proximity_slider,
/*g*/		   dangerous_place_proximity_slider,
/*g*/		   irrelevant_proximity_slider,
/*g*/		   mate_proximity_slider,
/*g*/		   closeness_of_nightfall_slider,
/*g*/		   edge_proximity_slider,
/*g*/		   get_food_drive_slider,
/*g*/		   get_water_drive_slider,
/*g*/		   cool_down_drive_slider,
/*g*/		   warm_up_drive_slider,
/*g*/		   escape_predator_1_drive_slider,
/*g*/		   escape_predator_2_drive_slider,
/*g*/		   avoid_dangerous_place_drive_slider,
/*g*/		   avoid_irrelevant_drive_slider,
/*g*/		   approach_mate_drive_slider,
/*g*/		   look_for_den_drive_slider,
/*g*/		   avoid_edge_drive_slider;

extern double fat_shortage,
	  carbo_shortage,
	  protein_shortage,
	  water_shortage,
	  low_temp,
	  high_temp,
	  predator_1_proximity,
	  predator_2_proximity,
	  dangerous_place_proximity,
	  irrelevant_proximity,
	  mate_proximity,
	  closeness_of_nightfall,
	  edge_proximity;

extern double get_food_drive,
	  get_water_drive,
	  cool_down_drive,
	  warm_up_drive,
	  escape_predator_1_drive,
	  escape_predator_2_drive,
	  avoid_dangerous_place_drive,
	  avoid_irrelevant_drive,
	  approach_mate_drive,
	  look_for_den_drive,
	  avoid_edge_drive;

/*g*/extern Panel strategy_panel1,
/*g*/      strategy_panel2;
/*g*/

/* make this available to behave.c so can return it's value */
extern int genetic_fitness;

/*g*/extern void profile_change_proc();

void free_memory();
extern void free_animal_memory();

double lifespan;

FILE *tob_f;

