
/* file to define macros for functions implementing Pattie Maes's behaviour 
selection mechanism */

#define GLOBAL_PARAMS_FNAME				"../asm/global_parameters"
#define NODE_LIST_FNAME					"../asm/nodes"
#define PROPOSITIONS_FNAME				"../asm/propositions"
#define PRECONDITIONS_FNAME				"../asm/preconditions"
#define ADD_LISTS_FNAME					"../asm/add_lists"
#define DELETE_LISTS_FNAME				"../asm/delete_lists"
#define ENV_CONDITIONS_FNAME			"../asm/env_conditions"
#define GOALS_FNAME						"../asm/goals"

#define MAX_NUM_PRECONDITIONS			50
#define MAX_SIZE_ADD_LIST				50
#define MAX_SIZE_DELETE_LIST			50
#define MAX_NUM_PREDECESSORS			50
#define MAX_NUM_SUCCESSORS				50
#define MAX_NUM_CONFLICTORS				50

#define MAX_NUM_NODES					50

#define MAX_NUM_PROPOSITIONS			200

#define MAX_NUM_ENV_CONDITIONS			150

#define MAX_NUM_GOALS					150

#define MAX_LINE_LENGTH					200

#define MAX_NUM_INPUTS					20

/* the value to which the sum of activations is normalised after each
cycle */
#define NORMALISED_SUM					10.0

/* definitions for the longitudinal profile display */
#define LPD_ROW_HEIGHT					28
#define LPD_GRAPH_HEIGHT				(LPD_ROW_HEIGHT-12)
#define NUM_SYSTEMS_FOR_LPD				29
#define LDP_WIDTH						450		/* multiple of three */

/* types of different connection */
#define ENV_CONNECTION					0
#define GOAL_CONNECTION					0
#define PROT_GOAL_CONNECTION			0
#define PREDECESSOR						0
#define SUCCESSOR						0
#define CONFLICTOR						0

