
/* file to declare variables for functions implementing Pattie Maes's
behaviour selection mechanism */

int select_action();

/* global parameters for system */
double theta;
double phi;
double gammaa;
double delta;

/* number of node that eventually gets chosen by spreading activation
process */
int chosen_node;

/* global threshold above which activation has to go to make a behaviour
executable */
double global_activation_threshold;

/* structure defining a node */
typedef struct node
{

  char name[50];

  double activation;

  double post_spreading_activation;

  int preconditions[MAX_NUM_PRECONDITIONS];
  int num_preconditions;

  int add_list[MAX_SIZE_ADD_LIST];
  int add_list_size;

  int delete_list[MAX_SIZE_DELETE_LIST];
  int delete_list_size;

  int predecessors[MAX_NUM_PREDECESSORS];
  int num_predecessors;

  int successors[MAX_NUM_SUCCESSORS];
  int num_successors;

  int conflictors[MAX_NUM_CONFLICTORS];
  int num_conflictors;
} NODE;

/* the nodes in the network */
NODE nodes[MAX_NUM_NODES];

/* number of nodes */
int num_nodes;
int num_props;
int num_env_conditions;
int num_goals;

/* names of propositions */
char prop_names[MAX_NUM_PROPOSITIONS][50];

/* list of numbers of propositions which are conditions about the
environment */
int env_conditions[MAX_NUM_ENV_CONDITIONS];

/* list of numbers of propositions which are goals of the animal */
int goals[MAX_NUM_GOALS];

/* lists of numbers of times each proposition appears in different
precondition, add and delete lists */
int prop_precon_count[MAX_NUM_PROPOSITIONS];
int prop_add_list_count[MAX_NUM_PROPOSITIONS];
int prop_delete_list_count[MAX_NUM_PROPOSITIONS];

/* strengths of different goals */
double goal_strengths[MAX_NUM_PROPOSITIONS];

/* truth or falsity of different conditions about the environment */
int env_condition_values[MAX_NUM_PROPOSITIONS];

/* functions */

int behave_choice();

void calc_env_conditions();
void calc_animal_goals();

int no_node_executable();

int proposition_is_goal();

void reduce_global_threshold();

void normalise_activation_levels();
void input_excitation_from_env();
void input_excitation_from_goals();
void take_out_excitation_from_protected_goals();
void spread_excitation_to_predecessors();
void spread_excitation_to_successors();
void spread_excitation_to_conflictors();

void setup_strategy();

void init_global_parameters();
void init_node_list();
void init_propositions();

void init_node_preconditions();
void init_node_add_lists();
void init_node_delete_lists();

void init_env_conditions();
void init_goals();

void calc_num_predecessors();

void init_node_activations();

void execute_module();

int getline();

/* functions to set goal strengths */
void set_health_not_too_low_goal_strength(),
     set_food_okay_goal_strength(),
	 set_water_okay_goal_strength(),
	 set_not_too_hot_goal_strength(),
	 set_not_too_cold_goal_strength(),
	 set_no_p1s_goal_strength(),
	 set_no_p2s_goal_strength(),
	 set_no_dps_goal_strength(),
	 set_no_irrs_goal_strength(),
	 set_sleeping_in_den_goal_strength(),
	 set_no_edges_goal_strength(),
	 set_variance_okay_goal_strength(),
	 set_clean_goal_strength(),
	 set_just_mated_goal_strength(),
	 set_recently_scanned_for_predators_goal_strength(),
	 set_no_predator_since_last_scan_goal_strength(),
	 set_close_to_cover_goal_strength();

/* functions to calculate the truth or falsity of logical propositions about
the environment */
void calc_cf_in_square(),
	 calc_ff_in_square(),
	 calc_prey_in_square(),
	 calc_food_perceived(),
	 calc_food_remembered(),
	 calc_food_not_in_square(),
	 calc_water_in_square(),
	 calc_water_perceived(),
	 calc_water_remembered(),
	 calc_shelter_in_square(),
	 calc_shelter_perceived(),
	 calc_shade_in_square(),
	 calc_shade_perceived(),
	 calc_p1_perceived_strongly(),
	 calc_p1_perceived_weakly(),
	 calc_p2_perceived_strongly(),
	 calc_p2_perceived_weakly(),
	 calc_dp_perceived_strongly(),
	 calc_irr_perceived_strongly(),
	 calc_receptive_mate_perceived(),
	 calc_receptive_mate_in_square(),
	 calc_courted_mate_in_square(),
	 calc_den_perceived(),
	 calc_den_in_square(),
	 calc_den_not_in_square(),
	 calc_den_remembered(),
	 calc_sunset_or_night(),
	 calc_edge_perceived_strongly(),
	 calc_shade_or_shelter_in_square(),
	 calc_p1_or_p2_perceived_strongly(),
	 calc_not_in_cover();

/* the animal's action chosen by the strategy */
int action;

void approach(),
	 avoid(),
	 run_away_from(),
	 explore();

/* global variables to store the values passed in to behave_choice */

/* properties of current situation of environment */
double fat_minus,
	  carbo_minus,
	  protein_minus,
	  water_minus,
	  an_temp_minus,
	  an_temp_plus,
	  sqr_temp_minus,
	  sqr_temp_plus,
	  mate_courtedness,
	  cleanliness,
	  night_prox,
	  variance,
	  den_distance,
	  scan_time,
	  cover_distance,
	  time_since_predator,
	  health,
	  p_injury;

/* maximum values (over all directions) of all stimuli that are direction
dependent */
double max_food_perc_stimulus,
	   max_food_memory_stimulus,
	   max_water_perc_stimulus,
	   max_water_memory_stimulus,
	   max_shelter_perc_stimulus,
	   max_shade_perc_stimulus,
	   max_p1_perc_stimulus,
	   max_p2_perc_stimulus,
	   max_dp_perc_stimulus,
	   max_irr_perc_stimulus,
	   max_mate_perc_stimulus,
	   max_den_perc_stimulus,
	   max_den_memory_stimulus,
	   max_edge_perc_stimulus;

/* directions of closest instances of different features from animal */
int food_dir;
int remembered_food_dir;
int water_dir;
int remembered_water_dir;
int shelter_dir;
int shade_dir;
int p1_dir;
int p2_dir;
int dp_dir;
int irr_dir;
int mate_dir;
int den_dir;
int remembered_den_dir;
int edge_dir;

void get_maxs_and_dirs();

void look_in_direction();

double stimuli_record[25];

double temp_minus_max = 0.0, temp_plus_max = 0.0;

double drive_record[14];

int num_times_get_food_chosen = 0;
int num_times_cleaning_chosen = 0;

extern int prey_in_animal_square,
		   cf_in_animal_square,
		   ff_in_animal_square;

void approach(),
	 avoid(),
	 run_away_from(),
	 look_in_direction(),
	 explore();


int node1 = 1,
	node2 = 3,
	node3 = 5,
	node4 = 6,
	node5 = 8,
	node6 = 26;

/*g*/int profile_display_on;
/*g*/
/*g*//* position in which to plot activations for each system on each */
/*g*//* longitudinal profile */
/*g*/int lpd_position;
/*g*/
/*g*//* activations used for drawing longitudinal profiles */
/*g*/double lpd_acts[NUM_SYSTEMS_FOR_LPD];
/*g*/
/*g*//* fonts for program */
/*g*/struct pixfont *screen_r_7;
/*g*/
/*g*//* arrays for colourmap */
/*g*/extern u_char red[CMAP_SIZE], green[CMAP_SIZE], blue[CMAP_SIZE];
/*g*/
/*g*/void profile_change_proc();
/*g*/
/*g*/void set_up_long_profile(),
/*g*/	 update_strategy_display(),
/*g*/	 update_long_profile(),
/*g*/	 draw_lpd_blob(),
/*g*/	 delete_lpd_blobs();
/*g*/
/*g*/Frame strategy_frame,
/*g*/	  long_profile_frame;
/*g*/
/*g*/Canvas long_profile_canvas;
/*g*/
/*g*/Pixwin *long_profile_pw;
/*g*/

typedef struct node_input
{

  double excitation;
  char type_name[30];
  int type;
  char sender_name[60];
} NODE_INPUT;

NODE_INPUT inputs[MAX_NUM_NODES][MAX_NUM_INPUTS];

int num_inputs[MAX_NUM_NODES];

double largest_current_activation;

double mate_in_same_square_stimulus;
