
/* file to declare variables for drives functions */

int select_action();

/*g*/Frame strategy_frame,
/*g*/	  long_profile_frame;
/*g*/
/*g*/Canvas long_profile_canvas;
/*g*/
/*g*/Pixwin *long_profile_pw;
/*g*/
/*g*/Panel strategy_panel1,
/*g*/	  strategy_panel2;
/*g*/
/*g*/Panel_item fat_shortage_slider,
/*g*/		   carbo_shortage_slider,
/*g*/		   protein_shortage_slider,
/*g*/		   food_perc_stimulus_slider,
/*g*/		   food_memory_stimulus_slider,
/*g*/		   water_shortage_slider,
/*g*/		   water_perc_stimulus_slider,
/*g*/		   water_memory_stimulus_slider,
/*g*/		   low_temp_slider,
/*g*/		   shelter_perc_stimulus_slider,
/*g*/		   high_temp_slider,
/*g*/		   shade_perc_stimulus_slider,
/*g*/		   p1_perc_stimulus_slider,
/*g*/		   p2_perc_stimulus_slider,
/*g*/		   dp_perc_stimulus_slider,
/*g*/		   irr_perc_stimulus_slider,
/*g*/		   mate_perc_stimulus_slider,
/*g*/		   mate_courted_slider,
/*g*/		   night_proximity_slider,
/*g*/		   distance_from_den_slider,
/*g*/		   den_perc_stimulus_slider,
/*g*/		   den_memory_stimulus_slider,
/*g*/		   cleanliness_slider,
/*g*/		   edge_perc_stimulus_slider,
/*g*/		   get_food_drive_slider,
/*g*/		   get_water_drive_slider,
/*g*/		   cool_down_drive_slider,
/*g*/		   warm_up_drive_slider,
/*g*/		   escape_predator_1_drive_slider,
/*g*/		   escape_predator_2_drive_slider,
/*g*/		   avoid_dangerous_place_drive_slider,
/*g*/		   avoid_irrelevant_drive_slider,
/*g*/		   approach_mate_drive_slider,
/*g*/		   reduce_variance_drive_slider,
/*g*/		   sleep_in_den_drive_slider,
/*g*/		   animal_variance_slider,
/*g*/		   cleaning_drive_slider,
/*g*/		   avoid_edge_drive_slider;
/*g*/
/*g*//* fonts for program */
/*g*/struct pixfont *screen_r_7;
/*g*/
/*g*//* arrays for colourmap */
/*g*/extern u_char red[CMAP_SIZE], green[CMAP_SIZE], blue[CMAP_SIZE];

/* `drives' or `urgencies' for different actions */
double get_food_drive,
	  get_water_drive,
	  cool_down_drive,
	  warm_up_drive,
	  escape_predator_1_drive,
	  escape_predator_2_drive,
	  avoid_dangerous_place_drive,
	  avoid_irrelevant_drive,
	  approach_mate_drive,
	  reduce_variance_drive,
	  sleep_in_den_drive,
	  cleaning_drive,
	  avoid_edge_drive,
	  scan_for_predators_drive,
	  stay_close_to_cover_drive;

/* the value of this integer denotes which of the drives has the highest
value and so decides the behaviour chosen */
int highest_drive;

double highest_drive_value;

/* functions to transfer from above values to `drives' */
void calc_get_food_drive(),
	 calc_get_water_drive(),

	 calc_cool_down_drive(),
	 calc_warm_up_drive(),
	 calc_escape_predator_1_drive(),
	 calc_escape_predator_2_drive(),
	 calc_avoid_dangerous_place_drive(),
	 calc_avoid_irrelevant_drive(),
	 calc_approach_mate_drive(),
	 calc_reduce_variance_drive(),
	 calc_sleep_in_den_drive(),
	 calc_cleaning_drive(),
	 calc_avoid_edge_drive(),
	 calc_scan_for_predators_drive(),
	 calc_stay_close_to_cover_drive();

/* functions to calculate behaviour according to the highest drive */
void try_to_get_food(),
	 try_to_get_water(),
	 try_to_cool_down(),
	 try_to_warm_up(),
	 try_to_escape_predator_1(),
	 try_to_escape_predator_2(),
	 try_to_avoid_dangerous_place(),
	 try_to_avoid_irrelevant(),
	 try_to_approach_mate(),
	 try_to_reduce_variance(),
	 try_to_sleep_in_den(),
	 try_to_clean(),
	 try_to_avoid_edge(),
	 try_to_scan_for_predators(),
	 try_to_approach_cover();

/* functions */
void transfer_from_properties_to_drives(),
	 choose_highest_drive();

int get_behaviour_for_drive();

/* the animal's action chosen by the strategy */
int action;

void set_up_strategy();
/*g*/void set_up_long_profile(),
/*g*/	 update_strategy_display(),
/*g*/	 update_long_profile(),
/*g*/	 draw_lpd_blob(),
/*g*/	 delete_lpd_blobs();

void approach(),
	 avoid(),
	 run_away_from(),
	 explore();

/* global variables to store the values passed in to behave_choice */

/* properties of current situation of environment */
double fat_minus,
	  carbo_minus,
	  protein_minus,
	  water_minus,
	  an_temp_minus,
	  an_temp_plus,
	  sqr_temp_minus,
	  sqr_temp_plus,
	  mate_courtedness,
	  cleanliness,
	  night_prox,
	  variance,
	  den_distance,
	  scan_time,
	  cover_distance,
	  time_since_predator,
	  health,
	  p_injury;

/* maximum values (over all directions) of all stimuli that are direction
dependent */
double max_food_perc_stimulus,
	   max_food_memory_stimulus,
	   max_water_perc_stimulus,
	   max_water_memory_stimulus,
	   max_shelter_perc_stimulus,
	   max_shade_perc_stimulus,
	   max_p1_perc_stimulus,
	   max_p2_perc_stimulus,
	   max_dp_perc_stimulus,
	   max_irr_perc_stimulus,
	   max_mate_perc_stimulus,
	   max_den_perc_stimulus,
	   max_den_memory_stimulus,
	   max_edge_perc_stimulus;

/* directions of closest instances of different features from animal */
int food_dir;
int remembered_food_dir;
int water_dir;
int remembered_water_dir;
int shelter_dir;
int shade_dir;
int p1_dir;
int p2_dir;
int dp_dir;
int irr_dir;
int mate_dir;
int den_dir;
int remembered_den_dir;
int edge_dir;

void get_maxs_and_dirs();

void look_in_direction();

double temp_minus_max = 0.0, temp_plus_max = 0.0;

int num_times_get_food_chosen = 0;
int num_times_cleaning_chosen = 0;

extern int prey_in_animal_square,
		   cf_in_animal_square,
		   ff_in_animal_square;

/*g*//* position in which to plot activations for each system on each */
/*g*//* longitudinal profile */
/*g*/int lpd_position;
/*g*/
/*g*//* activations used for drawing longitudinal profiles */
/*g*/double lpd_acts[NUM_SYSTEMS_FOR_LPD];
/*g*/
/*g*/void profile_change_proc();
/*g*/int profile_display_on;

extern int animal_action;

double scale_pan_force[NUM_DRIVES], reservoir_force[NUM_DRIVES];

void empty_reservoirs();

extern int timestep;
