
/* file to declare variables for Rosenblatt & Payton behaviour selection
mechanism */

int select_action();

/* structure defining a node */
typedef struct r_and_p_node
{

  char name[50];

  double activation;
  int all_act_received;

  int in_links[MAX_NUM_NODES];
  int out_links[MAX_NUM_NODES];
  int num_in_links;
  int num_out_links;

  int type;
} R_AND_P_NODE;

/* the nodes in the network */
R_AND_P_NODE nodes[MAX_NUM_NODES];

/* structure defining a link */
typedef struct link
{

  int sender_number;
  int receiver_number;

  double strength;

  int sender_type;
  int receiver_type;
} LINK;

/* the links in the network */
LINK links[MAX_NUM_LINKS];

char int_sensors[MAX_NUM_SENSORS][MAX_LINE_LENGTH];
char ext_sensors[MAX_NUM_SENSORS][MAX_LINE_LENGTH];
char indet_sensors[MAX_NUM_SENSORS][MAX_LINE_LENGTH];
char directed_ext_sensors[MAX_NUM_SENSORS][MAX_LINE_LENGTH];

double int_sensor_acts[MAX_NUM_SENSORS];
double ext_sensor_acts[MAX_NUM_SENSORS];
double indet_sensor_acts[MAX_NUM_SENSORS];
double directed_ext_sensor_acts[MAX_NUM_SENSORS][9];

/* numbers of different types of nodes */
int num_top_level_nodes;
int num_intermediate_nodes;
int num_bottom_level_nodes;
int num_nodes;

int num_int_sensors;
int num_ext_sensors;
int num_indet_sensors;
int num_directed_ext_sensors;

int num_links;

void init_internal_sensors();
void init_external_sensors();
void init_indeterminate_sensors();
void init_directed_external_sensors();

void init_nodes();
void init_top_level_nodes();
void init_intermediate_nodes();
void init_bottom_level_nodes();

void init_links();

void calc_internal_sensors();
void calc_external_sensors();
void calc_indeterminate_sensors();
void calc_directed_external_sensors();
void pass_activation_through_network();
void input_excitation_to_node();
int get_action();

void calc_food_minus();
void calc_water_minus();
void calc_an_temp_minus();
void calc_sqr_temp_minus();
void calc_an_temp_plus();
void calc_sqr_temp_plus();
void calc_dirtiness();
void calc_temporal_discount_penalty();
void calc_uncertainty_penalty();
void calc_one_point_zero();

/* calculation of external sensor values */
void calc_cf_in_sq();
void calc_ff_in_sq();
void calc_prey_in_sq();
void calc_food_in_sq();
void calc_water_in_sq();
void calc_shade_in_sq();
void calc_shelter_in_sq();
void calc_dp_in_sq();
void calc_irr_in_sq();
void calc_p1_in_sq();
void calc_max_p1();
void calc_max_p1_adjusted();
void calc_p2_in_sq();
void calc_max_p2();
void calc_max_p2_adjusted();
void calc_receptive_mate_in_sq();
void calc_courted_mate_in_sq();
void calc_den_in_sq();
void calc_no_den_in_sq();
void calc_low_health();

/* calculation of indeterminate sensor values */
void calc_variance();
void calc_night_prox();
void calc_den_distance();
void calc_time_since_scanned();
void calc_predator_since_scanned();
void calc_distance_from_cover();

/* calculation of directed external sensor values */
void calc_food();
void calc_food_r();
void calc_water();
void calc_water_r();
void calc_shade();
void calc_shelter();
void calc_p1();
void calc_opp_p1();
void calc_p1_adjusted();
void calc_p2();
void calc_opp_p2();
void calc_p2_adjusted();
void calc_dp();
void calc_irr();
void calc_dp2();
void calc_irr2();
void calc_opp_dp();
void calc_opp_irr();
void calc_receptive_mate();
void calc_den();
void calc_den_r();
void calc_edge();
void calc_explore_direction();
void calc_all_directions();
void calc_cover();

void setup_strategy();

int getline();

/* the animal's action chosen by the strategy */
int action;

/* global variables to store the values passed in to behave_choice */

/* properties of current situation of environment */
/* properties of current situation of environment */
double fat_minus,
	  carbo_minus,
	  protein_minus,
	  water_minus,
	  an_temp_minus,
	  an_temp_plus,
	  sqr_temp_minus,
	  sqr_temp_plus,
	  mate_courtedness,
	  cleanliness,
	  night_prox,
	  variance,
	  den_distance,
	  scan_time,
	  cover_distance,
	  time_since_predator,
	  health,
	  p_injury;

/* maximum values (over all directions) of all stimuli that are direction
dependent */
double max_food_perc_stimulus,
	   max_food_memory_stimulus,
	   max_water_perc_stimulus,
	   max_water_memory_stimulus,
	   max_shelter_perc_stimulus,
	   max_shade_perc_stimulus,
	   max_p1_perc_stimulus,
	   max_p2_perc_stimulus,
	   max_dp_perc_stimulus,
	   max_irr_perc_stimulus,
	   max_mate_perc_stimulus,
	   max_den_perc_stimulus,
	   max_den_memory_stimulus,
	   max_edge_perc_stimulus;

double temp_minus_max = 0.0, temp_plus_max = 0.0;

int num_times_get_food_chosen = 0;
int num_times_cleaning_chosen = 0;

extern int prey_in_animal_square,
		   cf_in_animal_square,
		   ff_in_animal_square;

/*g*/void update_strategy_display();

void get_maxs_and_dirs();

void add_directed_external_sensor_input();

/*g*//* fonts for program */
/*g*/struct pixfont *screen_r_7;
/*g*/
/*g*//* arrays for colourmap */
/*g*/extern u_char red[CMAP_SIZE], green[CMAP_SIZE], blue[CMAP_SIZE];

/*g*/Frame long_profile_frame;
/*g*/Frame long_profile_frame2;
/*g*/
/*g*/Canvas long_profile_canvas;
/*g*/Canvas long_profile_canvas2;
/*g*/
/*g*/Pixwin *long_profile_pw;
/*g*/Pixwin *long_profile_pw2;
/*g*/
/*g*/void set_up_long_profile(),
/*g*/    set_up_long_profile2(),
/*g*/    update_long_profile(),
/*g*/    update_long_profile2(),
/*g*/    draw_lpd_blob(),
/*g*/    delete_lpd_blobs();
/*g*/
/*g*//* position in which to plot activations for each system on each */
/*g*//* longitudinal profile */
/*g*/int lpd_position;
/*g*/
/*g*//* activations used for drawing longitudinal profiles */
/*g*/double lpd_acts[NUM_SYSTEMS_FOR_LPD];
/*g*/double lpd_acts2[NUM_SYSTEMS_FOR_LPD];
/*g*/
/*g*/void profile_change_proc();
/*g*/int profile_display_on;

/*g*/int old_lpd_x[NUM_SYSTEMS_FOR_LPD], old_lpd_y[NUM_SYSTEMS_FOR_LPD];
/*g*/int old_lpd_x2[NUM_SYSTEMS_FOR_LPD], old_lpd_y2[NUM_SYSTEMS_FOR_LPD];

/* inputs and multiple inputs to a node */
double is[MAX_NUM_IN_LINKS];
double m_is[MAX_NUM_IN_LINKS][8];

double vector_max(),
	   vector_min(),
	   vector_sum();

double combine_explore_inputs();
double combine_rest_inputs();
double combine_freeze_inputs();
double combine_court_inputs();
double combine_mate_inputs();
double combine_look_inputs();
double combine_move_inputs();
double combine_move_fast_inputs();

/*g*/int sub_sys_node_num[13];


