
/* file to define macros for functions implementing Rosenblatt & Payton's
behaviour selection mechanism */

#define INT_SENSORS_FNAME				"../asm/internal_sensors"
#define EXT_SENSORS_FNAME				"../asm/external_sensors"
#define INDET_SENSORS_FNAME				"../asm/indeterminate_sensors"
#define DIRECTED_EXT_SENSORS_FNAME		"../asm/directed_external_sensors"
#define TOP_LEVEL_NODES_FNAME			"../asm/top_level_nodes"
#define INTERMEDIATE_NODES_FNAME		"../asm/intermediate_nodes"
#define BOTTOM_LEVEL_NODES_FNAME		"../asm/bottom_level_nodes"
#define LINKS_FNAME						"../asm/links"

#define MAX_NUM_SENSORS					200

#define MAX_NUM_NODES					500

#define MAX_NUM_LINKS					2000

#define MAX_NUM_IN_LINKS				200

#define MAX_LINE_LENGTH					200

/* identifying numbers for different types of entity in the network */
#define NODE							1
#define MULTIPLE_NODE					2		/* i.e. directed */
#define INTERNAL_SENSOR					3
#define EXTERNAL_SENSOR					4
#define INDETERMINATE_SENSOR			5
#define DIRECTED_EXTERNAL_SENSOR		6

/* identifying numbers for different types of node */
#define TOP_LEVEL						1
#define INTERMEDIATE					2
#define BOTTOM_LEVEL					3


/* definitions for the longitudinal profile display */
#define LPD_ROW_HEIGHT					36
#define LPD_GRAPH_HEIGHT				(LPD_ROW_HEIGHT-18)
#define NUM_SYSTEMS_FOR_LPD				35
#define LDP_WIDTH						300		/* multiple of three */
#define EXTRA							(LDP_WIDTH+5)

