;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: table -*-
#|

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: EL-in-CL: table
-----------------------------------------------------------------------------------
File:    table.em
Version: 2.0 (last modification on Tue Jan  4 11:33:49 1994)
State:   proposed

DESCRIPTION:


DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ulrich Kriegel

CONTACT: 


HISTORY:
 
revised 03/12/1992 by *wh*

Log for /export/home/saturn/ukriegel/Eu2C/EulispModules/table.em[2.0]:
  
[1.1] Wed Mar 10 13:13:30 1993 imohr@isst proposed
  [Mon Mar  8 14:36:49 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Thu Jun 17 15:22:09 1993 imohr@isst published
  [Thu Jun 17 15:18:25 1993] Intention for change:
  + #module-end
[1.3] Tue Jan  4 11:34:04 1994 wheick@isst published
  [Tue Nov  9 09:32:37 1993] Intention for change:
  complete like 0.99: new slots
[2.0] Tue Jan  4 11:34:04 1994 wheick@isst proposed
  [Tue Nov  9 09:32:37 1993] Intention for change:
  complete like 0.99: new slots

-----------------------------------------------------------------------------------
|#

#module table
#module-import

(import
 (eulisp-kernel
  (only (make-hash-table make-instance values gethash typep 
                         eql remhash clrhash maphash) 
    common-lisp)
  )
 
 syntax 
 (eulisp-kernel
  (rename 
    ((defun cl:defun) (defmethod cl:defmethod))
    common-lisp)
  (only 
    (&optional 
     defclass
     setf
     defsetf
     ;    defmethod
     )
    common-lisp))
 
 export
 (<table> make-table table-ref setter-table-ref
          tablep table-delete clear-table)
 )



(export <table> make-table table-ref setter-table-ref
        tablep table-delete clear-table)

(defclass <table>
  ()
  ((hash-table :reader table-hash-table-reader
               :writer table-hash-table-writer)
   (comparator :initarg  :comparator)
   (fill-value :initarg :fill-value
               :initform ()
               :reader ?fill-value)
   (hash-function :initarg :hash-function
                  :initform :hash-function
                  :reader ?hash-function)
   ))

(cl:defun make-table
       (&optional (comparator #'eql) (fill-value ())
                  (hash-function ()))
  (let ((tbl (make-instance '<table> 
               :comparator comparator
               :fill-value fill-value
               :hash-function hash-function))
        (htbl (make-hash-table :test comparator)))
    (table-hash-table-writer htbl tbl)
;    (setf (slot-value tbl 'comparator) comparator)
    tbl))

(cl:defmethod table-ref
           ((table <table>) key-obj)
  (values (gethash key-obj 
                   (table-hash-table-reader table) 
                   (?fill-value table))))

(cl:defmethod setter-table-ref ((table <table>) key value)
  (setf (gethash key (table-hash-table-reader table)) value))

(defsetf table-ref (table key) (value)
  `(setter-table-ref ,table ,key ,value))

(defun tablep(o)
  (typep o '<table>))

(defmethod table-delete 
           ((table <table>) key)
  (remhash key (table-hash-table-reader table)))

(defmethod clear-table 
           ((table <table>))
  (clrhash (table-hash-table-reader table))table)

(defmethod map-table 
           (function (table <table>))
  (maphash function (table-hash-table-reader table)))

#module-end
