;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: symbol -*-
#|

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: EL-in-CL: symbol
-----------------------------------------------------------------------------------
File:    symbol.em
Version: 2.0 (last modification on Tue Jan  4 11:32:30 1994)
State:   proposed

DESCRIPTION:


DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/EulispModules/symbol.em[2.0]:
  
[1.1] Wed Mar 10 13:13:17 1993 imohr@isst proposed
  [Mon Mar  8 14:36:41 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Fri Sep  3 16:48:15 1993 imohr@isst published
  [Fri Sep  3 15:34:24 1993] Intention for change:
  symbolp must exclude the empty list
  now symbolp has the semantic as in EuLisp
[1.3] Tue Jan  4 11:32:51 1994 wheick@isst published
  [Fri Nov 12 09:21:19 1993] Intention for change:
  new header
[2.0] Tue Jan  4 11:32:51 1994 wheick@isst proposed
  [Fri Nov 12 09:21:19 1993] Intention for change:
  new header

-----------------------------------------------------------------------------------
|#

#module symbol

(import
 (eulisp-kernel
  ;compare
  (only (intern find-symbol eq) common-lisp)
  (rename ((gensym cl:gensym)) common-lisp))
 
 syntax 
 (eulisp-kernel
  (rename ((defun cl:defun) 
           (symbolp cl:symbolp)) common-lisp)
  (only (&optional) common-lisp))
 
 expose 
 ((only (symbol-name)
    common-lisp))
 
 export 
 (gensym symbol-exists-p symbolp)
 )

(make-eulisp-class symbol)

(defun symbolp (object)
  (if (eq object ())
    ()
    (cl:symbolp object)))

(cl:defun gensym (&optional string)
(intern (cl:string (if string 
                     (cl:gensym (cl:string string)) 
                     (cl:gensym))) 
        $eulisp-symbol-package))

(defun symbol-exists-p (name)
(find-symbol name $eulisp-symbol-package))


#module-end

