;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: spint -*-
#|

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: EL-in-CL: module spint
-----------------------------------------------------------------------------------
File:    spint.em
Version: 2.0 (last modification on Wed Nov  3 16:26:04 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:
In Franz Allegro (Unix) the class <spint> must be mapped to the CL-class
INTEGER, because a class FIXNUM doesn't exists

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/EulispModules/spint.em[2.0]:
  
[1.1] Wed Mar 10 13:13:00 1993 imohr@isst proposed
  [Mon Mar  8 14:36:16 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Wed Sep  1 07:31:44 1993 ukriegel@isst published
  [Tue Aug 31 14:01:25 1993] Intention for change:
  :cmu
  done
[1.3] Thu Nov 18 15:23:42 1993 imohr@isst proposed
  new style module syntax
[2.0] Thu Nov 18 15:23:42 1993 imohr@isst proposed
  new style module syntax

-----------------------------------------------------------------------------------
|#

;#module-name spint
;#module-import
;(eulisp-kernel
; (only (fixnump) ccl)
; #+(and :ALLEGRO :FRANZ-INC)
; (only (find-class class-name) common-lisp)
; #+:cmu
; (only (find-class class-name) pcl)
; number)
;#module-syntax-import 
;(eulisp-kernel)
;#module-syntax-definitions
;
;#module-header-end

#module spint
(import (eulisp-kernel
         (only (fixnump) ccl)
         #+(and :ALLEGRO :FRANZ-INC)
         (only (find-class class-name) common-lisp)
         #+:cmu
         (only (find-class class-name) pcl)
         number)
 syntax (eulisp-kernel)
 export (single-precision-integer-p)
 expose ((only (evenp oddp)
           common-lisp)))


#-(or :cmu (and :ALLEGRO :FRANZ-INC))
(progn
  (make-eulisp-class spint fixnum) 
; the alias with a short namemust appear before the following assignment, to
; rename the CL-class to single-precision-integer and not to spint
  (make-eulisp-class single-precision-integer fixnum)
)

#+(or :cmu (and :ALLEGRO :FRANZ-INC))
(progn 
  (export <single-precision-integer>) 
  (export <spint>)
  (defconstant <single-precision-integer> (find-class 'cl:integer))
  (defconstant <spint> (find-class 'cl:integer))
  (setf (find-class '<single-precision-integer>) <single-precision-integer>)
  (setf (find-class '<spint>) <spint>)
)


(defun single-precision-integer-p (x) 
  (fixnump x))

#module-end


