;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: list -*-
#|

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: EL-in-CL: module list
-----------------------------------------------------------------------------------
File:    list.em
Version: 
State:   

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 

-----------------------------------------------------------------------------------
|#

#module list

(import 
 (eulisp-kernel
  (only (<symbol>) symbol) 
  (only (<number>) number) 
  (only (<character>) character)
  (only (cons car cdr copy-list) common-lisp)
  copy-generic ;deep-copy shallow-copy
  )

 syntax 
 (eulisp-kernel)
 
 expose 
 ((only (consp 
         atom 
         cons 
         car 
         cdr 
         list 
         length ; not in EL
         equal
         copy-list ; not in EL
         ;copy-alist 
         ;copy-tree
         )
    common-lisp)
  (only ($empty-list) el-modules)
  (only (null) common-lisp))

 export
 (nil deep-copy shallow-copy)
 )


(make-eulisp-class pair cons) ; not in EL

(make-eulisp-class cons cons) 

(make-eulisp-class null)

(make-eulisp-class list list)

(defconstant nil () )

(defmethod deep-copy ((tree cons))
      (cons (deep-copy (car tree)) 
            (deep-copy (cdr tree))))

(defmethod deep-copy ((tree <null>))
  nil)

(defmethod deep-copy ((tree <symbol>))
  tree)

(defmethod deep-copy ((tree <number>))
  tree)

(defmethod deep-copy ((tree <character>))
  tree)

(defmethod shallow-copy ((tree <null>))
  nil)

(defmethod shallow-copy ((tree <cons>))
  (copy-list tree))


#module-end

