;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: eulisp-kernel -*-
#|

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: EL-in-CL: The kernel of EuLisp
-----------------------------------------------------------------------------------
File:    eulisp-kernel.em
Version: 2.0 (last modification on Tue Jan  4 11:27:59 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:
The commented pieces of code marked with "compile-during-load" should be
activated if compilation during load is needed for Franz Allegro on SUN.

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/EulispModules/eulisp-kernel.em[2.0]:
  
[1.1] Wed Mar 10 13:12:11 1993 imohr@isst proposed
  [Mon Mar  8 14:35:01 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Wed May 12 18:31:01 1993 imohr@isst saved
  [Wed May 12 18:30:36 1993] Intention for change:
  compilation of defun and defmethod during load (for Franz Allegro needed)
  ok
[1.3] Fri May 14 11:46:45 1993 imohr@isst proposed
  ok
[1.4] Fri May 14 15:40:34 1993 imohr@isst proposed
  [Fri May 14 13:50:51 1993] Intention for change:
  compilation of defuns and defmethods only for franz allegro
  ok
[1.5] Mon May 24 09:55:46 1993 imohr@isst published
  [Mon May 24 09:48:45 1993] Intention for change:
  - automatic compilation during load for franz allegro
  ok
[1.6] Tue Oct 12 13:07:10 1993 imohr@isst published
  [Tue Oct 12 11:16:25 1993] Intention for change:
  using defvar and defparameter for global lexical bindings if the name starts with
  non alphanumeric characters (for franz allegro only, this make global bindings
  special in any case)
[1.7] Tue Jan  4 11:28:13 1994 wheick@isst published
  [Fri Nov 12 08:39:54 1993] Intention for change:
  new module header
[2.0] Tue Jan  4 11:28:13 1994 wheick@isst proposed
  [Fri Nov 12 08:39:54 1993] Intention for change:
  new module header 

-----------------------------------------------------------------------------------
|#

#module eulisp-kernel

(import
 ((only
    (null symbolp first cons list rest
          t)
    common-lisp)
  (rename ((defun cl:defun)
           (defmacro cl:defmacro)) common-lisp)
  el-modules)
 
 syntax
 (el-modules
  (only (&rest
         cond progn setq
	 defvar) 
    common-lisp)
  (rename ((lambda cl:lambda)
           (compile cl:compile))
    common-lisp))
 
 
 expose 
 (el-modules 
  (only
    (t
     defconstant
     quote
     setq setf
     if cond and or progn
     let let* labels flet
     unwind-protect
     next-method-p call-next-method
     funcall apply)
    common-lisp))

 )

;;; -----------------------------------------------------------------------------------
;;; <object>: the root of the inheritance tree
;;; -----------------------------------------------------------------------------------

(make-eulisp-class object t)

;;; -----------------------------------------------------------------------------------
;;; Defining Forms
;;; -----------------------------------------------------------------------------------


(export-syntax defmacro deflocalmacro defun lambda deflocal defgeneric defmethod)

(cl:defun make-cl-lambda-list (el-lambda-list)
(cond ((null el-lambda-list) ())
      ((symbolp el-lambda-list) (list '&rest el-lambda-list))
      (t (cons (first el-lambda-list)
               (make-cl-lambda-list (rest el-lambda-list))))))

(cl:defmacro defmacro (name lambda-list . body)
`(progn (export-syntax ,name)
        (cl:defmacro ,name ,(make-cl-lambda-list lambda-list) ,@body)))

(cl:defmacro deflocalmacro (name lambda-list . body)
`(cl:defmacro ,name ,(make-cl-lambda-list lambda-list) ,@body))

(cl:defmacro defun (name lambda-list . body)
`(cl:defun ,name ,(make-cl-lambda-list lambda-list) ,@body))

(cl:defmacro lambda (lambda-list . body)
`#'(cl:lambda ,(make-cl-lambda-list lambda-list),@body))

(cl:defmacro deflocal (name value)
  ;franz allegro makes global bindings (simple setq's) special in any
  ;case when compiling files
  ;the direct usage of defvar avoids unnecessary warnings by the compiler
  ;but this requires that no local binding has the same name as a global binding
  ;which would result in shadowing global lexical bindings by local ones!!!
  `(#+(and :allegro :franz-inc)defvar
    #-(and :allegro :franz-inc)setq 
      ,name ,value))

(cl:defmacro defgeneric (name lambda-list)
`(cl:defgeneric ,name ,(make-cl-lambda-list lambda-list)))

(cl:defmacro defmethod (name lambda-list . body)
  `(cl:defmethod ,name ,(make-cl-lambda-list lambda-list) ,@body))


#module-end

