;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: dynamic075 -*-
#|

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: EL-in-CL: dynamic bindings for Level1
-----------------------------------------------------------------------------------
File:    dynamic075.em
Version: 2.0 (last modification on Thu Jan 13 10:59:11 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/EulispModules/dynamic075.em[2.0]:
  
[2.0] Thu Jan 13 11:45:04 1994 wheick@isst proposed
  

-----------------------------------------------------------------------------------
|#

#module dynamic075

(import
 (eulisp-kernel pair symbol null pair-ext)

 syntax 
 (eulisp-kernel
  list-ext
  (only (declare special) common-lisp)
  (rename ((defvar cl:defvar)) common-lisp))
)

;defined macros: defvar dynamic dynamic-let dynamic-setq

(defun make-dynamic-id (id)
(make-eulisp-symbol id))

(defmacro defvar (id init)
`(progn 
   (cl:defvar ,(make-dynamic-id id))
   (setq ,(make-dynamic-id id) ,init)))

(defmacro dynamic (id) (make-dynamic-id id))

(cl:defvar *dynamics* nil)

(defun make-and-collect-dynamic-id (id)
(let ((dyn-id (make-dynamic-id id)))
   (push dyn-id *dynamics*)
   dyn-id))

(defmacro dynamic-let (vars . body)
(let ((*dynamics* nil))
  `(let ,(make-dynamic-let-vars vars)
	(declare (special ,@*dynamics*))
	,@body)))

(defun make-dynamic-let-vars (vars)
(cond ((null vars) nil)
      ((symbolp (car vars))
	 (cons (make-and-collect-dynamic-id (car vars))
	       (make-dynamic-let-vars (cdr vars))))
      (t (cons `(,(make-and-collect-dynamic-id (caar vars)) ,(cadar vars))
	       (make-dynamic-let-vars (cdr vars))))))

(defmacro dynamic-setq (var form)
`(setq ,(make-dynamic-id var) ,form))

#module-end
