
;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: character -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: standard module character
-----------------------------------------------------------------------------------
File:    character.em
Version: 2.0 (last modification on Mon Mar 14 09:14:40 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr


-----------------------------------------------------------------------------------
|#

#module character

(syntax 
  (eulisp-kernel)

  import
  (eulisp-kernel
   (only (binary<) compare-generic)
   character-generic  ; as-lowercase as-uppercase
   (only (char-downcase char-upcase char<) 
     common-lisp)) 
  
  expose 
  ((only (characterp 
         equal 
         copy ; not in EL
         )
    common-lisp))
  
  export 
  (as-lowercase as-uppercase binary<)
  )

(make-eulisp-class character)

(defmethod as-lowercase ((object <character>))
  (char-downcase object)
  )

(defmethod as-uppercase ((object <character>))
  (char-upcase object)
  )

(defmethod binary< ((c1 <character>) (c2 <character>))
  (char< c1 c2))

#module-end
