/*

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.



--------------------------------------------------------------------------------TITLE: xalloc internal definitions
--------------------------------------------------------------------------------File:    xalloc_misc.h
Version: 1.16 (last modification on Thu Jun  2 08:52:13 1994)
State:   proposed


DESCRIPTION:
contains macros to be used in xalloc functions since they are separeted into
several modules. NOT to be used by outside user


DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
j.bimberg

CONTACT: 
j.bimberg
e.u.kriegel
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/ApplyC/xalloc_misc.h[1.16]:
  
[1.1] Wed Jun  9 16:48:05 1993 ukriegel@isst saved
  sun_stacktop
[1.2] Wed Jul 14 19:28:46 1993 ukriegel@isst saved
  [Wed Jul 14 19:24:50 1993] Intention for change:
  cast in p_in_heap
[1.3] Fri Jul 16 09:39:24 1993 ukriegel@isst proposed
  [Thu Jul 15 14:14:09 1993] Intention for change:
  ansi
  ansi and K & R save, K & R need flag KRC
[1.4] Fri Jul 16 13:27:04 1993 ukriegel@isst published
  [Fri Jul 16 11:11:32 1993] Intention for change:
  #endif
[1.5] Wed Oct 13 13:27:23 1993 jbimberg@isst published
  [Wed Oct 13 12:57:40 1993] Intention for change:
  changing "sun_stacktop" to "stacktop"
  and inserted a macro to get the stack pointer
  
[1.6] Fri Nov 19 11:36:57 1993 ukriegel@isst proposed
  [Fri Nov 19 09:48:36 1993] Intention for change:
  add nb_of_gc
  done
[1.7] Wed Dec  1 12:59:23 1993 jbimberg@isst proposed
  [Mon Nov 22 14:07:46 1993] Intention for change:
  disabling alloc during collect
  done, added stuff to allow thread-private cards
[1.8] Wed Dec  8 15:17:58 1993 jbimberg@isst proposed
  [Wed Dec  8 15:14:52 1993] Intention for change:
  refining define NOTHREADS
  done
[1.9] Thu Jan  6 12:38:51 1994 jbimberg@isst saved
  [Thu Jan  6 12:35:46 1994] Intention for change:
  insert MT-card alignment macros
  done
[1.10] Fri Jan 21 15:15:58 1994 jbimberg@isst saved
  [Fri Jan 21 15:11:35 1994] Intention for change:
  new attempt for thread synchronisation
  done
[1.11] Mon Feb  7 09:45:33 1994 jbimberg@isst published
  [Mon Jan 31 12:17:46 1994] Intention for change:
  insert header, remove thread concerning stuff
  done
[1.12] Wed Feb  9 09:32:44 1994 jbimberg@isst proposed
  [Wed Feb  9 09:27:59 1994] Intention for change:
  define bzero arch's that don't have it
[1.13] Wed Feb  9 16:09:28 1994 jbimberg@isst proposed
  [Wed Feb  9 16:08:08 1994] Intention for change:
  enable pointers into the middle of objects
[1.14] Fri Mar 25 15:28:42 1994 jbimberg@isst saved
  [Mon Mar 21 09:02:12 1994] Intention for change:
  remove the sweeping phase
[1.15] Tue Apr  5 09:32:33 1994 jbimberg@isst proposed
  [Mon Mar 28 14:10:18 1994] Intention for change:
  enable multiple fsl's
[1.16] Thu Jun  2 08:52:50 1994 jbimberg@isst proposed
  [Thu Jun  2 08:50:43 1994] Intention for change:
  include xalloc_th.h only if defined multi-fsl 

--------------------------------------------------------------------------------
*/

#ifndef	xalloc_misc_h
#define xalloc_misc_h

#include "xalloc_user.h"	/* def's of STSS ..., prototypes */
#include "xalloc_conf.h"
#include "thread.h"
#ifdef MULTI_FSL
/* a closer connection between threads and xalloc takes place */
#include "xalloc_th.h"
#endif


/* Some simple sizes and macros to be found anywhere */

#ifndef	NULL
#define	NULL	0
#endif
#define WORD_SIZE 32
#define LOG_WORD_SIZE 5
#define BITS_PER_BYTE 8
#define LOG_BITS_PER_BYTE 3
#define LOG_BYTES_PER_WORD (LOG_WORD_SIZE - LOG_BITS_PER_BYTE)

#define byte2word(s) (((s) + 3)>>2)
#define word2byte(s) ((s) << 2)

#define	isset(w,b)	((w) & (1<<(b)))
#define	set(w,b)	((w) |= (1<<(b)))
#define	reset(w,b)	((w) &= ~(1<<(b)))

#define	max(x,y)	(((x) > (y))? (x) : (y))
#define min(x,y)	(((x) < (y))? (x) : (y))

/* ---------------- Sizes to be used here, type-definitions ---------------- */

#define CARDMASK	(CARDSIZE - 1)
#define CARD_ADDR(p)	((card *) ((long)(p) & ~CARDMASK))

#define NB_OF_MARK_WORDS (byte2word(CARDSIZE)/WORD_SIZE)

typedef struct _CardHeader {
	struct _Card	**card_index;		/* ptr to card reference-list*/
	long 		object_size;		/* size in words */
	long 		object_byte_size;	/* object-size in bytes */
	long 		card_nb;		/* nb of basic cards */
	long 		type_descriptor;
	long 		object_mask;		/* mask for fast pointer test */
	struct _Card 	*next_card;		/* to link cards together */
	long 		markbits[NB_OF_MARK_WORDS];
	} CardHeader;

#define root 		header.card_index
#define size 		header.object_size
#define bytesize 	header.object_byte_size
#define cardnum		header.card_nb
#define type_dscr 	header.type_descriptor
#define mask 		header.object_mask
#define next 		header.next_card 
#define	mkarea		header.markbits

#define USERSPACE	(byte2word(CARDSIZE - sizeof(CardHeader)))

typedef struct _Card {
		CardHeader header;
	        long	userspace[USERSPACE];
		} card;

#define	basiccards(s)	(((s) <= USERSPACE) ? 1 \
			: (((s) - USERSPACE) / (byte2word(CARDSIZE)) + 2))

/* some macros to handle information on cards */

#define	get_size(c)	((c)->size)
#define	get_mask(c)	((c)->mask)
#define get_tdscr(c)	((c)->type_dscr)
#define get_cardnum(c)	((c)->cardnum)

#define	ms_card(c)	(get_size(c) == 0)
#define	mt_card(c)	(get_tdscr(c) == 0)

#define	get_ms_real_size(p)	(word2byte(*((long *)(p)-1)-1))
#define get_real_size(c)	((c)->bytesize)

#define	put_size(c,s)		((c)->size = (s))
#define	put_tdscr(c,t)		((c)->type_dscr = (t))
#define put_cardnum(c,n)	((c)->cardnum = (n))
#define	put_real_size(c,s)	((c)->bytesize = (s))

#define	into_card_list(cd,c)	((c)->next = get_card_d(cd), store_card_d(cd,c))
#define	into_full_list(cd,c)	((c)->next = get_full_d(cd), store_full_d(cd,c))

#define off_card_list(cd,c)	store_card_d((cd), (c)->next) 

/* we need information about marking in xalloc.c, too,
 * because we use markbits another way on STMS */

#define	markword(c,p)	(((c)->mkarea)[((long)(p) & CARDMASK)>>\
				(LOG_WORD_SIZE+LOG_BYTES_PER_WORD)])
#define markbit(p)	(((long)(p)>>LOG_BYTES_PER_WORD) & (WORD_SIZE-1))

#define	ismarked(c,p)	isset(markword(c,p), markbit(p))
#define mark(c,p)	set(markword(c,p), markbit(p))
#define	unmark(c,p)	reset(markword(c,p), markbit(p))

#define large_unmark(c)	((c)->mkarea[0] = 0)	/* faster than mask first bit */

#ifndef __sparc__
#define bzero(p, n)	memset((p), 0, (n))
#endif

#define clear_marks(c)	bzero((c)->mkarea, NB_OF_MARK_WORDS * sizeof(long))

/* some macros to test values to be pointers */

#define	is_pointer(p)	(((long)(p) > 0) && (((long)(p) & 3) == 0))

#define	p_in_heap(p)	(((((long)(p)) & 3) == 0)\
			&& ((p) > HEAPBEGIN)\
			&& ((p) < HEAPEND))

#define	living_card(c)	(((long)((c)->root) >= (long)first_card_index)\
			 && ((long)((c)->root) < (long)last_card_index)\
			 && (*((c)->root) == (c)))


#ifdef USE_LARGE
#ifdef OPTIMIZED_POINTER_TESTS

#define consistent_pointer(c,p,s,m) ((((long)(p) & (m)) == 0) ||	\
	((((long *)(c) + byte2word(CARDSIZE) - (p)) % (s)) == 0) ||	\
			(((s) > USERSPACE) && ((p) == ((c)->userspace))))
#define obj_begin(c,p,s,m) (((s) > USERSPACE) ? (c)->userspace : \
			    ((m) != DEFAULT_MASK) ? (long)(p) & ~(m) : \
	(p) + 1 + (((long *)(c) + byte2word(CARDSIZE) - 1 - (p)) % (s)) - (s))

#else	/* argument m is never used */

#define consistent_pointer(c,p,s,m) (\
		((((long *)(c) + byte2word(CARDSIZE) - (p)) % (s)) == 0) || \
			(((s) > USERSPACE) && ((p) == ((c)->userspace))))
#define obj_begin(c,p,s,m) (((s) > USERSPACE) ? (c)->userspace : \
	(p) + 1 + (((long *)(c) + byte2word(CARDSIZE) - 1 - (p)) % (s)) - (s))

#endif 	/* OPTIMIZED_POINTER_TESTS */

#else	/* no large objects */

#ifdef OPTIMIZED_POINTER_TESTS

#define consistent_pointer(c,p,s,m) ((((long)(p) & (m)) == 0) ||	\
		((((long *)(c) + byte2word(CARDSIZE) - (p)) % (s)) == 0))
#define obj_begin(c,p,s,m) (((m) != DEFAULT_MASK) ? (long)(p) & ~(m) : \
	(p) + 1 + (((long *)(c) + byte2word(CARDSIZE) - 1 - (p)) % (s)) - (s))

#else	/* argument m is never used */

#define consistent_pointer(c,p,s,m) (\
		 (((long *)(c) + byte2word(CARDSIZE) - (p)) % (s)) == 0)
#define obj_begin(c,p,s,m) (\
	(p) + 1 + (((long *)(c) + byte2word(CARDSIZE) - 1 - (p)) % (s)) - (s))

#endif 	/* OPTIMIZED_POINTER_TESTS */

#endif 	/* USE_LARGE */

#ifdef	USE_STMS
#define consistent_ms_pointer(c,p)	ismarked((c),(p)-1)
#endif	/* USE_STMS */


/* for importer here the defs of our arrays. don't want to deal with them
 * during garbage_collections, so enabling to skip them easily. B/W again...
 */

struct _gcarrays {
	card           *S_Cards[HIGHEST_CARDDSCR + 1];
#ifdef SKIP_SWEEP
	card           *S_Fulls[HIGHEST_CARDDSCR + 1];
#endif
#ifndef MULTI_FSL
	long           *S_Freepts[HIGHEST_CARDDSCR + 1];
#endif
	TypeDscr        S_Types[HIGHEST_CARDDSCR + 1];
	long            S_Sizes[HIGHEST_CARDDSCR + 1];
	unsigned long	S_UTypes[HIGHEST_TYPEDSCR + 1];
	void            (*S_MkFcns[HIGHEST_TYPEDSCR + 1]) ();
	card           *S_usedcards[MAX_NUM_OF_CARDS];
} gcarrays;

#define Cards		gcarrays.S_Cards
#define Fulls		gcarrays.S_Fulls
#define Freepts		gcarrays.S_Freepts
#define Types		gcarrays.S_Types
#define Sizes		gcarrays.S_Sizes
#define UTypes		gcarrays.S_UTypes
#define	MkFcns		gcarrays.S_MkFcns
#define usedcards	gcarrays.S_usedcards

#define	gcarraybegin	(long *)(&gcarrays)
#define	gcarrayend	(long *)((char *)(&gcarrays) + sizeof(gcarrays))

card	      **used_cards_end;

CardDscr	last_used_card;
TypeDscr	last_used_type;

#define is_tdscr(td)	(((td)>0) && ((td)<last_used_type))
#define is_cdscr(cd)	(((cd)>=0) && ((cd)<last_used_card))

/* some macros to handle information hold in these arrays */

#ifndef MULTI_FSL
#define	get_free_object(cd)	(Freepts[cd])
#define	get_freept_addr(cd)	(&Freepts[cd])
#define	store_free_object(cd,o)	Freepts[cd] = (o)
#endif

#define	get_type_d(cd)		(Types[cd])	
#define	get_size_d(cd)		(Sizes[cd])
#define	get_card_d(cd)		(Cards[cd])
#define	get_full_d(cd)		(Fulls[cd])

#define	ms_card_d(cd)		(! get_size_d(cd))
#define mt_card_d(cd)		(! get_type_d(cd))

#define	store_type_d(cd,t)	Types[cd] = (t)
#define	store_size_d(cd,s)	Sizes[cd] = (s)
#define	store_card_d(cd,c)	Cards[cd] = (c)
#define	store_full_d(cd,c)	Fulls[cd] = (c)

#define	store_mark_fcn(td,f)	(MkFcns[td] = f)
#define	store_user_type(td, t)	(UTypes[td] = t)

#define	get_mark_fcn(td)	(MkFcns[td])
#define	get_user_type(td)	(UTypes[td])

#define	first_card_index	usedcards
#define last_card_index		used_cards_end
#define next_card_index(c)	++c
#define	prev_card_index(c)	--c



/* alignment forcing if high alignment is necessary, normally 4-byte-alignment
   should be enough, but it may be set to sizeof(double) or what I know */

#ifndef MT_ALIGNMENT
#define MT_ALIGNMENT	4
#endif

#define MT_ALIGN_WORDS		byte2word(MT_ALIGNMENT)
#define MT_AL_MASK		(MT_ALIGN_WORDS - 1)

/* increase x up to a multiple of MT_ALIGN_WORDS and by another MT_ALIGN_WORDS
   words to hold type information */
#define MT_ALIGN(x)	(((x + (MT_AL_MASK)) & ~(MT_AL_MASK)) + MT_ALIGN_WORDS)

/* Macros to do some jobs needed in different functions */

#define	register_card(c)	(c)->root = last_card_index, \
				*last_card_index = (c), \
				next_card_index(last_card_index)

#define	DEFAULT_MASK	-1
#define	set_default_mask(c)	((c)->mask = DEFAULT_MASK)

#ifdef OPTIMIZED_POINTER_TESTS
#define set_mask(c)	    \
{  switch(get_size(c))      \
     { case 1:              \
	 c->mask = 0x3;     \
	 break;             \
       case 2:              \
	 c->mask = 0x7;     \
	 break;             \
       case 4:              \
	 c->mask = 0xf;     \
	 break;             \
       case 8:              \
	 c->mask = 0x1f;    \
	 break;             \
       default:             \
	 set_default_mask(c);}     \
}
#else
#define set_mask(c)	set_default_mask(c)
#endif

#ifdef	USE_STMS
/* variable spaces contain pointer to next space and their own length.
 * variable objects of size 1 are not allowed */
typedef	struct _vobject {
		struct _vobject *vnext;
		long		vlength;
		} vobject;

#endif

/* ------------------ vars and prototypes from heap-module ----------------- */

long	*HEAPBEGIN, *HEAPEND;
long	hincr, curnumcard;
#ifdef KRC
/*Version for Kenighan Ritchie */
long	inc_heap_size();
#else
/* ANSI C */
long	inc_heap_size(int noc);
#endif
#define	inc_heap()	inc_heap_size(hincr)

void	initialize_heap();

long	*new_card();
long	*new_large_card();

void	reclaim_card();

/* --- a function that is defined in xalloc.c and used in card.c as well --- */

long * build_free_list();


/* --------- global vars for statistics ----------------*/

int start_nb_of_cards;

#endif	/* ! xalloc_misc_h */
