/*


This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.



--------------------------------------------------------------------------------TITLE: xalloc configuration file
--------------------------------------------------------------------------------File:    xalloc_conf.h
Version: 1.16 (last modification on Wed Jul 13 10:15:32 1994)
State:   proposed


DESCRIPTION:
configuration of xalloc parameters like number of carddescriptors, used types

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
j.bimberg

CONTACT: 
j.bimberg
e.u.kriegel
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/ApplyC/xalloc_conf.h[1.16]:
  
[1.1] Thu May 27 14:50:09 1993 ukriegel@isst saved
  -
[1.2] Thu Jun 24 13:57:33 1993 ukriegel@isst saved
  security flag set
  enable large cards
[1.3] Thu Jul 15 13:48:42 1993 ukriegel@isst saved
  last c&r version
[1.4] Fri Jul 16 09:27:07 1993 ukriegel@isst proposed
  ansi and k& r save
[1.5] Mon Aug 23 09:28:42 1993 ukriegel@isst proposed
  [Tue Jul 20 17:05:43 1993] Intention for change:
  tests
[1.6] Thu Sep  2 11:26:38 1993 ukriegel@isst published
  [Thu Sep  2 11:20:27 1993] Intention for change:
  add MINHEAPBEGIN
  done
[1.7] Wed Oct 13 13:27:16 1993 jbimberg@isst proposed
  [Wed Oct 13 12:55:46 1993] Intention for change:
  changing "sun_stacktop" to "stacktop"
  
[1.8] Wed Oct 20 07:54:09 1993 ukriegel@isst published
  [Wed Oct 20 07:52:27 1993] Intention for change:
  increase maxrootsetentries
  done
[1.9] Fri Nov 19 14:55:16 1993 ukriegel@isst proposed
  [Fri Nov 19 14:30:37 1993] Intention for change:
  #ifdef START_NUM_OF_CARDS
  done
[1.10] Wed Dec  1 12:58:05 1993 jbimberg@isst proposed
  `added thread-stack-size and number-of-threads
[1.11] Wed Dec  8 15:09:14 1993 jbimberg@isst proposed
  [Wed Dec  8 15:07:00 1993] Intention for change:
  #define NOTHREADS
  #defined
[1.12] Wed Dec  8 16:13:49 1993 ukriegel@isst proposed
  [Wed Dec  8 16:13:02 1993] Intention for change:
  nothreads
  done
[1.13] Wed Dec  8 16:46:24 1993 ukriegel@isst proposed
  [Wed Dec  8 16:45:25 1993] Intention for change:
  undef security 
  done
[1.14] Thu Jan  6 12:49:43 1994 jbimberg@isst saved
  [Thu Jan  6 12:39:23 1994] Intention for change:
  insert #define MT_ALIGNMENT
  done
[1.15] Mon Feb  7 09:45:23 1994 jbimberg@isst published
  [Mon Jan 31 11:53:37 1994] Intention for change:
  insert header, remove thread stuff
  done
[1.16] Wed Jul 13 10:15:44 1994 jbimberg@isst proposed
  [Wed Jul 13 10:13:34 1994] Intention for change:
  define skip_sweep 

--------------------------------------------------------------------------------
*/
#ifndef	xalloc_conf_h
#define	xalloc_conf_h

#include <stdio.h>	/* for definition of stderr */


/* set a boundary for minimal heap address to reduce the chance of a wrong 
   pointer identification . the value is only used to set the brk. The actual
   heap begin will be aligned at card boundary */

#define MINHEAPBEGIN 0x10000


/* dimensions of some needed arrays and our heap, some constants */

		/* Smallest value to be returned by describe_type. Values
		 * between 1 and (SMALLEST_TYPEDSCR - 1) may be used for other
		 * purposes, usage of TypeDscr 0 is not allowed.
		 */
#define SMALLEST_TYPEDSCR	1

		/* Highest value to be returned by describe_type, dimension of
		 * internal type-array.
		 */
#define	HIGHEST_TYPEDSCR	4096

		/* same for cardtypes to be described by describe_card
		 */
#define SMALLEST_CARDDSCR	0
#define HIGHEST_CARDDSCR	4096

		/* There's no reason to set the size of the used Cards
		 * to the machines page size (as to get by get_page_size()),
		 * but it must be a power of 2 at least
		 */
#define	CARDSIZE	0x1000

		/* Maximum Heap size (in cards of CARDSIZE byte)
		 * including static cards
		 */
#define	MAX_NUM_OF_CARDS	1000

		/* Heapsize at begin of program execution. Negative or zero
		 * value will be set to 1 by the initialization function
		 */
#ifndef START_NUM_OF_CARDS
#define	START_NUM_OF_CARDS	16
#endif
		/* we increase our heap, if - after a garbage collection -
		 * more than GCMULT/GCDIFF of the current heap is still in use 
		 */
#define GCMULT	1
#define GCDIFF	3
	
		/* When our heap becomes to small we increase it by HMULT/HDIFF 
		 * of the current heap size (but at most up to MAX_NUM_OF_CARDS)
		 */
#define HMULT	1
#define HDIFF	1

/* ---------- how to deal with root addresses on static variables ---------- */

		/* define ROOT_SET_IN_USE, if you want to add each global or
		 * static variable to the root set yourself
		 * undefine it, when tracer should scan over all data
		 */
#define	ROOT_SET_IN_USE
#define	MAX_ROOT_SET_ENTRIES	8192	/* size of rootset */

/* ------- shall we test array-dimensions and function parameters ? -------- */

		/* it is recommended to define SECURITY_FIRST when you first
		 * test a new program, but the memory management works much
		 * faster without this (can be undefined in each single file)
		 */
/*#define	SECURITY_FIRST

/* --------------- shall we use optimized pointer tests ? ------------------ */

		/* Use this, when your favorite objects are small single_sized
		 * ones. Otherwise, optimized pointer tests have no positive
		 * effect, because normal pointer test will be done after this.
		 */
/*#define	OPTIMIZED_POINTER_TESTS

/* ---------------- where shall we put our mark stack ? -------------------- */
		/* when putting mark stack below the stack pointer
		 *	- program will exit on stack overflow
		 *	- mark functions are forbidden to call other functions
		 * when putting it above the current break
		 *	- program will crash when heap is exhausted
		 *	- marking works a bit faster
		 */
#define	STACK_ON_HEAP

		/* we leave a gap of STACKGAP bytes below the machines
		 * stack pointer when using stacksegment for our mark stack
		 */
#define	STACKGAP	1024

/* ----------------- usage of different kinds of cards --------------------- */

		/* undefine unused cardtypes here, memory management will be
		 * built to work as fast as possible by leaving conditions;
		 * but, of course, all sorts of cards can be used simultaneously
		 */
		
#define	USE_STSS	/* one card for any size/type-pair */

#define	USE_MTSS	/* one card for different types but same size */

#define	USE_STMS	/* one card for different sizes but same type */

#define	FAST_STMS	/* prefer gc to extensive search in free lists on stms*/

		/* Alignment forcing on MTSS-cards, if there's nothing defined
		 * here we set it to 4 internally, that's enough for pointers
		 * and long integers; for doubles it should be increased to 8. 
		 * Be sure not to set it to something else than a power of 2 !!
		 */
/* #define MT_ALIGNMENT	8 

		/* Undefine USE_LARGE, if any used object may be put onto one
		 * card of CARDSIZE byte. Note, that we actually need 32 byte
		 * on any card for header information, and one bit per long_word
		 * for the mark area. Here are some examples for maximum size
		 * of objects to be put on one single card:
		 *	CARDSIZE	HEAD+MARKBITS	Max. Objectsize
		 *	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		 *	8192		288		7904
		 *	4096		160		3936
		 *	2048		 96		1952
		 *	1024		 64		 960
		 *	 512		 48		 464
		 *	 256		 40		 216
		 * Note, that we increase object sizes by 4 byte
		 * on MTSS and STMS-cards
		 */

#define	USE_LARGE

/*  are we interested in printing heapsize to stderr (when we increase heap)? */

/*#define PRINTSIZES


/* are we interested in gc-reports ? */

/*#define GCREPORTS

 
/* ------------------- what to do on internal errors ? --------------------- */

#define	error(m) 	(fprintf(stderr,"%s Good bye!\n",m), exit(0))
#define error1(format,value) (fprintf(stderr,format,value), exit(0))



/* skip sweeping phase in gc, sweep during allocs */
#define SKIP_SWEEP


#endif	/* ! xalloc_conf_h */

