/*
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
--------------------------------------------------------------------------------TITLE: card allocation and reclaiming functions
--------------------------------------------------------------------------------File:    heap.c
Version: 1.4 (last modification on Wed Feb  9 08:37:11 1994)
State:   proposed


DESCRIPTION:


DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:
works (and links) only if sbrk is available

AUTHOR:
j.bimberg

CONTACT: 
j.bimberg
e.u.kriegel
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/ApplyC/heap.c[1.4]:
  
[1.1] Thu Sep  2 11:28:31 1993 ukriegel@isst published
  [Thu Sep  2 10:27:21 1993] Intention for change:
  add break to ensure heapbegin > 64k
  done
[1.2] Fri Nov 19 11:37:29 1993 ukriegel@isst proposed
  [Fri Nov 19 09:43:25 1993] Intention for change:
  new file for heap-init
  done
[1.3] Mon Feb  7 09:43:06 1994 jbimberg@isst published
  [Mon Jan 31 16:18:49 1994] Intention for change:
  insert header
  done, added header
[1.4] Wed Feb  9 08:56:46 1994 jbimberg@isst proposed
  [Wed Feb  9 08:35:20 1994] Intention for change:
  changes required by Symantec C++
  done 

--------------------------------------------------------------------------------
*/
#ifndef __NT__	/* there's a special heap-nt.c for this arch/os */
#include <stdio.h>
#include "xalloc_conf.h"
#include "xalloc_misc.h"


long	*FCL = NULL;	/* free card list , used only here and in heap-init.c*/

long
inc_heap_size(noc)		/* increase Heap by noc cards, but at most
				 * up to MAX_NUM_OF_CARDS, change hincr */
	register int	noc;
{
	register long	*s;	/* to hold the new segment */
	long offset;
	noc = max(1,noc);	/* increase heap by one card at least */
				/* maximum heap size already reached ? */
	if(curnumcard >= MAX_NUM_OF_CARDS)
		return(0);
				/* less than noc to get ? */
	if(curnumcard+noc > MAX_NUM_OF_CARDS)
		noc = MAX_NUM_OF_CARDS - curnumcard;
				/* align the current break at a multiple
				 * of CARDSIZE */
	offset = ((long)sbrk(0) & CARDMASK);
	if(offset)
		sbrk(CARDSIZE - offset);
				/* try to get the storage ...impossible ? */
	if((s = (long *)sbrk(noc * CARDSIZE)) == (long *)-1)
		return(0);
				/* succesful */
	curnumcard += noc;	/* increase current number of cards */
	s[0] = (long)FCL;	/* put new storage into FCL */
	s[1] = (long)noc;
	FCL = s;
	HEAPEND = (long *)sbrk(0);		/* increase HEAPEND */
	hincr = HMULT * curnumcard / HDIFF;	/* update heap_increment */
#ifdef	PRINTSIZES
	fprintf(stderr,"Heapsize is now %i byte.\n", curnumcard*CARDSIZE);
#endif
	return(noc);
}


long	*
new_card()
{
	register long	*c;
	if(FCL == NULL)
		return(NULL);		/* FCL empty */
	if(FCL[1] > 1){
		FCL[1]--;		/* leave all but one card there */
		return(&FCL[FCL[1]*byte2word(CARDSIZE)]);
	} else {
		c = FCL;		/* only one card left */
		FCL = (long *) FCL[0];	/* connect parts of FCL */
		return(c);
	}
}

#ifdef	USE_LARGE

long	*
new_large_card(n)
register int	n;
{
	register long	**last, *act, *c, df;
	last = &FCL;
	while(act = *last){
		if((df = act[1] - n) > 0){
			act[1] = df;		/* leave some cards there */
			return(&act[df*byte2word(CARDSIZE)]);
		}
		if(df == 0){
			*last = (long *)*act;	/* connect parts of FCL */
			return(act);
		}
		last = (long **)act;		/* df < 0, continue search */
	}
	return(NULL);	
}

/* Our FCL is a sorted list in that way, that the part with the highest address
 * is pointed to by FCL and the part with the lowest one points to nil itself.
 * So inc_card_space is allowed to put the new part of our heap onto the begin
 * of this list. (We assume, that any newly allocated part of our heap starts
 * at a higher address than the one before.)
 */

void
reclaim_card(c,n)
register long	*c;
register int	n;
{
	register long	**last, *act;
	last = &FCL;
	while(act = *last){
		if(c > act){	/* c has a higher address than the found part,
				 * so we are sure to leave it here */
			if(&act[act[1]*byte2word(CARDSIZE)] == c){
				act[1] += n;	/* onto the end of this part */
				return;
			} else {
				*last = c;	/* new part between two old */
				c[0] = (long)act;
				c[1] = n;
				return;
			}
		} 	/* c starts at a a lower address than the found part;
			 * if it can be connected with the found part, we can
			 * leave it here, but normally we have to loop */
		if(&c[n*byte2word(CARDSIZE)] == act){
			*last = c;		/* onto the begin of this part*/
			c[0] = act[0];
			c[1] = act[1] + n;
			/* now check whether it is possible to connect this
			 * with the next smaller part */
			if(act = (long *)c[0]){	/* if next part exists */
				if(&act[act[1]*byte2word(CARDSIZE)] == c){
					*last = act;
					act[1] += c[1];
				}
			}
			return;
		} else
			last = (long **) act;	/* continue with next part */
	}
	/* c is smaller than any part of the FCL */
	*last = c;
	c[0] = NULL;
	c[1] = n;
}

#else

/* If not defined USE_LARGE there's no reason for building a sorted list, 
 * just put the returned card onto the begin of the FCL
 */

void
reclaim_card(c)
register long	*c;
{
	c[0] = (long)FCL;
	c[1] = 1;
	FCL = c;
}

#endif
#endif
