/*
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
--------------------------------------------------------------------------------TITLE: heap initialization
--------------------------------------------------------------------------------File:    heap-init.c
Version: 1.3 (last modification on Wed Feb  9 08:41:34 1994)
State:   proposed


DESCRIPTION:
contains only the heap initialization function to be recompiled with
 -DSTART_NUM_OF_CARDS=nnn if necessary

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel
j.bimberg
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/ApplyC/heap-init.c[1.3]:
  done
[1.1] Fri Nov 19 13:00:13 1993 ukriegel@isst proposed
  [Fri Nov 19 12:59:44 1993] Intention for change:
[1.2] Mon Feb  7 09:42:49 1994 jbimberg@isst published
  [Mon Jan 31 15:12:40 1994] Intention for change:
  replace brk with sbrk
  done, added header
[1.3] Wed Feb  9 08:56:29 1994 jbimberg@isst proposed
  [Wed Feb  9 08:35:06 1994] Intention for change:
  changes required by Symantec C++
  done 

--------------------------------------------------------------------------------
*/
#ifndef __NT__	/* there's a special heap-nt.c for this arch/os */

#include <stdio.h>
#include "xalloc_conf.h"
#include "xalloc_misc.h"

extern long *FCL;	/* free card list , used only here and in heap.c */

extern void * sbrk(int);

void
initialize_heap()		/* get first part of heap */
{
	void * current_break;
	curnumcard = 0;
	hincr = START_NUM_OF_CARDS;
        start_nb_of_cards = START_NUM_OF_CARDS;
	/* ensure that heap starts above 64 K boundary.
	   unfortunately, brk() is not available on some arch's */
	if ((current_break = sbrk(0)) < (void *)MINHEAPBEGIN)
		sbrk(MINHEAPBEGIN - (int)current_break);
	inc_heap();		/* expanded to inc_heap_size(hincr) */
	HEAPBEGIN = FCL;	/* set HEAPBEGIN to the address of the first
				 * Card in the free card list */
}

#endif
