/*
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
*/

#include <setjmp.h> /* to get basic things for continuations and unwind-protect */

#ifndef STRUCTURE_ALIGNMENT
  #define STRUCTURE_ALIGNMENT
#endif

#define V_LITERAL(el_type, name, length) \
struct name{unsigned int L; void *C; el_type I[length];} name
#define S_LITERAL(type, name) \
struct name{unsigned int unused; void *C; struct type I;} name
#define LITERAL(name) \
struct name name STRUCTURE_ALIGNMENT
#define STAG(class) \
0, class
#define VTAG(length, class) \
length, class

/* define empty_list only in the most basic basic system */
#ifdef BASIC_SYSTEM 
extern struct empty_list{unsigned int unused; void *C; long I;} empty_list;
#else
struct empty_list{unsigned int unused; void *C; long I;} empty_list;
#endif
#define SET_CLASS_OF_NIL empty_list.C=&c__null__eulisp0.I;


#ifdef NIL_REGISTER
  register long* NIL NIL_REGISTER;
  #define SET_NIL NIL=&empty_list.I
  #define XCALL(call) ({register typeof(call) AUX=call; SET_NIL; AUX;})
  #define YCALL(call) (call, SET_NIL)
#else 
  #define NIL &empty_list.I
  #define SET_NIL     
  #define XCALL(call) call
  #define YCALL(call) call
#endif

#ifdef FIXED_PRECISION_INTEGER_30
  #define SMALL_INT_SKIP
#else
  #define SMALL_INT_SKIP char small_int_skip[65535]={0}
#endif

#ifndef LSHIFTR
#include <limits.h>
int LSHIFTR(int i, int s)
{return (i>>s) & (LONG_MAX>>(s-1));}
#endif
#ifndef ASHIFTR
int ASHIFTR(int i, int s)
{return (i<0) ? -((-i)>>s) : i>>s;}
#endif

#define GET_JMPBUF(bufptr) *bufptr

typedef void* (*function)();





