/*

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

*/

/* NIL_REGISTER */
/* if set the value of NIL_REGISTER is used in
register t_Null NIL NIL_REGISTER; */

#ifdef __GNUC__
  #ifdef sparc
  #define NIL_REGISTER asm("%g6")
  #endif
#endif

/* FIXED_PRECISION_INTEGER_30 */
/* if set, the fixed precision integers of EuLisp are coded by int<<1|1
so they use effectively 30 bits for representing a short Lisp integer
if not set the fixed precision integers appear as C-long int with the 
highest 17 bits used for the sign; so only 15 bits are used effectively */

#define FIXED_PRECISION_INTEGER_30

#ifdef __GNUC__
  #ifdef sparc
    #define STRUCTURE_ALIGNMENT __attribute__ ((aligned (8)))
  #endif
#endif

/* optimized shift operations */
#ifdef __GNUC__
#ifdef sparc
 #define LSHIFTR(i,s)\
({register typeof(i) __value;\
  if (__alignof__(__value)!=4)\
  asm("sll %1,%3,%0;srl %0,%2,%0;srl %0,%3,%0" \
      : "=r,r" (__value) \
      : "r,r" (i),"i,r" (s), "i,i" (32-__alignof__(__value)*8));\
  else\
  asm("srl %1,%2,%0" \
      : "=r,r" (__value) \
      : "r,r" (i),"i,r" (s));\
  __value;})

#define ASHIFTR(i,s)\
({register typeof(i) __value;\
  if (__alignof__(__value)!=4)\
  asm("sll %1,%3,%0;sra %0,%2,%0;sra %0,%3,%0" \
      : "=r,r" (__value) \
      : "r,r" (i),"i,r" (s), "i,i" (32-__alignof__(__value)*8));\
  else\
  asm("sra %1,%2,%0" \
      : "=r,r" (__value) \
      : "r,r" (i),"i,r" (s));\
  __value;})

#endif
#endif











