/*
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-----------------------------------------------------------------------------------
TITLE: Initialization of c runtime constants
-----------------------------------------------------------------------------------
File:    c-runtime.c
Version: 1.12 (last modification on Wed Feb  9 08:38:55 1994)
State:   proposed


DESCRIPTION:
Initialization of runtime constants like size of FILE ore jmp_buf

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/ApplyC/c-runtime.c[1.12]:
  run time functions and initialization
[1.1] Fri Oct  8 17:23:54 1993 ukriegel@isst proposed
  [Fri Oct  8 13:28:27 1993] Intention for change:
  most-positive-fixnum
  most-positive-double
[1.2] Thu Oct 14 14:13:46 1993 ukriegel@isst published
  [Thu Oct 14 14:11:06 1993] Intention for change:
  delete error handler
[1.3] Wed Dec  1 15:47:49 1993 jbimberg@isst saved
  [Wed Dec  1 15:47:10 1993] Intention for change:
  inserting a new signal: ALARM
  done
[1.4] Mon Jan 10 13:54:36 1994 ukriegel@isst proposed
  [Mon Jan 10 13:20:48 1994] Intention for change:
  delete all variable defs which could be set by preprocessor
  done
[1.5] Mon Jan 10 15:18:41 1994 ukriegel@isst proposed
  [Mon Jan 10 15:17:38 1994] Intention for change:
  typingf error
[1.6] Tue Jan 11 13:35:10 1994 ukriegel@isst proposed
  [Tue Jan 11 13:32:44 1994] Intention for change:
  headerfile
  done
[1.7] Tue Jan 11 15:03:53 1994 ukriegel@isst proposed
  [Tue Jan 11 15:01:02 1994] Intention for change:
  variable defs.
  done
[1.8] Wed Jan 12 13:20:34 1994 ukriegel@isst proposed
  [Wed Jan 12 13:18:27 1994] Intention for change:
  clean up
  stdin_c excluded
[1.9] Wed Jan 12 13:23:12 1994 ukriegel@isst proposed
  [Wed Jan 12 13:22:15 1994] Intention for change:
  --- no intent expressed ---typing error
[1.10] Wed Jan 12 13:56:32 1994 ukriegel@isst proposed
  [Wed Jan 12 13:53:58 1994] Intention for change:
  delete size of jmp_buf
  done
[1.11] Fri Jan 28 12:44:51 1994 jbimberg@isst published
  [Fri Jan 28 12:43:52 1994] Intention for change:
  delete the timer and signal
  done
[1.12] Wed Feb  9 08:56:54 1994 jbimberg@isst proposed
  [Wed Feb  9 08:34:21 1994] Intention for change:
  changes required by Symantec C++ 
  done 

-----------------------------------------------------------------------------------
*/


#include <stdio.h>
#include <signal.h>
#include "xalloc_user.h"
#include "xalloc_misc.h"
#include "xalloc_conf.h"





#ifdef ROOT_SET_IN_USE
 long StaticLiteralBegin;
 long StaticLiteralEnd;
/*
 long StaticVariableRoot;
 long StaticObjectRoot;
 long StaticRootEnd;
*/

#endif

/* be careful changeing the following decls requires change in c-runtime.h too
*/   


#ifdef ROOT_SET_IN_USE
void gc_init()
{ long *ptr;
   void c_runtime_init();


   /* call runtime initialization of system constants */   
  /*
    for (ptr = (long *) StaticVariableRoot; ptr < (long *)&StaticObjectRoot; ++ptr)
    if(p_in_heap((void *)**ptr)
      add_to_root_set((void *))**ptr);

    for (ptr = (long *) StaticObjectRoot; ptr < (long  *)&StaticRootEnd; ++ptr)
    if(p_in_heap((void *)*ptr)
      add_to_root_set((void *) *ptr);

  */

 
  for(ptr = (long *)&StaticLiteralBegin;ptr < (long *)&StaticLiteralEnd; ptr++)
   if(p_in_heap((long *)*ptr))
      add_to_root_set((long *)*ptr); 
}

#endif

void c_runtime_init()
{

#ifdef ROOT_SET_IN_USE
  gc_init();
#endif
}



















