;;;-*- Mode: Lisp; Package: whc-aux -*-
#|

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.


-----------------------------------------------------------------------------------
TITLE: auxiliary functions
-----------------------------------------------------------------------------------
File:    whc-aux.em
Version: 2.0 (last modification on Wed Feb 16 16:38:32 1994)
State:   proposed

DESCRIPTION:
the functions for generation of code

DOCUMENTATION:


NOTES:


REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/whc-aux.em[2.0]:
  auxiliary functions for code generation.
[1.1] Tue Mar 23 11:31:22 1993 wheick@isst saved
  new test functions for <%representation>
[1.2] Mon Mar 29 17:18:23 1993 wheick@isst saved
  
[1.3] Thu Apr  1 08:11:21 1993 wheick@isst proposed
  
[1.4] Tue Apr  6 10:51:36 1993 wheick@isst proposed
  interface to code generation
[1.5] Tue Apr  6 13:12:48 1993 wheick@isst proposed
  remove package qualifier
[1.6] Tue Apr  6 14:56:31 1993 wheick@isst proposed
  [Tue Apr  6 14:53:07 1993] Intention for change:
  no import from whc-gen-code
[1.7] Tue Apr 20 11:51:20 1993 wheick@isst saved
  methods for data-integer-p and data-float-p
[1.8] Fri Apr 23 09:00:08 1993 wheick@isst saved
  
[1.9] Wed Apr 28 09:17:16 1993 wheick@isst published
  
[1.10] Fri May 28 09:07:16 1993 wheick@isst saved
  done
[1.11] Fri May 28 10:06:12 1993 wheick@isst saved
  import %word-integer
[1.12] Fri May 28 11:11:39 1993 wheick@isst saved
  %word-integer problem
[1.13] Fri May 28 15:32:47 1993 wheick@isst saved
  data-type with %function 
[1.14] Fri May 28 15:47:27 1993 wheick@isst saved
  
[1.15] Mon Sep 27 11:11:20 1993 imohr@isst published
  [Fri Sep 24 15:44:21 1993] Intention for change:
  removing cycle to machine-description
[1.16] Thu Feb 17 10:52:53 1994 wheick@isst proposed
  [Wed Feb 16 09:15:49 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Thu Feb 17 10:52:53 1994 wheick@isst proposed
  [Wed Feb 16 09:15:49 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#

;;; begin whc-aux.em

#module whc-aux

(import
 (eulisp1
  expand-literal
  
  lzs 
  mzs 
  simple-programming
  
  accessors
  representation ; whc-classes

  (only ( subtypep type-of) common-lisp)
  )

 syntax
 (eulisp1 
  apply-standard 
  lzs-modules)

 export 
 (give-basic-data-type
  give-pointer-data-type
  give-prestruct-data-type
  give-union-data-type
  give-variable
  give-constant
  give-variable-or-constant
  basic-data-type-p
  data-float-p
  data-integer-p
  )
 )



;;;-------------------------------------------------------------

(defmethod data-type-p ((type <class-def>))
  t)

(defmethod data-type-p ((type <number>))
  nil)

(defmethod data-type-p (type)
  nil)

(defun variable-p (var) 
 (subtypep (type-of var) <var>))

(defun constant-p (var) 
 (subtypep (type-of var) <named-const>))

(defun pointer-data-type-p (type)
  (subtypep (type-of type) <%pointer>))

(defun prestruct-data-type-p (type)
  (subtypep (type-of type) <%prestruct>))

(defun union-data-type-p (type)
  (subtypep (type-of type) <%union>))

(defmethod basic-data-type-p ((type <basic-class-def>))
  t)


(defmethod basic-data-type-p (type)
  nil)

;-----------------------------------------------------

(defun give-data-type (symbol)
    (when (data-type-p symbol)
      symbol))


(defun give-basic-data-type (symbol)
  (when (basic-data-type-p symbol)
      symbol))


(defun give-pointer-data-type (symbol)
  (when (pointer-data-type-p symbol)
      symbol))

(defun give-prestruct-data-type (symbol)
  (when (prestruct-data-type-p symbol)
      symbol))

(defun give-union-data-type (symbol)
  (when (union-data-type-p symbol)
      symbol))

(defun give-variable (var)
  (when (variable-p var)
      var))

(defun give-constant (var)
  (when (constant-p var)
      var))

(defun give-variable-or-constant (var)
  (when (or (constant-p var)
            (variable-p var))
    var))

(defmethod data-integer-p ((instance <%integer>))
  t)

(defmethod data-integer-p (object)
  nil)

(defmethod data-float-p ((instance <%float>))
  t)

(defmethod data-float-p (object)
  nil)

#module-end
;;; eof whc-aux.lisp