;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: types-hand-on -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    types-hand-on.em
Version: 2.0 (last modification on Wed Feb  9 11:36:13 1994)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:  change pass from 3 to 5
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Firedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/types-hand-on.em[2.0]:
  
[1.1] Mon Jan 10 15:40:00 1994 akind@isst saved
  [Mon Jan 10 15:33:41 1994] Intention for change:
  this is reserved for hf
[1.2] Mon Jan 31 09:34:21 1994 akind@isst proposed
  [Mon Jan 10 16:04:01 1994] Intention for change:
  l
[1.3] Mon Jan 31 13:11:10 1994 akind@isst saved
  [Mon Jan 31 10:14:45 1994] Intention for change:
  walk-stat for get-slot-value
[1.4] Mon Jan 31 14:11:12 1994 hfried@isst proposed
  [Mon Jan 31 13:57:05 1994] Intention for change:
  + walk-stat for slot-value
[1.5] Tue Feb  1 09:32:33 1994 akind@isst proposed
  [Tue Feb  1 09:31:13 1994] Intention for change:
  --- no intent expressed ---
[1.6] Mon Feb  7 09:30:05 1994 akind@isst proposed
  [Tue Feb  1 09:45:48 1994] Intention for change:
  --- no intent expressed ---
[1.7] Mon Feb  7 15:25:55 1994 akind@isst proposed
  [Mon Feb  7 14:10:15 1994] Intention for change:
  special treatment of predicate functions
[1.8] Tue Feb  8 16:10:52 1994 akind@isst published
  [Tue Feb  8 11:12:40 1994] Intention for change:
  --- no intent expressed ---
[1.9] Wed Feb  9 15:09:06 1994 akind@isst proposed
  [Wed Feb  9 11:02:40 1994] Intention for change:
  --- no intent expressed ---,`
[2.0] Wed Feb  9 15:09:06 1994 akind@isst proposed
  [Wed Feb  9 11:02:40 1994] Intention for change:
  --- no intent expressed ---,`
-----------------------------------------------------------------------------------
|#
 
#module types-hand-on
 (import (LZS MZS
          type-propagation
	  debugging
	  type-inference
	  (only (specialize-descrs get-previous-subs) ti-signature)
	  name-of-fun
	  (only (?arg-num-fun) function-label)
	  (only (get-functions-used-in-literals) expand-literal)
	  (only (append format mapc) common-lisp))
  syntax (level-1-eulisp)
  export (types-hand-on-modules))

(defun types-hand-on-modules (m-list)
  (if (null m-list) 
    (types-hand-on-funs (get-functions-used-in-literals))
    (progn 
      ;;(pause-types-hand-on-modules)
      (types-hand-on-module (car m-list))
      (types-hand-on-modules (cdr m-list)))))

(defun types-hand-on-module (modul)
  (let ((tlf (?toplevel-forms modul)))
    (if tlf (types-hand-on-fun tlf) ())
    (types-hand-on-funs (?fun-list modul))))

(defun types-hand-on-funs (fun-list)
  (if (null fun-list) ()
      (progn (types-hand-on-fun (car fun-list))
             (types-hand-on-funs (cdr fun-list)))))

(defvar cur-fun ()) ; currend function

(defun types-hand-on-fun (fun)
  (start-analyse-fun fun)		; for debugging
;  (format t "+")
  (if (eq (?pass fun) 3) 
      (dynamic-let ((typepathes (list (?type-descr fun)))
		    (cur-fun fun))	; *hf* 11.01
	 (setf (?type-descr-s fun) ())  ; *hf* 11.01
         (setf (?pass fun) 4)
         (setf (?start-block (?function-label fun))
               (walk-block (?start-block (?function-label fun)) ))
         (setf (?pass fun) 5)
         fun)
    fun)
  (end-analyse-fun fun))

(defun walk-block (block)
  (setf (?body block) (walk-stats (?body block)))
  (setf (?interface block) (walk-stats (?interface block)))
  (walk-result (?result block) (?out-label block))
  ; *hf* hier muss das richtige Ergebnis zurueckgegeben werden
  block)

(defun walk-stats (stat-list)
  (if (null stat-list) ()
      (let ((stat (walk-stat (car stat-list))))
        (if stat (cons stat (walk-stats (cdr stat-list)))
            (walk-stats (cdr stat-list))))))

(defgeneric walk-stat (stat))

(defmethod walk-stat ((stat <call>)) (walk-call stat))
(defmethod walk-stat ((stat <asm>)) (walk-call stat))
(defmethod walk-stat ((stat <last-call>)) (walk-call stat))
(defmethod walk-stat ((stat <last-asm>)) (walk-call stat))

(defun walk-call (stat)
  (let* ((fun (?function stat))
         (arg-num (?arg-num stat))
         (typedescrs 
          (make-actual-type-descr (dynamic typepathes)
                                  stat
                                  (?var-descr stat)
                                  arg-num
                                  ())))
    (types-hand-on-fun fun)
    (setq typedescrs (inference fun typedescrs))
    (specialize-descrs typedescrs (?type-descr stat)) ;ak
    (setf (?type-descr-s stat) typedescrs)
    (dynamic-setq typepathes typedescrs)
    stat))

(defmethod walk-stat ((stat <set-slot-value>))
  (let ((typedescrs
	 (make-actual-type-descr (dynamic typepathes)
				 stat (?var-descr stat) 2 ())))
    (setq typedescrs (inference-set-slot-value typedescrs (?slot stat)))
    (specialize-descrs typedescrs (?type-descr stat))
    (setf (?type-descr-s stat) typedescrs)
    (dynamic-setq typepathes typedescrs)
    stat))

(defmethod walk-stat ((stat <get-slot-value>))
  (let ((typedescrs
	 (make-actual-type-descr (dynamic typepathes)
				 stat (?var-descr stat) 1 ())))
    (setq typedescrs (inference-get-slot-value typedescrs (?slot stat)))
    (specialize-descrs typedescrs (?type-descr stat))
    (setf (?type-descr-s stat) typedescrs)
    (dynamic-setq typepathes typedescrs)
    stat))

(defmethod walk-stat ((stat <move>))
  (let ((typedescrs 
         (make-actual-type-descr (dynamic typepathes)
                                 stat
                                 (?var-descr stat)
                                 1 ; arg-num
                                 ())))
    (mapc #'get-previous-subs typedescrs)
    ;; ak hier nur im Notfall!!
    (setf (?type-descr-s stat) typedescrs)
    (dynamic-setq typepathes typedescrs)
    stat))

; walk-result (?result block) (?out-label block) 
(defgeneric walk-result (result out-label))

(defmethod walk-result ((result <return>) out-label 
                         )
; *hf* 11.01 start changes
  (let ((fun (dynamic cur-fun)))
    (setf (?pathes result) (dynamic typepathes)) 
    (setf (?type-descr-s fun)
	(make-formal-type-descr
	 (dynamic typepathes)
	 result
	 (?value result) ; var or constant
	 ()
	 (?var-descr fun)
	 (?arg-num-fun fun)
	 (?type-descr-s fun)
	 () ; no recursive
	 )))
; *hf* end changes	 
    ()
)

(defmethod walk-result ((result <void>) (out-label <zykl-label>))
  (walk-block (?out-block out-label))
)

(defmethod walk-result ((result <void>) out-label)
  () )

; !!! class <null> not defined ??
(defmethod walk-result ((result null) out-label 
                          )
  () )

(defmethod walk-result ((result <goto>) out-label 
                          )
  () )

(defmethod walk-result ((test <test>) out-label 
                          )
  (let* ((fun (?function test))
;;       (arg-num (?arg-num test)) ;; removed by ak (arg-num unbound)
         (arg-num 2)
         (typedescrs 
          (make-actual-type-descr (dynamic typepathes)
                                  test
                                  (?var-descr test)
                                  arg-num
                                  ()))
         (join-label (find-join-label (?then-block test)
                                      (?else-block test))))
    (types-hand-on-fun fun)
    (setq typedescrs (inference fun typedescrs))
    (let ((then-typedescrs (select-then-type-descr 
                            (?function test)
                            typedescrs))
          (else-typedescrs (select-else-type-descr 
                            (?function test) 
                            typedescrs)))
      (if (or (and then-typedescrs else-typedescrs)
	      (and (null then-typedescrs) (null else-typedescrs)))
      ; both true or both nil
      (progn
	(specialize-descrs typedescrs (?type-descr test)) ;ak
        (setf (?type-descr-s test) typedescrs)
        (setf (?then-type-descr-s test) then-typedescrs)
        (setf (?else-type-descr-s test) else-typedescrs)
        (dynamic-let ((typepathes then-typedescrs))
                     (walk-block (?then-block test)))
        (dynamic-let ((typepathes else-typedescrs))
                     (walk-block (?else-block test)))
        ())
      ; one () other not ()
      (let ((child-block (if then-typedescrs (?then-block test)
                             (?else-block test)))
            (block (?block test)))
	(dynamic-let ((typepathes (if then-typedescrs
				      then-typedescrs
				    else-typedescrs)))
	   (walk-block child-block)
	   (setf (?out-label block) (?out-label child-block))
	   (setf (?body block)
	     (append (?body block) (?body child-block)))
	   (setf (?interface block) 
	     (?interface child-block))
	   (setf (?result block) (?result child-block))
	   ()))))
    (if join-label
        (walk-block (?out-block join-label))
      ())
    test)
  )

(defun find-join-label (then-block else-block)
  (let* ((then (find-join-label1 then-block))
         (else (if then (find-join-label1 else-block) ())))
    (if else
      (if (and (eq (car then) (car else))
               (eq (length (?in-block (car then)))
                   (+ (cdr then) (cdr else))))
        (car then)
        ()))))

(defun find-join-label1 (block)
  (let ((result (?result block))
        (out-label (?out-label block)))
    (if (join-label-p out-label) (cons out-label 1)
        (if (test-p result)
          (let* ((then (find-join-label1 (?then-block result)))
                 (else (if then (find-join-label1 (?else-block result)) ())))
            (if else 
              (progn
                (if (eq (car then) (car else)) ()
                    (serror t "~% differen then and else-blocks "))
                (if (eq (length (?in-block (car then))) 
                        (+ (cdr then) (cdr else)))
                  (find-join-label1 (?out-block (car then)))
                  (cons (car then) (+ (cdr then) (cdr else)))))
              ()))
          ())))
)

                
#module-end