;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-exprs -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-------------------------------------------------------------------------------
TITLE: Type Expressions for Type Inference
-------------------------------------------------------------------------------
File:    ti-exprs.em
Version: 2.0 (last modification on Mon Jan 31 11:06:13 1994)
State:   proposed

DESCRIPTION:

Type expressions can be subdivided into atomic types, slot identifications, and type variables. Atomic types have a link to a lattice type or to a combinations of lattice types. A combination of lattice types can be created with lattice operations meet, join, and complement. 

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/ti-exprs.em[2.0]:
  
[1.1] Fri Apr 23 09:52:36 1993 akind@isst proposed
  
[1.2] Wed May  5 11:25:18 1993 akind@isst proposed
  
[1.3] Wed May 12 14:17:44 1993 ukriegel@isst saved
  [Tue May 11 08:36:01 1993] Intention for change:
  slot-id-p
  done
[1.4] Wed May 12 16:11:47 1993 imohr@isst proposed
  [Wed May 12 14:32:07 1993] Intention for change:
  delete method for slot-id-p
  ok
[1.5] Tue May 18 17:21:50 1993 akind@isst proposed
  
[1.6] Mon May 24 12:08:24 1993 akind@isst proposed
  
[1.7] Fri May 28 10:08:38 1993 akind@isst proposed
  
[1.8] Tue Jun  1 15:22:08 1993 akind@isst proposed
  
[1.9] Tue Aug  3 11:46:56 1993 akind@isst proposed
  
[1.10] Wed Aug 11 13:34:50 1993 akind@isst proposed
  
[1.11] Wed Aug 18 16:09:49 1993 akind@isst proposed
  
[1.12] Thu Aug 19 09:02:51 1993 akind@isst proposed
  
[1.13] Tue Aug 24 17:14:29 1993 akind@isst proposed
  
[1.14] Wed Aug 25 17:38:52 1993 akind@isst proposed
  
[1.15] Fri Aug 27 17:29:40 1993 akind@isst proposed
  
[1.16] Mon Aug 30 09:13:03 1993 akind@isst published
  
[1.17] Thu Sep 23 14:32:56 1993 akind@isst proposed
  [Fri Sep  3 09:35:56 1993] Intention for change:
  type specification (%function return-class)
[1.18] Fri Oct  1 14:41:02 1993 akind@isst saved
  [Thu Sep 23 15:44:04 1993] Intention for change:
[1.19] Mon Oct 11 10:30:14 1993 akind@isst saved
  
[1.20] Tue Oct 12 10:32:09 1993 akind@isst published
  
[1.21] Thu Oct 21 15:03:35 1993 akind@isst saved
  
[1.22] Tue Nov  9 17:37:24 1993 akind@isst proposed
  
[1.23] Tue Jan  4 11:44:23 1994 akind@isst saved
  [Mon Dec 13 10:57:53 1993] Intention for change:
[1.24] Wed Jan 19 13:19:06 1994 akind@isst saved
  
[1.25] Mon Jan 31 09:34:51 1994 akind@isst proposed
  [Mon Jan 10 11:40:48 1994] Intention for change:
  --- no intent expressed ---
[1.26] Mon Feb  7 09:29:55 1994 akind@isst published
  [Mon Jan 31 11:05:12 1994] Intention for change:
  --- no intent expressed ---
[2.0] Mon Feb  7 09:29:55 1994 akind@isst proposed
  [Mon Jan 31 11:05:12 1994] Intention for change:
  --- no intent expressed ---

-------------------------------------------------------------------------------
|#


#module ti-exprs
(import (lzs lzs-mop
	     machine-description ti ti-codes ti-lattice
	     (only (find) common-lisp))
 syntax (ti)
 export (<type-expr>
	 <atomic-type> ?code ?name ?comp-name
	 <type-var> ?id
	 <slot-id> ?slot-name
	 atomic-type-p type-var-p slot-id-p
	 contains-type-var-p eq-type-var-p
	 substitute-type-var class-as-type-expr
	 new-type-var new-type-var-id reset-actual-type-var-id
	 lattice-type-to-atomic-type lattice-type-to-atomic-types
	 general-type general-type-p
	 <null>-type <null>-type-p 
	 %object-type %object-type-p 
	 %void-type %void-type-p
	 %false-type %false-type-p
	 fpi-list-type fpi-list-type-p
	 <function>-type <function>-type-p
	 <fpi>-type <fpi>-type-p
	 no-type-p %class-type-p %function-type %integer-type)
 )

;;; ---------------------------------------------------------------------------
;;; TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

(defstandardclass <type-expr> ())
  
(defstandardclass <atomic-type> (<type-expr>)
  (code :accessor :initarg :initform nil)
  (name :accessor :initarg :initform nil)
  (comp-name :accessor :initarg :initform nil))
  
(defstandardclass <type-var> (<type-expr>)
  (id :accessor :initarg :initform nil))
  
(defstandardclass <slot-id> (<type-expr>)
  (slot-name :accessor :initarg :initform nil))

;;; ---------------------------------------------------------------------------
;;; TYPE EXPRESSION PREDICATES
;;; ---------------------------------------------------------------------------

(defgeneric atomic-type-p (expr))

(defmethod atomic-type-p ((expr <type-expr>))
  #f)

(defmethod atomic-type-p ((expr <atomic-type>))
  #t)

;;; ---------------------------------------------------------------------------
(defgeneric type-var-p (expr))

(defmethod type-var-p ((expr <type-expr>))
  #f)

(defmethod type-var-p ((expr <type-var>))
  #t)

;;; ---------------------------------------------------------------------------
(defgeneric slot-id-p (expr))

(defmethod slot-id-p ((expr <slot-id>))
  #t)

(defmethod slot-id-p ((expr <type-expr>))
  #f)

;;; ---------------------------------------------------------------------------
;;; Answer whether an type expression contains a type varible.
(defgeneric contains-type-var-p (obj var))

(defmethod contains-type-var-p ((expr <type-expr>)
				(var <type-var>))
  #f)

(defmethod contains-type-var-p ((expr <type-var>)
				(var <type-var>))
  (eq-type-var-p expr var))

(defmethod contains-type-var-p ((obj <pair>)
				(var <type-var>))
  (member-with-args #'contains-type-var-p obj var))

(defmethod contains-type-var-p ((vec <vector>)
				(var <type-var>))
  (find var vec :test #'eq-type-var-p))
 
;;; ---------------------------------------------------------------------------
;;; Answer whether two type varibles are equal.
(defgeneric eq-type-var-p (var1 var2))

(defmethod eq-type-var-p (var1 var2)
  nil)

(defmethod eq-type-var-p ((var1 <type-var>)
			  (var2 <type-var>))
  (eq (?id var1) (?id var2)))

;;; ---------------------------------------------------------------------------
;;; TYPE VARIABLE IDENTIFICATION
;;; ---------------------------------------------------------------------------

(DEFLOCAL *actual-type-var-id* 0)

(defun reset-actual-type-var-id ()
  (setq *actual-type-var-id* 0))

;;; Answer a new type variable identifier.
(defun new-type-var-id ()
  (setq *actual-type-var-id* (+ *actual-type-var-id* 1))
  *actual-type-var-id*)

;;; Answer a new type variable.
(defun new-type-var ()
  (make <type-var> :id (new-type-var-id)))

;;; ---------------------------------------------------------------------------
;;; TYPE EXPRESSION/LZS-CLASS CONNECTION
;;; ---------------------------------------------------------------------------

;;; Answer a corresponding type expr to a application class (lzs-class).
(defgeneric class-as-type-expr (class))
  
(defmethod class-as-type-expr ((class <named-const>))
  (class-as-type-expr (?value class)))
  
(defmethod class-as-type-expr ((class <null>))
  (ti-format t "Warning: no class for class-as-type-expr")
  (ti-error)
  (general-type))
  
(defmethod class-as-type-expr ((class <class-def>))
  (let ((lattice-type (?lattice-type class)))
    (if (null lattice-type)
	(ti-format t  "Warning: Can't find lattice type for class ~A" class)
      (lattice-type-to-atomic-type lattice-type))))

;;; ---------------------------------------------------------------------------
;;; TYPE EXPRESSION/LATTICE TYPE CONNECTION
;;; ---------------------------------------------------------------------------

(defun lattice-type-to-atomic-type (lattice-type)
  (let ((expr (?atomic-expr lattice-type)))
    (if expr
	(if (?compound lattice-type)
	    (make <atomic-type>
		  :code (?code lattice-type)
		  :name lattice-type
		  :comp-name t)
	  expr)
      (let ((new-expr (make <atomic-type>
			    :code (?code lattice-type)
			    :name lattice-type
			    :comp-name (?compound lattice-type))))
	(setf (?atomic-expr lattice-type) new-expr)
	new-expr))))

(defun lattice-types-to-atomic-types (lattice-types)
  (mapcar #'lattice-type-to-atomic-type lattice-types))

;;; Answer a type expression for the top of the lattice.
(defun general-type ()
  (lattice-type-to-atomic-type *top*))

(defun %object-type ()
  (lattice-type-to-atomic-type *%object*))

(defun %void-type ()
  (lattice-type-to-atomic-type *%void*))

(defun %integer-type ()
  (lattice-type-to-atomic-type *%integer*))

(defun %false-type ()
  (lattice-type-to-atomic-type *%false*))

(defun %function-type ()
  (lattice-type-to-atomic-type *%function*))

(defun %class-type ()
  (lattice-type-to-atomic-type *%class*))

(defun fpi-list-type ()
  (lattice-type-to-atomic-type *fpi-list*))

(defun <null>-type ()
  (lattice-type-to-atomic-type *<null>*))

(defun <function>-type ()
  (lattice-type-to-atomic-type *<function>*))

(defun <fpi>-type ()
  (lattice-type-to-atomic-type *<fpi>*))

;;; Answer whether a type expression correspondes to the top of the lattice.
(defun general-type-p (type-expr)
  (eq-code-p (?code type-expr) *top-code*))

;;; Answer whether a type expression correspondes to %object.
(defun %object-type-p (type-expr)
  (eq-code-p (?code type-expr) *%object-code*))

;;; Answer whether a type expression correspondes to %false.
(defun %false-type-p (type-expr)
  (eq-code-p (?code type-expr) *%false-code*))

;;; Answer whether a type expression correspondes to %void.
(defun %void-type-p (type-expr)
  (and (atomic-type-p type-expr)
       (eq-code-p (?code type-expr) *%void-code*)))

;;; Answer whether a type expression correspondes to %class.
(defun %class-type-p (type-expr)
  (and (atomic-type-p type-expr)
       (eq-code-p (?code type-expr) *%class-code*)))

;;; Answer whether a type expression correspondes to fpi-list.
(defun fpi-list-type-p (type-expr)
  (eq-code-p (?code type-expr) *fpi-list-code*))

;;; Answer whether a type expression correspondes to the bottom of the lattice.
(defun no-type-p (type-expr)
  (eq-code-p (?code type-expr) *bottom-code*))

;;; Answer whether a type expression correspondes to <null>.
(defun <null>-type-p (type-expr)
  (eq-code-p (?code type-expr) *<null>-code*))

;;; Answer whether a type expression correspondes to <null>.
(defun <function>-type-p (type-expr)
  (eq-code-p (?code type-expr) *<function>-code*))

(defun <fpi>-type-p (type-expr)
  (eq-code-p (?code type-expr) *<fpi>-code*))

#module-end