;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: tail-module -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: Compiler Interface to Basic Module %tail
-----------------------------------------------------------------------------------
File:    tail-module.em
Version: 2.0 (last modification on Thu Jul 14 17:47:53 1994)
State:   proposed

DESCRIPTION:
the definition functions for tail data types

DOCUMENTATION:
see in the APPLY-paper machine description

NOTES:


REQUIRES:

PROBLEMS:

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/tail-module.em[2.0]:
  tail-module
[1.1] Wed Mar 24 17:09:59 1993 wheick@isst saved
  [Wed Mar 17 11:19:47 1993] Intention for change:
  export new tail classes %pointer-to.
[1.2] Mon Apr 19 13:46:07 1993 wheick@isst saved
  new representation <%direct>
[1.3] Mon Apr 19 14:16:01 1993 wheick@isst saved
  export <%function>
[1.4] Mon Apr 19 14:45:29 1993 wheick@isst proposed
  
[1.5] Wed May  5 13:46:09 1993 wheick@isst proposed
  
[1.6] Tue May 25 16:42:07 1993 akind@isst saved
  [Fri May  7 21:20:21 1993] Intention for change:
[1.7] Tue May 25 16:53:48 1993 wheick@isst saved
  done
[1.8] Thu May 27 11:36:14 1993 wheick@isst proposed
  
[1.9] Wed Sep  1 18:08:23 1993 imohr@isst proposed
  [Wed Sep  1 12:09:00 1993] Intention for change:
  reset for module %tail
[1.10] Fri Sep  3 08:05:00 1993 ukriegel@isst published
  [Fri Sep  3 08:04:00 1993] Intention for change:
  expose wrong syntax
  done
[1.11] Fri Oct  1 18:49:41 1993 imohr@isst published
  [Fri Oct  1 14:33:55 1993] Intention for change:
  longjmp
[1.12] Fri Nov  5 17:00:37 1993 imohr@isst proposed
  [Fri Nov  5 16:58:06 1993] Intention for change:
  + new %size-of's
[1.13] Fri Jan 14 15:12:42 1994 wheick@isst published
  [Fri Jan 14 14:52:23 1994] Intention for change:
  in initialize: :module-id -> :module
[1.14] Tue Feb 15 09:02:34 1994 imohr@isst saved
  [Mon Feb 14 08:09:22 1994] Intention for change:
  naming init-flag of module %tail
[1.15] Thu Feb 17 09:36:21 1994 wheick@isst proposed
  [Wed Feb 16 08:28:32 1994] Intention for change:
  insert eulisp0,1
  done
[1.16] Mon Jun 20 11:55:07 1994 imohr@isst proposed
  [Wed Jun  1 16:14:40 1994] Intention for change:
  remove (effectively empty) initialization of module %tail
  Beiratssitzung Abschluss
[1.17] Thu Jul 14 18:20:04 1994 imohr@isst proposed
  [Thu Jul 14 17:45:21 1994] Intention for change:
  %mod -> %rem
[2.0] Thu Jul 14 18:20:04 1994 imohr@isst proposed
  [Thu Jul 14 17:45:21 1994] Intention for change:
  %mod -> %rem 

-----------------------------------------------------------------------------------
|#


#module tail-module

(import
 (accessors
  eulisp1
  LZS
  MZS
  machine-description; for the whole machine-description
  debugging
  el2lzs
  expand-literal
  (only (*basic-system*) predicates)
  (only (make-instance vector append delete-if-not last butlast)
    common-lisp)
  )

 syntax
 (eulisp1 
  apply-standard 
  debugging
  machine-description)


 export
 (
  ;;;accesses for data types
  ;;;!!!the following (and other symbols, 
  ;;;see define-tail-sys-functions and 
  ;;;define-tail-aux-sys-functions below) 
  ;;;are exported automatically by define-tail!!!
  ;;;%ref %extract %select %preselect %view 
  ;;;%size-of-instance %size-as-component %pointer-of

  %byte-integer %half-integer %word-integer
  %unsigned-byte-integer %signed-byte-integer 
  %unsigned-half-integer %signed-half-integer
  %unsigned-word-integer %signed-word-integer
  %direct-integer %signed-direct-integer
  %single-float %double-float %extended-float 
  %void
  %direct
  %function
  %string
  %jmpbuf
  %pjmpbuf


  <%byte-integer> <%half-integer> <%word-integer>
  <%unsigned-byte-integer> <%signed-byte-integer> 
  <%unsigned-half-integer> <%signed-half-integer>
  <%unsigned-word-integer> <%signed-word-integer>
  <%direct-integer> <%signed-direct-integer>
  <%single-float> <%double-float> <%extended-float> 
  <%void>
  <%direct>
  <%function>
  <%string>
  <%jmpbuf>
  <%pjmpbuf>
 
  %goto %label
  %make-proc-epilog
  %make-proc-prolog
  %make-data-segment
  %make-code-segment
  %make-commentline %call
  %jmpl %move-block %move
  %le %ge %lt %gt
  %neq %eq %cxtod %cxtos
  %cxtoi %cdtox %cdtos
  %cdtoi %cstox %cstod
  %cstoi %citox %citod
  %citos %zero-extend
  %sign-extend %sqrt %abs
  %rotater %rotatel %ashiftr
  %lshiftr %ashiftl %lshiftl
  %xor %or %and %not
  %rem %div %mult %neg
  %minus %plus
  %setjmp %longjmp

  <%goto> <%label>
  <%make-proc-epilog>
  <%make-proc-prolog>
  <%make-data-segment>
  <%make-code-segment>
  <%make-commentline> <%call>
  <%jmpl> <%move-block> <%move>
  <%le> <%ge> <%lt> <%gt>
  <%neq> <%eq> <%cxtod> <%cxtos>
  <%cxtoi> <%cdtox> <%cdtos>
  <%cdtoi> <%cstox> <%cstod>
  <%cstoi> <%citox> <%citod>
  <%citos> <%zero-extend>
  <%sign-extend> <%sqrt> <%abs>
  <%rotater> <%rotatel> <%ashiftr>
  <%lshiftr> <%ashiftl> <%lshiftl>
  <%xor> <%or> <%and> <%not>
  <%rem> <%div> <%mult> <%neg>
  <%minus> <%plus>
  <%setjmp> <%longjmp>
  )

 export 
 (reset-%tail 
  add-toplevel-forms-for-tail-module)

 expose 
 ((only ($tail-module) el2lzs)) ; export without import
 )

;;;in define-tail mit export export (like the real data types)
;;;to export from the tail module application
;;;but for this module define-tail exports always

(define-tail-sys-functions 
  %ref
  %extract
  %select
  %preselect
  %view
  %size-of-instance
  %size-as-component
  %cast
  %funcall
  ;??%setf

;  %setjmp
;  %longjmp

;;;now export the following from tail!!
  %pointer-of-variable
  %pointer-of-function
  %pointer-of-extract
  %pointer-of-select
  
  %setf-variable
  %setf-ref
  %setf-extract
  %setf-select
  %setf-view
  %setf-cast
  )

;;; -----------------------------------------------------------------------------------
;;; resetting module %tail
;;; -----------------------------------------------------------------------------------

;;;    ###########
(defun reset-%tail ()
;;;    ###########
  (setf (?fun-list $tail-module)
        (delete-if-not #'special-sys-fun-p (?fun-list $tail-module)))
  ;?var-list is set by set-init-fun-for-tail-module
  (setf (?named-const-list $tail-module) nil)
  (setf (?sym-list $tail-module) nil)
  (setf (?syntax-exports $tail-module) nil)
  (setf (?syntax-env $tail-module) nil)
  (setf (?exports $tail-module) 
        (append (?class-def-list $tail-module)
                (?fun-list $tail-module)))
  (setf (?lex-env $tail-module) (?exports $tail-module))
  (set-init-fun-for-tail-module))

(defconstant $unsigned-0 
  (make-literal-instance %unsigned-word-integer '(0)))
(defconstant $unsigned-1 
  (make-literal-instance %unsigned-word-integer '(1)))

(defun set-init-fun-for-tail-module ()
  ;NOTE SIDE EFFECT:
  ;sets the variable list of %tail
  (if *basic-system* 
    (progn 
      (setf (?var-list $tail-module) nil)
      (setf (?toplevel-forms $tail-module) nil))    
    (let ((initflag (make-instance <global-static> 
                      :identifier ^basic-initialization-done
                      :module $tail-module
                      :type %unsigned-word-integer
                      :initial-value $unsigned-0)))
      (setf (?var-list $tail-module) (list initflag))
      (setf (?toplevel-forms $tail-module)
            (make-instance <global-fun>
              :range-and-domain (vector %unsigned-word-integer)
              :params (make-instance <params>)
              :body 
              (make-instance <if-form>
                :pred
                (make-instance <app>
                  :function %eq
                  :arg-list (list (make-instance <var-ref> :var initflag)
                                  $unsigned-0))
                :then
                (make-instance <progn-form> 
                  :form-list (list (make-instance <setq-form>
                                     :location (make-instance <var-ref> 
                                                 :var initflag)
                                     :form $unsigned-1)))
                :else
                $unsigned-1)                
              :exported () 
              :identifier "basic-initialization"
              :module $tail-module)))
    ))


;;;    ################################## 
(defun add-toplevel-forms-for-tail-module (forms)
;;;    ##################################
  (unless *basic-system* 
    (let ((progn (?then (?body (?toplevel-forms $tail-module)))))
      (setf (?form-list progn)
            (append (butlast (?form-list progn))
                    forms 
                    (last (?form-list progn)))))))

#module-end
