;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: standard-mop -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    standard-mop.em
Version: 2.0 (last modification on Mon Feb 21 11:08:56 1994)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/standard-mop.em[2.0]:
  compile time MOP for standard classes 
  (only method definitions)
[1.1] Tue Mar 23 09:47:41 1993 wheick@isst proposed
  [Mon Mar 22 17:28:44 1993] Intention for change:
  class-representation inserted
[1.2] Thu Apr  8 15:21:02 1993 imohr@isst proposed
  code generation for classes ok
[1.3] Tue Apr 20 16:10:08 1993 imohr@isst proposed
  [Thu Apr  8 15:21:58 1993] Intention for change:
  --- no intent expressed ---
[1.4] Mon May  3 13:32:59 1993 imohr@isst proposed
  vector classes    
[1.5] Tue May  4 08:53:39 1993 imohr@isst proposed
  ~vector-class-element-initfunction
[1.6] Mon Aug 30 15:25:21 1993 imohr@isst proposed
  [Mon Aug 30 14:14:20 1993] Intention for change:
  collecting subclasses in a class
[1.7] Wed Sep 15 11:57:23 1993 imohr@isst saved
  [Mon Sep 13 08:29:08 1993] Intention for change:
  complete generic functions
[1.8] Wed Sep 15 13:17:08 1993 imohr@isst saved
  [Wed Sep 15 13:10:20 1993] Intention for change:
  removing some simple bugs
[1.9] Wed Sep 15 16:58:41 1993 imohr@isst saved
  [Wed Sep 15 14:43:04 1993] Intention for change:
  #+ discrimination-depth
[1.10] Thu Sep 16 11:41:52 1993 imohr@isst proposed
  [Thu Sep 16 11:28:58 1993] Intention for change:
  the representation of vector classes can't be checked because 
  accessor functions for vector classes are needed during computatntations
[1.11] Thu Sep 30 16:16:43 1993 imohr@isst proposed
  [Wed Sep 29 13:45:28 1993] Intention for change:
  extending slot-description-protocol
[1.12] Tue Oct 19 09:16:10 1993 hfried@isst published
  [Tue Oct 19 09:14:28 1993] Intention for change:
  ausschriften
[1.13] Mon Nov  8 11:55:21 1993 ukriegel@isst proposed
  [Mon Nov  8 10:57:02 1993] Intention for change:
   vector-class-instance-length-literal
  new machine description, ~vector-class-instance-lengt ~vector-class-instance-length-literal
[1.14] Tue Dec 14 17:18:53 1993 imohr@isst proposed
  [Tue Dec 14 12:48:14 1993] Intention for change:
  add inheritance of converters
[1.15] Mon Feb  7 08:26:50 1994 imohr@isst published
  [Wed Feb  2 12:53:44 1994] Intention for change:
  imported classes
  new slot access and imported classes ok
[1.16] Thu Feb 24 09:11:44 1994 wheick@isst proposed
  [Mon Feb 21 11:04:59 1994] Intention for change:
  replace whc-classes with representation
  done
[2.0] Thu Feb 24 09:11:44 1994 wheick@isst proposed
  [Mon Feb 21 11:04:59 1994] Intention for change:
  replace whc-classes with representation
  done

-----------------------------------------------------------------------------------
|#

#module standard-mop
(import
 (eulisp0 
  lzs-mop 
  lzs
  el2lzs-literals
  (only (<%pointer-to-vector>) representation) ;whc-classes
  (only (<%string>) tail-module)
  (only (find format) common-lisp))
 syntax 
 (eulisp0)
 )

;;; -----------------------------------------------------------------------------------
;;; ~class-of
;;; -----------------------------------------------------------------------------------

(defmethod ~class-of (object)
  (literal-type object))

(defmethod ~class-of ((object <class-def>))
  (?class object))

;;; -----------------------------------------------------------------------------------
;;; Class Introspection
;;; -----------------------------------------------------------------------------------

(defmethod ~class-name ((class <class-def>))
  (?identifier class))

(defmethod ~class-precedence-list ((class <class-def>))
  (?class-precedence-list class))

(defmethod ~class-slot-descriptions ((class <class-def>))
  (?effective-slots class))

(defmethod ~class-initargs ((class <class-def>))
  (?initargs class))

(defmethod ~class-representation ((class <class-def>))
  (?representation class))

(defmethod ~find-slot-description ((class <class-def>) slot-name)
  (find slot-name (~class-slot-descriptions class)
        :key #'~slot-description-name))

(defmethod ~class-subclasses ((class <class-def>))
  (?subclasses class))

(defmethod ~converter ((class <class-def>))
  (labels ((get-converter (class-list)
             (cond ((null class-list) nil)
                   ((?converter (car class-list)))
                   (t (get-converter (cdr class-list))))))
    (get-converter (~class-precedence-list class))))

;;; -----------------------------------------------------------------------------------
;;; Slot Introspection
;;; -----------------------------------------------------------------------------------

(defmethod ~slot-description-name ((slot <slot-desc>))
  (?identifier slot))

(defmethod ~slot-description-initfunction ((slot <slot-desc>))
  (?initfunction slot))

(defmethod ~slot-description-slot-reader ((slot <slot-desc>))
  (?reader slot))

(defmethod ~slot-description-slot-writer ((slot <slot-desc>))
  (?writer slot))

(defmethod ~slot-description-type ((slot <slot-desc>))
  (?type slot))

(defmethod ~slot-description-initarg ((slot <slot-desc>))
  (?initarg slot))

(defmethod ~slot-description-initvalue ((slot <slot-desc>))
  (?initvalue slot))

;;; -----------------------------------------------------------------------------------
;;; Generic Function Introspection
;;; -----------------------------------------------------------------------------------

(defmethod ~generic-function-domain ((gf <generic-fun>))
  (?domain gf))

(defmethod ~generic-function-method-class ((gf <generic-fun>))
  (?method-class gf))

(defmethod ~generic-function-methods ((gf <generic-fun>))
  (?method-list gf))

(defmethod ~generic-function-method-lookup-function ((gf <generic-fun>))
  (?method-lookup-fun gf))

(defmethod ~generic-function-discriminating-function ((gf <generic-fun>))
  (?discriminating-fun gf))

(defmethod ~generic-function-discrimination-depth ((gf <generic-fun>))
  (?discrimination-depth gf))

;;; -----------------------------------------------------------------------------------
;;; Method Introspection
;;; -----------------------------------------------------------------------------------

(defmethod ~method-domain ((method <method-def>))
  (?domain method))

(defmethod ~method-function ((method <method-def>))
  (?fun method))

(defmethod ~method-generic-function ((method <method-def>))
  (?generic-fun method))

;;; -----------------------------------------------------------------------------------
;;; Introspection of Vector Classes
;;; -----------------------------------------------------------------------------------

(defmethod ~vector-class-instance-length-literal (vector-class)
  (let ((initfun (~slot-description-initfunction 
                  (~find-slot-description vector-class ^length))))
    (if (null initfun)
      nil
      (init-fun-value (?body initfun) vector-class))))


(defmethod ~vector-class-instance-length (vector-class)
  (let ((initfun (~slot-description-initfunction 
                  (~find-slot-description vector-class ^length))))
    (if (null initfun)
      nil
      (car (?value-list (init-fun-value (?body initfun) vector-class))))))


(defgeneric init-fun-value (initform class))
(defmethod init-fun-value ((initform <named-const>) class)
  (if (eq (?value initform) ^unknown)
    (error-bad-init-form class initform)
    (init-fun-value (?value initform))))
(defmethod init-fun-value ((initform <literal-instance>) class)
  initform)
(defmethod init-fun-value ((initform <integer>) class)
  initform)
(defmethod init-fun-value (initform class)
  (error-bad-init-form class initform))

(defun error-bad-init-form (class initform)
  (format t "~% -------------------- error ------------------------")
  (format t "~% invalid initialization form ~A for the vector class ~A"
          initform class)
  (format t "~% ---------------------------------------------------~%")
  nil)

(defmethod ~vector-class-element-type (vector-class)
  (and 
   #|(check-for-vetcor-class vector-class (?representation vector-class))|#
   (~slot-description-type 
    (~find-slot-description vector-class ^element))))

(defmethod ~vector-class-element-initfunction (vector-class)
  (and
   #|(check-for-vetcor-class vector-class (?representation vector-class))|#
   (~slot-description-initfunction 
    (~find-slot-description vector-class ^element))))

; check-for-vector-class cannot use the representation for its test because the
; vector class accessors are already needed during computation of representations
;
;(defgeneric check-for-vetcor-class (class representation))
;(defmethod check-for-vetcor-class 
;           (class (representation <%pointer-to-vector>))
;  t)
;(defmethod check-for-vetcor-class 
;           ((class <%string>) representation)
;  ;??? why this is necessary ???
;  t)
;(defmethod check-for-vetcor-class (class representation)
;  (format t "~%Error: ~A (module ~A) is no vector class"
;          (?identifier class)
;          (?module-id class))
;  nil)

#module-end
