;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: side-effects-h -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    side-effects-h.em
Version: 2.0 (last modification on Mon Feb 28 13:53:55 1994)
State:   proposed

DESCRIPTION:
definition of the structures for side-effect analyse and teh function
 set-side-effect

DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/side-effects-h.em[2.0]:
  Zur Seiteneffektanalyse
[1.1] Thu Mar 25 11:22:09 1993 hfried@isst proposed
  [Thu Mar 25 08:56:26 1993] Intention for change:
  new head
[1.2] Tue Apr 13 14:11:27 1993 hfried@isst proposed
  [Thu Mar 25 11:55:21 1993] Intention for change:
[1.3] Mon Jun 21 11:49:36 1993 hfried@isst published
  [Tue Apr 13 14:17:15 1993] Intention for change:
[1.4] Fri Nov 26 10:39:54 1993 imohr@isst published
  [Wed Nov 24 14:33:13 1993] Intention for change:
  use defstandardclass for class definitions
[1.5] Tue Mar  1 08:02:47 1994 imohr@isst proposed
  [Mon Feb 28 13:52:39 1994] Intention for change:
  import make
[2.0] Tue Mar  1 08:02:47 1994 imohr@isst proposed
  [Mon Feb 28 13:52:39 1994] Intention for change:
  import make

-----------------------------------------------------------------------------------
|#

#module side-effects-h
(import (level-1-eulisp
         accessors
         )

 syntax  (level-1-eulisp
          apply-standard
          (only (make) simple-programming))

 export (set-read-side-effect
         set-write-side-effect
         <gloc> <fgloc>
         ?gplace ?fun ?glocs
         gloc-p
         )
 )

; class-definitions
; ------------------

;accessors
(defgeneric ?gplace (gloc))
(defgeneric ?fun (fgloc))
(defgeneric ?glocs (fgloc))

(defstandardclass <gloc> () 
;                 ------
  (gplace :accessor :initarg :initform ())
  (type   :accessor :initarg :initform ())
  :predicate
)

(defstandardclass <fgloc> ()
;                 -------
  (fun :accessor :initarg) ; fgloc belongs to this function
  (glocs :accessor :initarg :initform ())
  :predicate
)

;;definitions and init-forms

(defun set-read-side-effect (fun key value)
  (let ((gloc (make <gloc> :gplace value))
        (fread-gloc (?fread-gloc fun)))
  (if fread-gloc
    (setf (?glocs fread-gloc)
          (cons gloc (?glocs fread-gloc)))
    (setf (?fread-gloc fun)
          (make <fgloc> :fun fun
                :glocs (list gloc))))
  (setf (?sys-glocs fun) ^t))
)

(defun set-write-side-effect (fun key value)
  (let ((gloc (make <gloc> :gplace value))
        (fwrite-gloc (?fwrite-gloc fun)))
  (if fwrite-gloc
    (setf (?glocs fwrite-gloc)
          (cons gloc (?glocs fwrite-gloc)))
    (setf (?fwrite-gloc fun)
          (make <fgloc> :fun fun
                :glocs (list gloc))))
  (setf (?sys-glocs fun) ^t))
)

#module-end
