;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: representation -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.


-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    representation.em
Version: 2.0 (last modification on Mon Mar 14 17:07:22 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/representation.em[2.0]:
  accessors for representation.
[1.1] Tue Nov 23 12:56:14 1993 ukriegel@isst saved
  [Tue Nov 23 06:23:59 1993] Intention for change:
  byte-length
[1.2] Wed Nov 24 11:07:37 1993 ukriegel@isst proposed
  [Tue Nov 23 14:05:10 1993] Intention for change:
  clean up
[1.3] Thu Jan 13 11:25:30 1994 ukriegel@isst proposed
  [Wed Jan  5 13:25:47 1994] Intention for change:
  add default values for alignment
  done
[1.4] Wed Feb  2 17:38:43 1994 ukriegel@isst saved
  [Wed Feb  2 17:34:05 1994] Intention for change:
  [Wed Feb  2 17:19:30 1994] Intention for change:
  remove mm-initialize and fill representation with raw values

  ,.
[1.5] Thu Feb  3 09:44:06 1994 ukriegel@isst saved
  [Thu Feb  3 09:34:22 1994] Intention for change:
  default values for allocation mm-type
  done
[1.6] Thu Feb  3 11:03:54 1994 ukriegel@isst saved
  [Thu Feb  3 11:02:51 1994] Intention for change:
  --- no intent expressed ---
[1.7] Thu Feb  3 11:52:41 1994 ukriegel@isst published
  [Thu Feb  3 11:50:38 1994] Intention for change:
  --- no intent expressed ---
[1.8] Thu Mar  3 14:08:01 1994 wheick@isst proposed
  [Wed Mar  2 11:24:38 1994] Intention for change:
  insert eulisp0,1
  done
[1.9] Thu May  5 11:52:26 1994 imohr@isst proposed
  separate compilation of eulisp0
[2.0] Thu May  5 11:52:26 1994 imohr@isst proposed
  separate compilation of eulisp0

-----------------------------------------------------------------------------------
|#

#module representation

(import
 (eulisp1
  lzs
  (only (<tail-class-def>) lzs-mop)
  ;accessors
  )
 
 syntax
 (eulisp1 
  (only (defstandardclass) apply-standard)
  )
 
 export 
 
 (  <basic-class-def>
    <%integer>
    <%signed>
    <%unsigned> 
    <%float> ;new name
    <%aux-type>
    <%representation>
    <%machine-type>
    <%pointer> ;superclass of all pointer representations
    <%pointer-to-struct>
    <%pointer-to-vector>
    <%pointer-to-void>
    <%direct>
    <address-expr>
    ?alignment
    ?allocation
    ?byte-length
    ?byte-length-of-instance 
    ?byte-length-as-component
    ?mm-type
    ?mm-card

    )
 )


(defgeneric ?alignment (obj))
(defgeneric ?allocation (obj))
(defgeneric ?byte-length (obj))
(defgeneric ?byte-length-as-component (pobj))
(defgeneric ?byte-length-of-instance (obj))
(defgeneric ?mm-type (obj))
(defgeneric ?mm-card(obj))




(defstandardclass <%representation> ()
   (alignment :accessor :initarg)    ;alignment (of all types)

   (byte-length :accessor :initarg)  ;length (in bytes) of all types

   (allocation :accessor :initarg :initform ())  ;slots
   (mm-type  :accessor :initarg :initform ())      ;for the
   (mm-card :accessor :initarg)      ;memory management
   )  

;make a new class for %machine-type
;%bit ...%quad-word are instances from this class and are holded
;on the corresponding constants 
(defstandardclass <%machine-type> (<%representation>) ())


(defstandardclass <%aux-type> (<%representation>) ())

;;;the basic-data-type = basic-class-def takes informations 
;;;from %types = tail-class-def
;;;and from %representation
;;;!!!the old one!!!



;;;but I think it is better to cut the representation from the 
;;;eulisp hierarchy and take
;;;!!!the new one!!!

(defstandardclass <basic-class-def> (<imported-class>))

(defstandardclass <%integer> (<basic-class-def>) ())

(defstandardclass <%float> (<basic-class-def>) ())


;;; take <%signed> and <%unsigned> as mixin and not as subclass
;;; from <%integer-def>

;;; mixins for <%signed> and <%unsigned>
(defstandardclass <%signed> () ())

(defstandardclass <%unsigned> () ())

(defstandardclass <%pointer> (<%representation>)
  (offset :accessor :initarg)
  )                  

(defstandardclass <%pointer-to-struct> (<%pointer>))

(defstandardclass <%pointer-to-vector> (<%pointer>))

(defstandardclass <%pointer-to-void> (<%pointer>)
  (alignment :initform 4)
  (byte-length :initform 4)
  )

(defstandardclass <%direct> (<%representation>)) 


#module-end
