;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: quasiquote -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.


-----------------------------------------------------------------------------------
TITLE: backquote from feel for apply
-----------------------------------------------------------------------------------
File:    quasiquote.em
Version: 2.0 (last modification on Thu Feb 10 13:22:03 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:

CONTACT: 


HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/quasiquote.em[2.0]:
  
[1.1] Fri Feb 11 15:42:42 1994 wheick@isst proposed
  [Thu Feb 10 12:01:46 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Fri Feb 11 15:42:42 1994 wheick@isst proposed
  [Thu Feb 10 12:01:46 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#



#module quasiquote

(import
 ((except (STRINGP append) eulisp1)
  (only (CADAR
         CADR
         ERROR
         STRINGP
         append)
    common-lisp)
  )

 syntax
 (eulisp1)

 export
 (unquote-constructor)
 )

;; Quasi-quoting

(defun unquote-constructor (x)
  (cond ((atom x) 
	 (cond ((or (null x) (numberp x) (stringp x) (eq x t)) x)
	       (t (mkquote x))))
	
	((eq (car x) ^unquote) (cadr x))
	((eq (car x) ^unquote-splicing) 
	 (error "Illegal use of ,@ marker"))
	((eqcar (car x) ^unquote-splicing)
	 (list ^append (cadar x) (unquote-constructor (cdr x))))
;;	((contains-no-unquote x) (mkquote x))
	(t (list ^cons 
		 (unquote-constructor (car x))
		 (unquote-constructor (cdr x))))))

(defun contains-no-unquote (x)
  (cond ((atom x) t)
	((or (eq (car x) ^unquote) (eq (car x) ^unquote-splicing))
	 nil)
	(t (and (contains-no-unquote (car x))
		(contains-no-unquote (cdr x))))))

(defun mkquote (x) (list ^quote x))

(defun eqcar (a b) (cond ((atom a) nil) ((eq (car a) b) t) (t nil)))

;; (defmacro quasiquote (dummy form) (unquote-constructor form))


;(defmacro quasiquote (skel) (unquote-constructor skel))
