;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: option-lists -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: Functions to work with option lists
-----------------------------------------------------------------------------------
File:    option-lists.em
Version: 2.0 (last modification on Wed Feb 16 08:38:33 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/option-lists.em[2.0]:
  accessor functions for option lists of EuLisp
[1.1] Thu Mar 25 11:53:07 1993 imohr@isst proposed
  + check-options replace-option-value
[1.2] Fri Mar 26 17:53:40 1993 imohr@isst published
  + mapl-option-list
[1.3] Tue Nov 30 13:10:48 1993 imohr@isst saved
  [Wed Nov 24 13:33:18 1993] Intention for change:
  add signalling errors
  an auxillary version with error signalling which should be simply 
  rewritten to a version using error/signal
[1.4] Thu Feb 17 09:35:49 1994 wheick@isst proposed
  [Wed Feb 16 08:29:28 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Thu Feb 17 09:35:49 1994 wheick@isst proposed
  [Wed Feb 16 08:29:28 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#

#module option-lists

(import (eulisp0
         pair-ext
         list-ext
         (only (format find remove) common-lisp))
 
 syntax (eulisp0
         ;(only (when) level-1-eulisp)
         )

 export (map-option-list 
         find-option
         get-option
         replace-option-value
         check-options
         mapl-option-list)
 )

;;; -----------------------------------------------------------------------------------
;;; errors, should be replaced by condition signalling

(defconstant <undefined-option> '<undefined-option>)
(defconstant <uneven-option-list> '<uneven-option-list>)
(defconstant <mising-options> '<mising-options>)
(defconstant <option-not-found> '<undefined-option>)

(defun option-error (condition . initlist)
  (cond ((eq condition <undefined-option>)
         (format t "~%ERROR: undefined option: ~A" 
                 (get-option 'option initlist nil)))
        ((eq condition <uneven-option-list>)
         (format t "~%ERROR: option list with uneven number of elements; last one was ~A" 
                 (get-option 'option initlist nil)))
        ((eq condition <mising-options>)
         (format t "~%ERROR: missing options: ~A " 
                 (get-option 'options initlist nil)))
        ((eq condition <option-not-found>)
         (format t "~%ERROR: option ~A not found in option list ~A" 
                 (get-option 'option initlist nil)
                 (get-option 'options initlist nil)))
        ))
;;; -----------------------------------------------------------------------------------

(defun map-option-list (function option-list)
  (cond ((null option-list) nil)
        ((atom (cdr option-list))
         (option-error <uneven-option-list> 'option (car option-list)))
        (t (funcall function (car option-list) (cadr option-list))
           (map-option-list function (cddr option-list)))))

(defun mapl-option-list (function option-list)
  (cond ((null option-list) nil)
        ((atom (cdr option-list))
         (option-error <uneven-option-list> 'option (car option-list)))
        (t (funcall function option-list)
           (mapl-option-list function (cddr option-list)))))

(defun find-option (key option-list error-if-not-found?)
  (cond ((null option-list) 
         (when error-if-not-found?
           (option-error <option-not-found> 'option key 'options option-list))
         nil)
        ((atom (cdr option-list))
         (option-error <uneven-option-list> 'option (car option-list))
         nil)
        ((eq key (car option-list))
         (cdr option-list))
        (t (find-option key (cddr option-list) error-if-not-found?))))

(defun get-option (key option-list default)
  (let ((entry (find-option key option-list nil)))
    (if entry 
      (car entry)
      default)))

(defun replace-option-value (function key option-list)
  ;function is applied to the old value and must return the new
  ;value for the specified option
  ; the changed option-list is returned
  (let ((entry (find-option key option-list nil)))
    (when entry
      (setf (car entry) (funcall function (car entry))))
    option-list))

(defun check-options (required-options facultative-options multiple-options 
                                       option-list)
  (cond ((null option-list) 
         (if (null required-options)
           t
           (progn (option-error <mising-options> 
                                'options required-options)
                  nil)))
        ((atom (cdr option-list))
         (option-error <uneven-option-list> 'option (car option-list))
         nil)
        ((find (car option-list) required-options)
         (check-options (remove (car option-list) required-options) 
                        facultative-options multiple-options
                        (cddr option-list)))
        ((find (car option-list) facultative-options)
         (check-options required-options 
                        (remove (car option-list) facultative-options) 
                        multiple-options
                        (cddr option-list)))
        ((find (car option-list) multiple-options)
         (check-options required-options facultative-options multiple-options
                        (cddr option-list)))
        (t 
         (option-error <undefined-option> 'option (car option-list))
         (check-options required-options facultative-options multiple-options
                        (cddr option-list))
         nil)))


#module-end
