;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: messages -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-----------------------------------------------------------------------------------
TITLE: Signalling Compiler Messages
-----------------------------------------------------------------------------------
File:    messages.em
Version: 2.0 (last modification on Wed Feb  9 15:07:39 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/messages.em[2.0]:
  some basic stuff for generating error, warning, and info messages
[2.0] Fri Feb 25 14:05:44 1994 imohr@isst proposed
  some basic stuff for generating error, warning, and info messages

-----------------------------------------------------------------------------------
|#

#module messages
(import (eulisp0
         configuration
         lzs accessors
         (only (format *terminal-io*) common-lisp))
 syntax (eulisp0
         dynamic)
 export (write-message
         write-message-conditional))

(deflocal *line-length* 75)

(defun write-message (key message . args)
  (write-msg key message args))

(defun write-message-conditional (level key format . args)
  (unless (< (dynamic *info-level*) level)
    (write-msg key format args)))

(defun write-msg (key message args)
  (when key
    (let ((header 
           (format nil "~A~@[ in module '~(~A~)'~]"
                   key
                   (if (dynamic *current-module*)
                     (?identifier (dynamic *current-module*))
                     nil))))
      (format *terminal-io*
              "~%--- ~A ~V{-~}~%~
               ~@[--- in form ~((~2{~A ~} ...)~)~%~]"
              header
              (- *line-length* (length header) 5)
              '(())
              (dynamic current-defining-form)
              )))
  (format *terminal-io* "~?" message args)
  (when key (format *terminal-io* "~%~V{-~}" *line-length* '(()))))

#module-end
