;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: lzs2mzs -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    lzs2mzs.em
Version: 2.0 (last modification on Tue Mar  1 16:54:03 1994)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Firedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/lzs2mzs.em[2.0]:
  text
[1.1] Thu Mar 18 09:01:10 1993 hfried@isst proposed
  [Fri Mar  5 13:04:50 1993] Intention for change:
[1.2] Wed Mar 24 13:49:41 1993 hfried@isst proposed
  [Thu Mar 18 09:13:02 1993] Intention for change:
  + glob anna
[1.3] Thu Mar 25 11:20:52 1993 hfried@isst proposed
  [Wed Mar 24 14:54:51 1993] Intention for change:
  + gen-fun
  new head
[1.4] Tue Apr 13 14:10:23 1993 hfried@isst proposed
  [Thu Mar 25 11:54:46 1993] Intention for change:
[1.5] Wed Jun  2 09:07:59 1993 hfried@isst proposed
  [Tue Apr 13 14:16:26 1993] Intention for change:
  druck cleartypes
[1.6] Wed Aug 18 11:50:59 1993 hfried@isst proposed
  [Thu Aug 12 14:56:08 1993] Intention for change:
  ident-counter
[1.7] Thu Aug 26 11:49:32 1993 hfried@isst proposed
  [Tue Aug 24 08:42:14 1993] Intention for change:
  balance types Ausschrift
[1.8] Wed Sep  1 10:28:26 1993 hfried@isst published
  [Wed Sep  1 09:31:56 1993] Intention for change:
  functions in literals
  .#
[1.9] Fri Oct 15 07:43:45 1993 hfried@isst published
  [Thu Oct 14 13:12:07 1993] Intention for change:
  add typecheck
[1.10] Thu Oct 21 15:05:33 1993 akind@isst saved
  
[1.11] Tue Nov  2 16:20:41 1993 akind@isst saved
  
[1.12] Tue Nov 16 11:53:11 1993 hfried@isst proposed
  [Mon Nov  8 11:20:51 1993] Intention for change:
  typpropa. II
[1.13] Tue Jan  4 11:44:12 1994 akind@isst saved
  [Tue Dec 14 16:05:52 1993] Intention for change:
[1.14] Mon Jan 31 09:33:26 1994 akind@isst published
  [Tue Jan 11 09:53:28 1994] Intention for change:
  --- no intent expressed ---
[1.15] Wed Feb  9 15:07:07 1994 akind@isst proposed
  [Wed Feb  9 11:04:21 1994] Intention for change:
  --- no intent expressed ---
[1.16] Mon Feb 28 14:53:32 1994 wheick@isst proposed
  [Fri Feb 25 13:14:17 1994] Intention for change:
  insert eulisp0,1
  done
[1.17] Thu Mar  3 11:13:34 1994 hfried@isst proposed
  [Tue Mar  1 16:43:04 1994] Intention for change:
  add analysis exported functions
[2.0] Thu Mar  3 11:13:34 1994 hfried@isst proposed
  [Tue Mar  1 16:43:04 1994] Intention for change:
  add analysis exported functions

-----------------------------------------------------------------------------------
|#

#module lzs2mzs
(import 
 ((except (format) eulisp1)
  simple-programming
  LZS 
  MZS 
  context 
  analyse-h
  vector ; make-vector and vector-ref
  arg-context
  function-call-context
  function-label
  join-label-context
  progn-context
  switch-context
  test-context
  void-context
  type-propagation
  type-inference
  (only (mapc format) common-lisp)
  lzs-to-mzs-fun
  cleartypes
  side-effects
  expand-literal
  apply-funs
  types-hand-on
  debugging
  )
 
 syntax 
 (eulisp1)
 
 export  
 (lzs2mzs)
 )


;;---------------------------------------------------------------------------
;; (lzs2mzs /list-of-<module>-or-<modul>/) ---> /list-of-moduel/
;; --------------------------------------------------------------------------

;      #######
(defun lzs2mzs (modul-or-list)
;      #######
  (lzs2mzs1 (if (consp modul-or-list) modul-or-list (list modul-or-list))))

;      --------
(defun lzs2mzs1 (mlist)
;      --------
  ; -------------------------------------------
  (analysis-side-effects mlist)
; (mapc #'lzs2mzs-modul mlist) only the top-level form from first module
  ; -------------------------------------------
  (lzs2mzs-modul (car mlist))
  (mapc #'lzs2mzs-fun (get-functions-used-in-literals))
  (lzs2mzs-fun typecheck)
  (mapc #'lzs2mzs-exported-funs-in-modul (cdr mlist))
  ;(lzs2mzs-fun no-applicable-method-error)
  ; -------------------------------------------
  (info-format 1 "~%Reduce type schemes of statements ... ")
  (mapc #'clear-types-modul1 mlist)
  (info-format 1 "done.")
  ; --------------------------------------------
  ; second step: balance-applications
  (cond (*global-optimization*
	 (info-format 1 "~%Global inference ... ")
	 (mapc #'clear-types-modul2-global-optimization mlist)
	 (info-format 1 "done."))
	(t
	 (info-format 1 "~%Reduce type schemes of functions ... ")
	 (mapc #'clear-types-modul2 mlist)
	 (info-format 1 "done.")))
  ; --------------------------------------------
  ; third step: propagete new types
  (cond (*global-optimization*
	 (info-format 1 "~%Reanalysis of function statements ... ")
	 (types-hand-on-modules mlist)
	 (info-format 1 "done.")))
  ; --------------------------------------------
  ; fourth step: balance types
  (cond (*global-optimization*
	 (info-format 1 "~%Reduce type schemes of functions ... ")
	 (mapc #'clear-types-modul1 mlist)
	 (info-format 1 "done.")))
  ; --------------------------------------------
  ; fifth step: convert to sys-types
;  (mapc #'reset-signature (?fun-list $tail-module))
  (info-format 1 "~%Convert type schemes to range and domain vectors ... ")
  (mapc #'clear-types-modul3 mlist)
  (info-format 1 "done.")
  (synthesis-types-in-side-effects mlist)
  mlist)

(defun lzs2mzs-exported-funs-in-modul (mod)
  (mapc #'lzs2mzs-exported-fun (?fun-list mod)))

(defun clear-types-modul1 (modul)
  (let ((funs (?fun-list modul))
	(main-fun (?toplevel-forms modul)))
    (mapc #'clear-types1 funs)
    (if main-fun (clear-types1 main-fun))))

(defun clear-types-modul2 (modul)
  (let ((funs (?fun-list modul))
	(main-fun (?toplevel-forms modul)))
    (mapc #'clear-types2 funs)
    (if main-fun (clear-types2 main-fun))))

(defun clear-types-modul2-global-optimization (modul)
  (let ((funs (?fun-list modul))
	(main-fun (?toplevel-forms modul)))
    (mapc #'clear-types2-global-optimization funs)
    (if main-fun (clear-types2-global-optimization main-fun))))

(defun clear-types-modul3 (modul)
  (let ((funs (?fun-list modul))
	(main-fun (?toplevel-forms modul)))
    (mapc #'clear-types3 funs)
    (if main-fun (clear-types3 main-fun))))

;      -------------
(defun lzs2mzs-modul (modul)
;      -------------
  (setq indent-counter 0)
;  (mapc #'lzs2mzs-fun (?fun-list modul)) 
  (if (?toplevel-forms modul) (lzs2mzs-fun (?toplevel-forms modul)) 
      (format t "~%Warning: modul contains no top-level forms !!!"))
  (mapc #'lzs2mzs-exported-fun (?fun-list modul))
;  (mapc #'clear-types (?fun-list modul))
;  (if (?toplevel-forms modul) (clear-types (?toplevel-forms modul)) ())
)

 

(defun lzs2mzs-exported-fun (fun)
  (if (eq (?pass fun) 3) ()
      (if (and (global-fun-p fun) (?exported fun))
        (lzs2mzs-fun fun) ())))

#module-end