;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: lzs-syntax -*-
#|

This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: An interpreter for the LZS
-----------------------------------------------------------------------------------
File:    lzs-syntax.em
Version: 2.0 (last modification on Thu May  5 16:05:37 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:
lzs-syntax contains the macro def-lzs-object for lzs

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Winfried Heicking, Ingo Mohr

CONTACT: 
winfried.heicking@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/lzs-syntax.em[2.0]:
  done
[1.1] Fri Jan 28 11:55:06 1994 wheick@isst published
  done
[1.2] Mon Feb 14 15:53:31 1994 wheick@isst saved
  done
[1.3] Tue Feb 15 11:24:18 1994 wheick@isst saved
  
[1.4] Thu Feb 17 09:18:25 1994 wheick@isst proposed
  [Mon Feb 14 08:37:50 1994] Intention for change:
  remove type slot form lzs-object, insert in lzs new class lzs-object+type
  done
[1.5] Wed Mar 16 16:12:41 1994 wheick@isst proposed
  [Fri Mar 11 11:11:17 1994] Intention for change:
  divide :global into :global and :named in add-mixin-slots
  done
[1.6] Fri May  6 11:17:32 1994 imohr@isst proposed
  [Thu May  5 16:03:11 1994] Intention for change:
  + annotation language
  changes to provide mixin :named right
[2.0] Fri May  6 11:17:32 1994 imohr@isst proposed
  [Thu May  5 16:03:11 1994] Intention for change:
  + annotation language
  changes to provide mixin :named right

-----------------------------------------------------------------------------------
|#

#module lzs-syntax

(import (eulisp0
         apply-standard
         accessors
         )
 syntax (eulisp0 
         apply-standard
         )
 import ((only (append caar intern format last) 
           common-lisp))
 syntax ((only (pushnew) 
           common-lisp))
 export (def-lzs-object  ; macro
         make-structure-and-annotation-slots
         make-predicate-name
         <lzs-object>
         lzs-object-p)
 expose (accessors)
 )


;;------------------------------------------------------------------------------
;; defstandardclass of <lzs-object>
;;------------------------------------------------------------------------------

;;; defstandardclass of <lzs-object> here inserted
;;; because of name conflict with symbol <lzs-object>
;;; in function make-supers



(deflocal *structure-slots* nil)
(deflocal *annotation-slots* nil)


(defstandardclass <lzs-object> ()  ; the top node
  (source :initform () :accessor :writer :initarg)   ; some reference to the source
  :predicate)

;;; only to create accessor table for the module 'accessors'

(defun print-slots (slots)
  (format t "~%; --- slots ---~%~{~(~A~%~)~}"
          (cl:sort slots
                   #'cl:string<
                   :key #'cl:string))
  )



(defconstant $default-annotations  ())


;;; -----------------------------------------------------------------------------------
;;; def-lzs-object
;;; -----------------------------------------------------------------------------------


(defmacro def-lzs-object (name supers . slots)
  `(progn
     (defstandardclass
       ,(make-eulisp-class-id name)
       ,(make-supers supers)
       ,@(make-lzs-slots supers slots)
       :predicate)
     ,@(make-mixin-predicates name supers)
     (export 
       ,(make-eulisp-class-id name)
       ,(make-predicate-name name))))


(defun make-lzs-slots (supers slots)
  (make-structure-and-annotation-slots 
   (add-annotations (add-mixin-slots supers slots)
                    $default-annotations)))

(defun add-structure-slots (new-slots slots)
  (append new-slots slots))

(defun add-annotations (new-slots slots)
  (append slots new-slots))

(defun add-mixin-slots (supers slots)
  (cond ((null supers) slots)
        ((eq (car supers) ':named)
         (add-mixin-slots (cdr supers)
                          (add-annotations 
                           '((identifier :initform ())
                             (module :initform ())
                             (code-identifier :initform ()))
                           slots)))
        ((eq (car supers) ':global)
         (add-mixin-slots (cons ':named (cdr supers))
                          (add-structure-slots 
                           '((exported :initform ()))
                           slots)))
        ((eq (car supers) ':imported)
         (add-mixin-slots (cdr supers)
                          (add-annotations
                           '((definition :initform ())
                             (language :initform ()))
                           slots)))
        (t
         (add-mixin-slots (cdr supers) slots))
        ))

(defun make-structure-and-annotation-slots (slots)
  (cond ((null slots) nil)
        ((eq (car slots) ':annotations)
         (make-annotations (cdr slots)))
        ((consp (car slots))
         (pushnew (caar slots) *structure-slots*)
         (cons 
          (append (car slots)
                  '(:accessor :writer :initarg))
          (make-structure-and-annotation-slots (cdr slots))))
        (t 
         (pushnew (car slots) *structure-slots*)
         (cons 
          (list (car slots) ':accessor ':writer ':initarg)
          (make-structure-and-annotation-slots (cdr slots))))))

(defun make-annotations (slots)
  (cond ((null slots) nil)
        ((consp (car slots))
         (pushnew (caar slots) *annotation-slots*)
         (cons 
          (append (car slots)
                  '(:accessor :writer :initarg))
          (make-annotations (cdr slots))))
        (t 
         (pushnew (car slots) *annotation-slots*)
         (cons 
          (list (car slots) ':accessor ':writer ':initarg)
          (make-annotations (cdr slots))))))

(defun get-superclass-name (supers)
  (make-eulisp-class-id (car (last supers))))

(defun make-supers (supers)
  (if (null supers) 
    '(<lzs-object>)
    (list (get-superclass-name supers))))

(defun make-predicate-name (class-name)
  (intern (format nil "~A-P" class-name)))

(defun make-mixin-predicates (class-name supers)
  (cond ((null supers) nil)
        ((member (car supers) '(:named :global :imported))
         (cons
          `(defmethod ,(make-predicate-name (car supers)) 
                      ((object ,(make-eulisp-class-id class-name)))
             t)
          (make-mixin-predicates class-name (cdr supers))))
        (t
         (make-mixin-predicates class-name (cdr supers)))
        ))



#module-end

;;; eof module lzs-syntax
