;;;-*- Mode: Lisp; Package: COMMON-LISP-USER -*-

;; This code was developed in the joint research project APPLY funded by
;; the German Ministry of Research and Technology under the project code
;; ITW9102D5.
;; 
;; Copyright 1994-2010 Fraunhofer ISST
;; 
;; Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
;; versions of the EUPL (the "Licence");
;; 
;; You may not use this work except in compliance with the Licence.
;; You may obtain a copy of the Licence at:
;; http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
;; Unless required by applicable law or agreed to in
;; writing, software distributed under the Licence is distributed on an "AS IS" basis,
;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;; 
;; See the Licence for the specific language governing permissions and limitations under the Licence.


(in-package COMMON-LISP-USER)

;;; ***********************************************************************************
;;; definition of APPLY load states
;;; ***********************************************************************************
(defconstant $load-states `(

;; (key entry...)
;; entry = pathname    (load pathname) 
;; entry = symbol      (require-eulisp-module symbol)
;; entry = list        (eval list)

(:eulisp ,(make-pathname :directory `(,@$applyroot "EulispModules") 
                         :name "el-modules")
         level-1-eulisp)
(:lisp ,(make-pathname :directory `(,@$applyroot "Apply")
                       :name "defstandardclass")
       ,(make-pathname :directory `(,@$applyroot "Apply")
                       :name "simple-programming")
       )
(:zs accessors
     lzs
     mzs)
(:tail el2lzs
       el2lzs-rules
       el2lzs-classes
       el2lzs-generic
       el2lzs-literals
       standard-mop
       standard-init
       lzs-class-init
       annotate
       whc-definitions ; initialization
       mm-initialize ; initialization
       )
(:ti type-inference)
(:mzs   lzs2mzs)
;(:asm mzs2asm)
(:full code-generator 
       apply-compiler)
     
)) ; end of defconstant load-states
;;; ***********************************************************************************
  
  
(defun load-apply (&optional (key (caar (last $load-states))))
  (if (member key $load-states :key #'car)
    (load-apply-states key $load-states)
    (error "undefined load-state for APPLY: ~A" key)))

(defun load-apply-states (key states)
  (cond ((null states) nil)
        ((eq key (caar states))
         (load-state key (cdar states)))
        (t 
         (load-state (caar states) (cdar states))
         (load-apply-states key (cdr states)))))

(defun load-state (key load-specifications)
  (unless (get key 'load-apply)
    (mapc #'apply-load load-specifications)
    (setf (get key 'load-apply) t)
    ))

(defmethod apply-load (load-specification)
  (eval load-specification))

(defmethod apply-load ((load-specification pathname))
  (load load-specification))

(defmethod apply-load ((load-specification symbol))
  (require-eulisp-module load-specification))

