;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: letstar-form -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    letstar-form.em
Version: 2.0 (last modification on Mon Feb 28 15:53:46 1994)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Firedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/letstar-form.em[2.0]:
  text
[1.1] Thu Mar 18 09:00:52 1993 hfried@isst proposed
  [Fri Mar  5 13:04:25 1993] Intention for change:
[1.2] Wed Mar 24 13:49:22 1993 hfried@isst proposed
  [Thu Mar 18 09:12:39 1993] Intention for change:
  + glob anna
[1.3] Thu Mar 25 11:20:31 1993 hfried@isst proposed
  [Wed Mar 24 14:54:28 1993] Intention for change:
  + gen-fun
  new head
[1.4] Tue Apr 13 14:10:05 1993 hfried@isst proposed
  [Thu Mar 25 11:54:37 1993] Intention for change:
[1.5] Wed Jun  2 08:21:04 1993 hfried@isst proposed
  [Tue Apr 13 14:16:11 1993] Intention for change:
  result von letstar-a korrigiert
[1.6] Mon Jun 21 11:46:56 1993 hfried@isst saved
  [Thu Jun  3 09:18:36 1993] Intention for change:
  result-variable nicht gelinkt
[1.7] Wed Aug 18 11:47:29 1993 hfried@isst published
  [Mon Aug  9 15:16:58 1993] Intention for change:
  type-list
[1.8] Wed Mar  2 08:37:45 1994 wheick@isst proposed
  [Mon Feb 28 15:50:21 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Wed Mar  2 08:37:45 1994 wheick@isst proposed
  [Mon Feb 28 15:50:21 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#

#module letstar-form
(import 
 (eulisp1 
  accessors
  context
  LZS
  analyse-h
  MZS 
  move
  gutter
  type-inference
  ) 
 
 syntax 
 (eulisp1 
  simple-programming)
 
 export 
 (letstar-a) ; con, form 
 )



;--- definitions, exportations, initialization forms

(defun letstar-a (con form)
;   [let* var-list                             ; List of var
;         init-list                            ; List of initial values
;         type-list
;         read-gloc-list                       ; read-glocs of initial values
;         write-gloc-list                      ; write-glocs of var's
;         body]
  (dynamic-let ((closure (dynamic closure)))
               (let ((oldenv (dynamic env))
                     (var-list (?var-list form))
                     res)
                 (bind-vars var-list (?init-list form)
                            (?type-list form)
                            (?read-gloc-list form)
                            (?write-gloc-list form))
                 (if (join-label-p con) 
                   (setf (?rebind-vars con)
                         (cons var-list
                               (?rebind-vars con)))
                   ())
                 (setq res (l2m-a con (?body form)))
                 ; !!!!! missing unbind !!!!!
                 (if (or (function-label-p con)
                         (join-label-p con))
                   () (unbind var-list oldenv))
                 res
)))

(defun unbind (vlist oenv)
  (let ((cenv (dynamic env)))
    (setf (dynamic env) (unbind1 vlist cenv oenv))))

(defun unbind1  (vl cenv oenv)
  (cond ((eq cenv oenv) oenv)
        ((member (car (car cenv)) vl) (unbind1 vl (cdr cenv) oenv))
        (t (cons (car cenv) (unbind1 vl (cdr cenv) oenv)))))

(defun bind-vars (var-list init-list type-list rgloc-list wgloc-list)
  (cond ((null var-list) ())
        (t (bind-vars1 (car var-list)
                       (if init-list (l2m-a (dynamic *arg-context*) 
                                            (car init-list)) ())
                       (if type-list (class-as-type-expr
                                      (car type-list))
                           ())
                       (car rgloc-list) (car wgloc-list))
           (bind-vars (cdr var-list) (if init-list (cdr init-list) ())
                      (if type-list (cdr type-list) ())
                      (cdr rgloc-list) (cdr wgloc-list)))))

    
(defgeneric bind-vars1 (var init type rgloc wgloc))

(defmethod bind-vars1 ((var <local-static>) init type rgloc wgloc)
  (if (?closure var)
    (add-closure-var-value var init (dynamic block))
    (if (tempvar-p init) 
      (progn 
        (subst-and-check-tempvar (?link init) var type)
        (add-env var var))
      (add-move var init type rgloc wgloc)))
)

(defun subst-and-check-tempvar (link locstat type)
  (setf (?link locstat) link)
  (subst-and-check-tempvar1 link locstat type))

(defun subst-and-check-tempvar1 (link var type)
  (if (null link) ()
      (let* ((stat (car (car link)))
             (in (cdr (car link)))
             (td (?type-descr stat))
             (tds (?type-descr-s stat)))
        (setf (vector-ref (?var-vec (?var-descr stat)) in) var)
        (if type
          (progn 
            (set-descr-type td in type)
            (if tds (check-result-subtypes tds td) ()))
          ())
        (subst-and-check-tempvar1 (cdr link) var type))))

(defmethod bind-vars1 ((var <global-static>) init type rgloc wgloc)
  (add-move var init type rgloc wgloc)
)

(defmethod bind-vars1 ((var <imported-static>) init type rgloc wgloc)
  (add-move var init type rgloc wgloc)
)

(defmethod bind-vars1 ((var <dynamic>) init type rgloc wgloc)
  (print "dynamic-let not jet implemented")
)



#module-end