;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: inline-method -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.


-----------------------------------------------------------------------------------
TITLE: inline of LZS-Functions
-----------------------------------------------------------------------------------
File:    inline-method.em
Version: 2.0 (last modification on Thu Jul  7 14:22:59 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de 

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/inline-method.em[2.0]:
  
[1.1] Wed Sep 29 14:48:25 1993 hfried@isst proposed
  [Wed Sep 29 08:07:23 1993] Intention for change:
[1.2] Thu Sep 30 07:59:13 1993 hfried@isst proposed
  [Thu Sep 30 07:55:40 1993] Intention for change:
  variablen in function position
[1.3] Thu Sep 30 09:02:53 1993 hfried@isst proposed
  [Thu Sep 30 08:55:59 1993] Intention for change:
[1.4] Mon Oct 18 17:49:38 1993 hfried@isst proposed
  [Mon Oct 18 12:52:07 1993] Intention for change:
  call-next-method
[1.5] Tue Oct 19 09:07:38 1993 hfried@isst proposed
  [Tue Oct 19 09:01:03 1993] Intention for change:
  ausschriften
[1.6] Tue Oct 19 18:08:08 1993 hfried@isst proposed
  [Tue Oct 19 12:45:11 1993] Intention for change:
  Fehlerausschriften
[1.7] Wed Oct 20 10:51:14 1993 hfried@isst published
  [Wed Oct 20 09:09:20 1993] Intention for change:
  Fehlersuche
[1.8] Fri Jan 14 15:12:31 1994 wheick@isst saved
  [Fri Jan 14 14:51:40 1994] Intention for change:
  in initialize: :module-id -> :module
[1.9] Wed Jan 19 13:05:47 1994 hfried@isst published
  [Mon Jan 17 13:03:06 1994] Intention for change:
  slot-value
[1.10] Thu Mar  3 13:59:26 1994 wheick@isst proposed
  [Wed Mar  2 11:13:15 1994] Intention for change:
  insert eulisp0,1
  <spint> => <fpi>
[1.11] Thu May  5 11:52:17 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.12] Thu Jul  7 13:35:57 1994 hfried@isst saved
  [Thu Jul  7 13:25:21 1994] Intention for change:
  Behandlung von & rest parametern
  
[1.13] Thu Jul  7 14:23:37 1994 jbimberg@isst saved
  [Thu Jul  7 14:21:56 1994] Intention for change:
  add import apply
[2.0] Thu Jul  7 14:23:37 1994 jbimberg@isst proposed
  [Thu Jul  7 14:21:56 1994] Intention for change:
  add import apply

-----------------------------------------------------------------------------------
|#

#module inline-method
(import
 ((except (format) eulisp1) 
  LZS 
  LZS-MOP
  simple-programming
  expand-literal
  debugging
  name-of-fun
  apply-funs ; %call-next-method %next-method-p
  accessors
  (only (mapcar assoc make-instance append format) 
	common-lisp))
 
 syntax
 (eulisp1)
 
 export 
 (inline-method ; (method-def var-list)
  in-generic-fun
  in-method
  next-method-params
  transform-call-next-method ; (arg-list form)
  transform-next-method-p ; (arg-list form)
  arg-error ; (foo nr str)
  more-specific-p ; (dom1 dom2)
  )
 )


(defvar in-generic-fun ())
(defvar in-method ())
(defvar next-method-params ())

;      --------------------------
(defun transform-call-next-method (arg-list form)
;      --------------------------
  (let ((gf (dynamic in-generic-fun))
        (mf (dynamic in-method)))
    (if arg-list
      (arg-error %call-next-method (length arg-list) "too many")
      ())
    (if (and gf mf)
      (let ((nm (next-specific-method mf gf)))
        (if nm
          (let ((params (dynamic next-method-params)))
            (make <app> 
                  :function nm
                  :arg-list (mk-var-ref (?var-list params)
                                        (?rest params))))
          (progn
            (no-next-method-error)
            form)
          ))
      (progn 
        (outside-error %call-next-method)
        form))))

(defun mk-var-ref (vars rest)
  (if vars
    (cons (make <var-ref> :var (car vars))
          (mk-var-ref (cdr vars) rest))
    (if rest (list (make <var-ref> :var rest)) ())))
;      -----------------------
(defun transform-next-method-p (arg-list form)
;      -----------------------
  (let ((gf (dynamic in-generic-fun))
        (mf (dynamic in-method)))
    (if arg-list
      (arg-error %next-method-p (length arg-list) "too many")
      ())
    (if (and gf mf)
      (let ((nm (next-specific-method mf gf)))
        (if nm (expand-literal ;^t
                66) ()))  ; hock !!!
      (progn 
        (outside-error %next-method-p)
        form))))

(defun next-specific-method (meth gf)
;      --------------------
  (let ((nm (next-specific-method1 
             (~generic-function-methods gf) 
             (~method-domain meth) meth () ())))
    (if nm (?fun nm) ())))

(defun next-specific-method1 (m-lst dom mth s-dom s-mth)
  (if m-lst
    (let* ((c-mth (car m-lst))
           (c-dom (~method-domain c-mth)))
      (if (eq c-mth mth) 
        (next-specific-method1 (cdr m-lst) dom mth s-dom s-mth)
        (if (and (more-specific-p dom c-dom)
                 (or (null s-dom)
                     (more-specific-p c-mth s-dom)))
          (next-specific-method1 (cdr m-lst) dom mth c-dom c-mth)
          (next-specific-method1 (cdr m-lst) dom mth s-dom s-mth))))
    s-mth))

;      ---------------
(defun more-specific-p (dom1 dom2)
;      ---------------
  (if dom1
    (if (eq (car dom1) (car dom2))
      (more-specific-p (cdr dom1) (cdr dom2))
      (if (member (car dom2)
                  (~class-precedence-list (car dom1)))
        t ()))
    ()))

(defun no-next-method-error ()
  (let ((fun (analysed-fun)))
    (format t "~% --------------------- error -----------------------")
    (format t "~% no NEXT-METHOD applicable !!! ")
    (format t "~% in ~a function ~a "
            (funtype-of fun) (name-of fun))
    (format t "~% ---------------------------------------------------~%")))

(defun outside-error (foo)
  (let ((fun (analysed-fun)))
    (format t "~% --------------------- error -----------------------")
    (format t "~% call to ~a outside (!!) of a method "
            (name-of foo))
    (format t "~% in ~a function ~a "
            (funtype-of fun) (name-of fun))
    (format t "~% ---------------------------------------------------~%")))

(defun arg-error (foo nr str)
;  (arg-error-break)
  (let ((fun (analysed-fun)))
    (format t "~% --------------------- error -----------------------")
    (format t "~% ~A arguments ~A in a call of ~A function ~A"
            nr str (funtype-of foo) (name-of foo)  )
    (format t "~% in ~a function ~a "
            (funtype-of fun) (name-of fun))
    (format t "~% ---------------------------------------------------~%"))
)
;;definitions and init-forms

(defvar inline-env ())

(defun inline-method (method-def var-list)
  (let* ((fun (?fun method-def))
         (params (?params fun)))
    (if (imported-p fun)
      (progn
        (if (?rest params)
	    (progn
	      (setf (?var-list params)
		    (append (?var-list params) (list (?rest params))))
	      (setf (?rest params) ())) ())
	(make-instance <app>
		       :function fun
		       :arg-list (mapcar (lambda (var)
					   (make-instance <var-ref> :var var))
					 var-list)))
      (dynamic-let ((in-method method-def))
         (dynamic-let ((inline-env 
            (compute-env var-list 
                         (?var-list params)
                         (?rest params))))
                      (copy-lzs-form (?body fun)))))))

(defun compute-env (new-var old-var rest)
  (if old-var
    (cons (cons (car old-var) (car new-var))
          (compute-env (cdr new-var) (cdr old-var) rest))
    (if rest
      (list (cons rest (car new-var)))
      ())))

(defgeneric copy-lzs-form (form))
;--------------------------
; constants
;--------------------------

(defmethod copy-lzs-form ((form <named-const>))
  form)

(defmethod copy-lzs-form ((form <sym>))
  form)

(defmethod copy-lzs-form ((form <symbol>))
  form)

(defmethod copy-lzs-form ((form <structured-literal>))
  form)

(defmethod copy-lzs-form ((form <fpi>))
  form)

(defmethod copy-lzs-form ((form <double-float>))
  form)

(defmethod copy-lzs-form ((form <character>))
  form)

(defmethod copy-lzs-form ((form <class-def>))
  form)

(defmethod copy-lzs-form ((form <literal-instance>))
  form)

(defmethod copy-lzs-form ((form <global-fun>))
  form)

(defmethod copy-lzs-form ((form <local-fun>))
  form)

(defmethod copy-lzs-form ((form <imported-fun>))
  form)

(defmethod copy-lzs-form ((form <special-sys-fun>))
  form)

(defmethod copy-lzs-form ((form <global-generic-fun>))
  form)

(defmethod copy-lzs-form ((form <local-generic-fun>))
  form)

(defmethod copy-lzs-form ((form <imported-generic-fun>))
  form)

(defmethod copy-lzs-form ((form <cont>))
  form)

(defmethod copy-lzs-form ((form <null>))
  form)

;--------------------------
;   end of constans 
;--------------------------

;--------------------------
;   begin of variables 
;--------------------------

(defmethod copy-lzs-form ((form <var-ref>))
  (let ((newvar (assoc (?var form) (dynamic inline-env))))
    (make-instance <var-ref>
      :var (if newvar (cdr newvar) (?var form))))
)

;--------------------------
;   begin of function call 
;--------------------------

(defmethod copy-lzs-form ((form <app>))
  (let* ((fun (?function form))
	 (newvar (if (var-ref-p fun) 
		     (assoc (?var fun) (dynamic inline-env))
		   ())))
    (if (eq fun %call-next-method)
      (transform-call-next-method (?arg-list form) form)
      (if (eq fun %next-method-p)
        (transform-next-method-p (?arg-list form) form)
        (make-instance <app>
          :function (if newvar
		      (make-instance <var-ref> :var (cdr newvar)) fun)
          :arg-list (copy-lzs-form-list (?arg-list form))))))
)

(defun copy-lzs-form-list (form-list)
  (if form-list
    (cons (copy-lzs-form (car form-list))
          (copy-lzs-form-list (cdr form-list)))
    ()))

;--------------------------
;   end of function call
;--------------------------

(defmethod copy-lzs-form ((form <get-slot-value>))
  (make-instance <get-slot-value>
		 :instance (copy-lzs-form (?instance form))
		 :slot (?slot form)))

(defmethod copy-lzs-form ((form <set-slot-value>))
  (make-instance <set-slot-value>
		 :instance (copy-lzs-form (?instance form))
		 :slot (?slot form)
		 :value (copy-lzs-form (?value form))))

(defmethod copy-lzs-form ((form <setq-form>))
  (let* ((location (?location form))
         (isvar (if (defined-named-const-p location)
                  () t))
         (newvar (if isvar (assoc (?var location) (dynamic inline-env))
                     ())))
  (make-instance <setq-form>
    :form (copy-lzs-form (?form form))
    :location (if isvar
                (make-instance <var-ref> 
                  :var (if newvar (cdr newvar)
                           (?var location)))
                location))))

(defmethod copy-lzs-form ((form <progn-form>))
  (make-instance <progn-form>
    :form-list (copy-lzs-form-list (?form-list form)))
)


(defmethod copy-lzs-form ((form <if-form>))
  (make-instance <if-form>
    :pred (copy-lzs-form (?pred form))
    :then (copy-lzs-form (?then form))
    :else (copy-lzs-form (?else form))))
)

(defmethod copy-lzs-form ((form <switch-form>))
  (print "copy-lzs-form <switch-form> not yet implemented")
)

(defmethod side-effects ((form <let*-form>))
  (setf (?write-gloc-list form)
    (side-effects-let*-vars (?var-list form)))
  (let ((new-env (append (?var-list form) (dynamic env))))
  (dynamic-let ((env new-env))         
               (setf (?read-gloc-list form)
                     (side-effects-let*-inits (?init-list form)))
               (side-effects (?body form))))
)

(defmethod copy-lzs-form ((form <let*-form>))
  (let* ((old-vars (?var-list form))
         (new-vars (copy-var-list old-vars)))
    (dynamic-setq inline-env 
                  (add-env old-vars new-vars (dynamic inline-env)))
    (make-instance <let*-form>
      :var-list new-vars
      :init-list (copy-lzs-form-list (?init-list form))
      :body (copy-lzs-form (?body form))
      :type-list (?type-list form)))
)

(defun copy-var-list (old-vars)
  (if old-vars
    (cons (let ((var (car old-vars)))
            (if (local-static-p var)
              (make-instance <local-static>
                :identifier (?identifier var)
                :module (?module var))
              var))
          (copy-var-list (cdr old-vars)))
    ()))

(defun add-env (old new env)
  (if old
    (cons (cons (car old) (car new))
          (add-env (cdr old) (cdr new) env))
    env))

(defmethod copy-lzs-form ((form <labels-form>))
  (make-instance <labels-form>
    :fun-list (copy-lzs-form-list (?fun-list form))
    :body (copy-lzs-form (?body form))))

(defmethod copy-lzs-form ((form <let/cc-form>))
  (make-instance <let/cc-form>
    :cont (?cont form)
    :body (?body form)))

;
;(defmethod copy-lzs-form ((form <labeled-form>))
;)
;
;(defmethod copy-lzs-form ((form <tagbody-form>))
;)
;
;(defmethod copy-lzs-form ((form <mv-lambda>))


#module-end
