;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: gutter -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    gutter.em
Version: 2.0 (last modification on Mon Feb 28 15:25:04 1994)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Firedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/gutter.em[2.0]:
  
[1.1] Tue Apr 13 14:28:17 1993 hfried@isst proposed
  [Tue Apr 13 14:15:43 1993] Intention for change:
[1.2] Mon Jun 21 11:43:39 1993 hfried@isst saved
  [Tue Apr 13 14:28:48 1993] Intention for change:
[1.3] Wed Aug 18 11:50:36 1993 hfried@isst proposed
  [Wed Aug 18 09:41:59 1993] Intention for change:
  closures
[1.4] Thu Aug 26 11:47:58 1993 hfried@isst proposed
  [Wed Aug 18 15:13:59 1993] Intention for change:
  gloc -> glocs
[1.5] Tue Aug 31 12:12:09 1993 hfried@isst proposed
  [Sat Aug 28 13:30:40 1993] Intention for change:
  function-literal
[1.6] Fri Sep  3 15:46:30 1993 hfried@isst published
  [Thu Sep  2 11:27:25 1993] Intention for change:
  eingefuegte Funktionen mit analysieren
[1.7] Wed Mar  2 08:51:12 1994 wheick@isst proposed
  [Mon Feb 28 15:22:21 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Wed Mar  2 08:51:12 1994 wheick@isst proposed
  [Mon Feb 28 15:22:21 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#

#module gutter
(import 
 (eulisp1 
  SIMPLE-PROGRAMMING
  lzs
  mzs
  accessors
  vector
  analyse-h
  type-propagation
  type-inference
  side-effects-h
  lzs-to-mzs-fun
  apply-funs
  tail-module
  expand-literal
  (only (assoc) common-lisp)) 
 
 syntax 
 (eulisp1)
 
 export  
 (make-a-closure-function ; (fun block)
  set-closure-var         ; (var value block)
  add-closure-var-value   ; (var value block)
  add-closure-var         ; (var block)
  rename                  ; (var)
  )
 )


;--- definitions, exportations, initialization forms

;      ######  
(defun rename (var)
;      ######
  (if (?closure var)
    (read-closure-var var (dynamic block))
    (cdr (assoc var (dynamic env))))
)
 
;  (let ((newvar (assoc var (dynamic env))))
;    (cond ((null newvar) 
;           (setq newvar (assoc var (dynamic globenv)))
;           (cond ((null newvar)
;                  (warning
;                 "seltsam, die Variable ~s ist nicht in der Umgebung"
;                          var)
;                  var)
;                 (t (setq newvar (cdr newvar))
;                    (add-closure-var newvar) newvar)))
;          (t (cdr newvar)))))

;      ###############
(defun add-closure-var (var block)
;      ###############
  (let ((result (add-function-call %closure-push
                                   block 2 var 
                                   (if (dynamic closure) 
                                     (car (car (dynamic closure))) ())
                                   ())))
    ; extension of the closure (description)
    (dynamic-setq closure
                  (cons (cons result var)
                        (dynamic closure))))
)

;      #####################
(defun add-closure-var-value (var value block)
;      #####################
  (let ((result (add-function-call %closure-push
                                   block 2 value 
                                   (if (dynamic closure) 
                                     (car (car (dynamic closure))) ())
                                   ())))
    ; extension of the closure (description)
    (dynamic-setq closure
                  (cons (cons result var)
                        (dynamic closure))))
)
;      ----------------
(defun read-closure-var (var block)
;      ----------------
  (let ((cl (dynamic closure)))
    (add-function-call %closure-value block 2 (car (car cl))
                       (get-closure-number var cl 0) ()))
)

;      ###############
(defun set-closure-var (var value block)
;      ###############
  (let ((cl (dynamic closure)))
    (add-function-call %set-closure-value block 3
                       (car (car cl))
                       (get-closure-number var cl 0)
                       value)))

;      #######################
(defun make-a-closure-function (fun block)
;      #######################
  ; add-function in fun-list !!!
  
  (add-function-call %make-function block 3
                     (compute-arg-descr fun)
                     (car (car (dynamic closure)))
                     (%function-literal fun)
;                     (make <literal-instance> 
;                           :value-list (list fun)
;                           :class %function)
))

(defun compute-arg-descr (fun)
  (let* ((p (?params fun))
         (n (compute-arg-descr1 (?var-list p))))
    (if (?rest p)
      (mk-sigwi (- 0 (+ n 1)))
      (mk-sigwi n))))

(defun compute-arg-descr1 (var)
  (if (null var) 0
      (+ 1 (compute-arg-descr1 (cdr var)))))

(defun mk-sigwi (n)
  (make-literal-instance %signed-word-integer (list n))
)
;  (make <literal-instance> :value-list (list n)
;        :class %signed-word-integer))


;      ------------------
(defun get-closure-number (var cl nr)
;      ------------------
  (if (null cl) 
    (progn (warning "Var ~s not found in closure" var) nr)
    (if (eq (cdr (car cl)) var) (mk-sigwi nr)
        (get-closure-number var (cdr cl) (+ nr 1))))
)





#module-end
