;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: generate-header-file -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-----------------------------------------------------------------------------------
TITLE: generation of header files
-----------------------------------------------------------------------------------
File:    generate-header-file.em
Version: 2.0 (last modification on Tue Jul  5 13:18:14 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:
The first version of this module was copied in its main parts from module
'c-code'. Future implementations should integrate both implementation of
declaration generation. The main difference is that 
1. not explicitely exported classes may be represented in the header file as
void* and that
2. declarations are generated only for exported objects

REQUIRES:
(dynamic code-output) must be bound to a stream to which the C-code should be
written

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/generate-header-file.em[2.0]:
  generation of header file for top module - a nice hack
[1.1] Wed Apr 28 13:32:52 1993 ukriegel@isst proposed
  [Wed Apr 28 13:21:12 1993] Intention for change:
  :if-does-not-exist
  done
[1.2] Wed Apr 28 16:39:38 1993 ukriegel@isst proposed
  [Wed Apr 28 16:34:29 1993] Intention for change:
  defined-named-const
  done
[1.3] Thu Apr 29 08:54:39 1993 ukriegel@isst proposed
  [Thu Apr 29 08:50:08 1993] Intention for change:
[1.4] Mon May  3 12:13:44 1993 ukriegel@isst saved
  [Mon May  3 10:46:19 1993] Intention for change:
  add declarations
  c declarations added - a hack 
[1.5] Tue May  4 14:13:53 1993 ukriegel@isst proposed
  [Tue May  4 13:00:18 1993] Intention for change:
  discard underscore if any
  done
[1.6] Thu May  6 09:46:55 1993 ukriegel@isst proposed
  [Thu May  6 09:41:21 1993] Intention for change:
[1.7] Fri May  7 08:51:33 1993 ukriegel@isst proposed
  generates extern in front of lisp
  still to do is cooorect c type
[1.8] Fri May  7 12:31:41 1993 ukriegel@isst proposed
  [Fri May  7 11:04:24 1993] Intention for change:
  --- no intent expressed ---c declarations removed
[1.9] Tue May 11 14:28:30 1993 ukriegel@isst proposed
  [Tue May 11 10:41:02 1993] Intention for change:
  export module-init-fun
  rename taken into account
[1.10] Wed May 12 17:32:14 1993 ukriegel@isst proposed
  [Wed May 12 17:32:04 1993] Intention for change:
  --- no intent expressed ---
[1.11] Wed May 12 18:11:13 1993 ukriegel@isst proposed
  [Wed May 12 17:42:20 1993] Intention for change:
  reset minus in identifiers by underscores
  done
[1.12] Thu May 27 10:27:40 1993 ukriegel@isst saved
  [Thu May 27 10:26:00 1993] Intention for change:
  lowecase file names
  done
[1.13] Thu May 27 13:24:16 1993 ukriegel@isst proposed
  [Thu May 27 12:55:50 1993] Intention for change:
[1.14] Fri May 28 11:09:57 1993 ukriegel@isst proposed
  done
[1.15] Tue Jun  1 06:37:36 1993 ukriegel@isst proposed
  [Tue Jun  1 06:31:12 1993] Intention for change:
   typedef *double double-float
  done
[1.16] Tue Jun  1 09:43:19 1993 ukriegel@isst saved
  [Tue Jun  1 09:40:36 1993] Intention for change:
[1.17] Wed Jun  2 12:30:36 1993 ukriegel@isst proposed
  [Wed Jun  2 12:28:39 1993] Intention for change:
  add empty line to make unix happy
  done
[1.18] Wed Jun  2 15:14:37 1993 ukriegel@isst proposed
  [Wed Jun  2 15:13:32 1993] Intention for change:
[1.19] Fri Jul  9 15:47:43 1993 ukriegel@isst proposed
  [Fri Jul  9 13:16:53 1993] Intention for change:
  add strings
  <name> is named in header file as NAME_CLASS
[1.20] Thu Aug  5 09:37:09 1993 imohr@isst published
  [Mon Jul 26 11:25:15 1993] Intention for change:
  new code identifiers
  C-code generation
[1.21] Mon Dec 13 11:56:40 1993 imohr@isst proposed
  [Tue Dec  7 12:57:36 1993] Intention for change:
  replace the content by a version for application-header-files 
  compatible to c-code-generation
  generation of h-file for modules with export interface
[1.22] Wed Dec 15 15:31:02 1993 imohr@isst proposed
  [Wed Dec 15 12:57:26 1993] Intention for change:
  allow non-lisp results for exported functions
[1.23] Sat Dec 18 15:46:47 1993 imohr@isst proposed
  [Fri Dec 17 09:23:44 1993] Intention for change:
[1.24] Mon Feb  7 08:26:30 1994 imohr@isst published
  [Fri Jan 28 08:44:51 1994] Intention for change:
  basic-system compilation
  new slot access and imported classes ok
[1.25] Wed Feb  9 09:23:06 1994 imohr@isst proposed
  
[1.26] Mon Feb 28 10:48:41 1994 imohr@isst saved
  basic system compilation: first step (not yet error free)
[1.27] Thu May  5 11:52:14 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.28] Tue Jul  5 17:38:15 1994 imohr@isst proposed
  [Tue Jul  5 13:15:07 1994] Intention for change:
  explicit include of ctdio.h to provide FILE
[2.0] Tue Jul  5 17:38:15 1994 imohr@isst proposed
  [Tue Jul  5 13:15:07 1994] Intention for change:
  explicit include of ctdio.h to provide FILE

-----------------------------------------------------------------------------------
|#

#module generate-header-file
(import (eulisp0
         accessors
         lzs
         representation
         binding
         code-identifier
         c-typing
         predicates
         lzs-mop
         (only (expand-literal) expand-literal)
         (only (mapc mapcar list* svref)
           common-lisp))

 syntax (eulisp0
         c-code-syntax
         code-identifier
         )

 export (generate-header-file) 
 )

(defun generate-header-file (main-module modules)
  (let ((id (?identifier main-module)))
    (write-code "/*header file for EuLisp module '~(~A~)' */" id)
    (generate-eu2c-includes)
    (mapc (lambda (module)
            (mapc #'generate-type-declaration (?class-def-list module)))
          modules)
    (mapc (lambda (module)
            (mapc #'generate-struct-declaration (?class-def-list module)))
          modules)
    (mapc (lambda (module)
            (mapc #'generate-class-object-declaration (?class-def-list module)))
          modules)
    (mapc (lambda (module)
            (mapc #'generate-function-declaration (?fun-list module))
            (mapc #'generate-const-declaration (?named-const-list module))
            (mapc #'generate-var-declaration (?var-list module))
            (mapc #'generate-sym-declaration (?sym-list module))
            )
          modules)
    (write-code "~2%/***    module initialization function    ***/")
    (write-code  "~%/*** must be called one and only one time ***/")
    (write-code "~%extern void ~A();" (main-function-id main-module))
    ;(write-code "~2%/*** renamed exports ***/")
    ;(mapc #'generate-rename-macro *rename-exports*)
    (write-code "~2%/*end of header file for EuLisp module '~(~A~)'  */~2%" id)))

(defun generate-eu2c-includes ()
  (when (eq *compilation-type* :basic-system)
    (write-code "~%#include \"eu2c-total.h\"~
                 ~%#include <stdio.h>"))) ; to provide FILE for class-def of
                                          ; <file-stream> 

;;; -----------------------------------------------------------------------------------
;;; Type, Structure and Object Declarations for Classes
;;; -----------------------------------------------------------------------------------
(defun generate-type-declaration (class-def)
  (when (exported-p class-def)
    (type-declaration class-def (?representation class-def))))

(defgeneric type-declaration (class-def representation))

(defmethod type-declaration ((class-def <imported-class>) representation)
  ; declarations for imported classes should come with included header files
  nil)

(defmethod type-declaration (class-def (representation <%pointer-to-struct>))
  (write-code "~%~@<typedef ~;~Istruct ~A ~:_*~:*~A~;;~:>" 
          (type-identifier class-def)))

(defmethod type-declaration (class-def (representation <%pointer-to-vector>))
  (write-code "~%~@<typedef ~;~I~A ~:_*~A~;;~:>" 
          (type-identifier (~vector-class-element-type class-def))
          (type-identifier class-def)))

(defmethod type-declaration (class-def (representation <%pointer-to-void>))
  (write-code "~%typedef void* ~A;" (type-identifier class-def)))

(defmethod type-declaration (class-def (representation <%direct>))
  (write-code "~%~@<typedef ~;~I~A ~:_~A~;;~:>" 
          (type-identifier (get-referred-class representation class-def))
          (type-identifier class-def)))

(defmethod type-declaration ((class-def <basic-class-def>) representation)
  ; basic types are mapped directly to their C counterparts
  nil)

(defgeneric get-referred-class (representation class))

(defmethod get-referred-class (representation class) class)

(defmethod get-referred-class ((representation <%direct>) class)
  (let ((ref-class (~slot-description-type 
                    (car (~class-slot-descriptions class)))))
    (get-referred-class (?representation ref-class)
                        ref-class)))

(defun generate-struct-declaration (class-def)
  (when (exported-p class-def)
    (struct-declaration class-def (?representation class-def))))

(defgeneric struct-declaration (class-def representation))

(defmethod struct-declaration ((class-def <imported-class>) representation)
  ; declarations for imported classes should come with included header files
  nil)

(defmethod struct-declaration (class-def representation) 
  nil)

(defmethod struct-declaration ((class-def <basic-class-def>) representation) 
  nil)

(defmethod struct-declaration (class-def (rep <%pointer-to-struct>)) 
  (with-local-identifiers
    (write-code "~2%~@<struct ~;~:I~A ~:_{~:I~:{~A ~A;~:^ ~_~}~;};~:>" 
                (type-identifier class-def)
                (mapcar (lambda (slot)
                          (list (type-identifier (~slot-description-type slot))
                                (local-c-identifier slot)))
                        (~class-slot-descriptions class-def)))))

(defgeneric generate-class-object-declaration (class))
(defmethod generate-class-object-declaration (class)
  (when (exported-p class)
    (object-declaration class)))
(defmethod generate-class-object-declaration ((class <basic-class-def>))
  nil)

;;; -----------------------------------------------------------------------------------
;;; Function Declarations
;;; -----------------------------------------------------------------------------------

(defun generate-function-declaration (fun)
  (when (exported-p fun)
    (write-code "~%")
    (function-declaration fun)))

(defgeneric function-declaration (fun))

(defmethod function-declaration ((fun <generic-fun>)) 
  (object-declaration fun))

(defmethod function-declaration ((fun <discriminating-fun>))
  ; discriminating functions of exported generic functions have to be defined in
  ; the application, therefore no prototype is needed
  ; this scheme doesn't work for module compilation because in a single module a
  ; discriminating function may be defined or not
  ; the function object is not needed in any case
  nil)

(defmethod function-declaration ((fun <special-sys-fun>))
  ; do nothing
  nil)				

(defmethod function-declaration ((fun <defined-fun>))
  (function-prototype fun)
  (object-declaration fun))

(defmethod function-declaration ((fun <imported-fun>))
  ; the prototype of imported functions is got by including header-files into
  ; the C source
  nil)

(defun function-prototype (fun)
  (with-local-identifiers
    (generate-function-header fun)
    (write-code ";")
    ; reset generated code-identifiers of parameters
    ; they are recreated when generating function definitions
    ; this is because function header and body must be handled in the same
    ; 'with-local-identifier'-context 
    (mapc (lambda (var)
            (setf (?code-identifier var) nil)) 
          (?var-list (?params fun)))))

(defun generate-function-header (fun)
  (write-code "~%~@<extern ~A ~:I~A~:_(~:I~{~A ~A~^, ~_~})~:>"
	      (type-identifier (result-type fun))
	      (c-identifier fun)
	      (types-and-parameters fun)))

(defun types-and-parameters (fun)
  ; only required parameters must be considered, because functions with other
  ; parameters are mapped to functions which have required parameters only
  (types-and-parameters-1 (?var-list (?params fun)) 
                          (function-signature fun) 
                          1))

(defun types-and-parameters-1 (required function-signature i)
  (if (null required) 
    nil
    (progn 
      (setf (?type (car required))
            (svref function-signature i))
      (list* (type-identifier (svref function-signature i))
             (local-c-identifier (car required))
             (types-and-parameters-1 (cdr required) 
                                     function-signature
                                     (+ i 1))))))

;;; -----------------------------------------------------------------------------------
;;; constants, variables and symbols
;;; -----------------------------------------------------------------------------------

(defun generate-var-declaration (var)
  (when (exported-p var)
    (write-code "~%extern ~A ~A;"
                (type-identifier (global-var-type var))
                (c-identifier var))))

(defun generate-const-declaration (const)
  (when (exported-p const)
    (write-code "~%extern ~A ~A;"
                (type-identifier (global-var-type const))
                (c-identifier const))))

(defun generate-sym-declaration (sym)
  (when (exported-p sym)
    (object-declaration sym)))

(defun object-declaration (obj)
  ; generates declarations for function and class objects and also for symbols;
  ; because of this restricted set of exported literals only structure classes
  ; have to be considered
  (let ((literal-instance (expand-literal obj)))
    (write-code "~%extern S_LITERAL(~A, ~A);"
                (type-identifier (?class literal-instance))
                (c-identifier literal-instance))))

;;; -----------------------------------------------------------------------------------
;;; Rename Exports
;;; -----------------------------------------------------------------------------------

(defun generate-rename-macro (binding)
  (write-code "~%#define ~A ~A"
              (c-identifier binding)
              (c-identifier (finally-refered-object binding))))

;;; -----------------------------------------------------------------------------------
;;; general predicates
;;; -----------------------------------------------------------------------------------
(defun subclass-p (class superclass)
  (member superclass (~class-precedence-list class)))

#module-end