;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: function-call-context -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: all analyses in context function-call
-----------------------------------------------------------------------------------
File:    function-call-context.em
Version: 2.0 (last modification on Mon Feb 28 15:55:08 1994)
State:   proposed

DESCRIPTION: fill the var-vector of a statement
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/function-call-context.em[2.0]:
  text
[1.1] Thu Mar 18 08:59:56 1993 hfried@isst proposed
  [Fri Mar  5 13:03:54 1993] Intention for change:
[1.2] Wed Mar 24 13:48:23 1993 hfried@isst proposed
  [Thu Mar 18 09:11:24 1993] Intention for change:
  + glob anna
[1.3] Thu Mar 25 11:19:25 1993 hfried@isst proposed
  [Wed Mar 24 14:53:19 1993] Intention for change:
  + gen-fun
  new head
[1.4] Tue Apr 13 14:09:10 1993 hfried@isst proposed
  [Thu Mar 25 11:54:01 1993] Intention for change:
[1.5] Mon Jun 21 11:42:42 1993 hfried@isst published
  [Tue Apr 13 14:15:22 1993] Intention for change:
[1.6] Wed Mar  2 08:57:32 1994 wheick@isst proposed
  [Mon Feb 28 15:14:11 1994] Intention for change:
  insert eulisp0,1
  <spint> => <fpi>
[2.0] Wed Mar  2 08:57:32 1994 wheick@isst proposed
  [Mon Feb 28 15:14:11 1994] Intention for change:
  insert eulisp0,1
  <spint> => <fpi>

-----------------------------------------------------------------------------------
|#

#module function-call-context
(import 
 (eulisp1
  SIMPLE-PROGRAMMING
  LZS 
  MZS 
  context 
  analyse-h
  ;  function-call
  vector) ; make-vector and vector-ref
;; typeinfernce

 syntax 
 (eulisp1)

 export (l2m-call 
         simple-constant-p)
 )


;------------------------------------------------------------------
; constants
;------------------------------------------------------------------

;          ########               
(defmethod l2m-call (con  arg-list)
;          ########        
   (l2m-function-call con arg-list 1 (dynamic *arg-context*)) 
    ; fill the var-vector
)

;      -----------------
(defun l2m-function-call (statement arg-list nr arg-context)
;      -----------------
   (if (null arg-list) ()
       (let ((var-or-constant (l2m-a arg-context (car arg-list))))
         (setf (vector-ref (?var-vec (?var-descr statement))
                           nr) var-or-constant)
         (if (simple-constant-p var-or-constant)
           (setf (?constant-counter 
                  (?var-descr statement))
                 (+ 1 (?constant-counter 
                       (?var-descr statement))))
           ())
         (l2m-function-call statement (cdr arg-list) 
                                 (+ nr 1) arg-context)
)))


(defgeneric simple-constant-p (lzs-object))

(defmethod simple-constant-p ((obj <named-const>))
   (simple-constant-p (?value obj)))

(defmethod simple-constant-p ((obj <structured-literal>))
   t)

(defmethod simple-constant-p ((obj <sym>))
   t)

(defmethod simple-constant-p ((obj <symbol>))
   t)

(defmethod simple-constant-p ((obj <fpi>))
   t)

(defmethod simple-constant-p ((obj <double-float>))
   t)

(defmethod simple-constant-p ((obj <character>))
   t)

(defmethod simple-constant-p ((obj <null>))
   t)

(defmethod simple-constant-p ((obj <object>))
   #f)

#module-end