;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: expand-literal -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.


-----------------------------------------------------------------------------------
TITLE: Expand-Literal
-----------------------------------------------------------------------------------
File:    expand-literal.em
Version: 2.0 (last modification on Thu Feb 24 15:26:37 1994)
State:   proposed

DESCRIPTION:
Provides things to transform literals into instances of <literal-instance>.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/expand-literal.em[2.0]:
  provides only expand-literal to avoid module cycles
[1.1] Fri Aug 27 17:07:15 1993 imohr@isst saved
  [Fri Aug 27 08:03:40 1993] Intention for change:
  + right handling of function objects
[1.2] Mon Aug 30 07:48:17 1993 imohr@isst saved
  some bugs removed
[1.3] Wed Sep  1 18:07:42 1993 imohr@isst published
  
[1.4] Wed Sep 29 11:29:41 1993 imohr@isst proposed
  [Fri Sep 24 15:00:07 1993] Intention for change:
  remove package qualifier machine-description
  %function-literal for generic functions
[1.5] Thu Sep 30 16:15:54 1993 imohr@isst published
  [Wed Sep 29 13:20:16 1993] Intention for change:
[1.6] Fri Feb 25 11:41:39 1994 wheick@isst proposed
  [Thu Feb 24 15:21:46 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Fri Feb 25 11:41:39 1994 wheick@isst proposed
  [Thu Feb 24 15:21:46 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#

#module expand-literal
(import
 (eulisp0
  lzs accessors
  ; tail-module using explicitely machine-description::%function
  (only (remove-if-not make-instance mapcan) 
    common-lisp))
 syntax
 (eulisp1
  (only (push) 
    common-lisp))

 export 
  (expand-literal
  %function-literal
  make-literal-instance
  reset-literals
  *literals*
  get-functions-used-in-literals)
)


(defgeneric expand-literal (literal))

(defun %function-literal (function-object)
  (if (symbolp function-object)
    function-object            ; return ^unknown... as it is
    (make-literal-instance 
     ;%function
     (cl:symbol-value (cl:find-symbol "%FUNCTION" "MACHINE-DESCRIPTION"))
     (list (if (generic-fun-p function-object)
             (?discriminating-fun function-object)
             function-object)))))

(deflocal *literals* nil)

(defun reset-literals ()
  (setq *literals* nil))

(defun make-literal-instance (class value-list)
  (let ((inst (make-instance <literal-instance> 
                :class class
                :value-list value-list)))
    (push inst *literals*)
    inst))

(defmethod get-functions-used-in-literals ()
  (mapcan (lambda (lit)
            (remove-if-not #'fun-p (?value-list lit)))
          *literals*))



#module-end
