;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: eval-basic -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-----------------------------------------------------------------------------------
TITLE: Syntax definitions and other basic definitions for eval
-----------------------------------------------------------------------------------
File:    eval-basic.em
Version: 2.0 (last modification on Thu Mar 17 11:07:23 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/eval-basic.em[2.0]:
  basic stuff for eval (syntax, variable handling)
[1.1] Thu Jan 13 15:49:21 1994 imohr@isst saved
  [Wed Jan 12 16:51:45 1994] Intention for change:
  global variables
  improved error signalling
[1.2] Wed Jan 26 09:25:33 1994 wheick@isst published
  [Fri Jan 14 08:13:35 1994] Intention for change:
  --- no intent expressed ---
[1.3] Mon Feb 28 10:48:08 1994 imohr@isst saved
  late initform evaluation, required by let*
[1.4] Mon Mar 21 09:12:01 1994 wheick@isst proposed
  [Wed Mar 16 09:41:52 1994] Intention for change:
  [Tue Feb 15 09:17:31 1994] Intention for change:
  stepwise evaluation of variable initforms in let*
  done
[2.0] Mon Mar 21 09:12:01 1994 wheick@isst proposed
  [Wed Mar 16 09:41:52 1994] Intention for change:
  [Tue Feb 15 09:17:31 1994] Intention for change:
  stepwise evaluation of variable initforms in let*
  done

-----------------------------------------------------------------------------------
|#

#module eval-basic

(import (eulisp1 
         lzs
         el2lzs-error
         (only (find-module) el2lzs-main)
         (only (mapcar mapc assoc rest first append char-code) 
           common-lisp))

 syntax (eulisp1
         (only (push) common-lisp))

 export (*global-variables*
         initialize-variables)
 )

;;; -----------------------------------------------------------------------------------
;;; syntax for declaring system functions
;;; -----------------------------------------------------------------------------------

(defmacro declare-system-functions functions
  `(list ,@(mapcar (lambda (fun)
                     `(cons ',(make-eulisp-symbol fun)
                            #',fun))
                   functions)))

;;; -----------------------------------------------------------------------------------
;;; basics for the variable environment
;;; -----------------------------------------------------------------------------------

(defvar variable-environment () ) 
;;; holds the current bindings of local lexical variables in an a-list of the form
;;; ((a-lzs-local-static . value) ...).

(deflocal *global-variables* () )
;;; holds the current values of global lexical variables after the value was
;;; changed by setq; until the value is changed the current value must be taken
;;; from the annotation initial-value
;;; the values are stored in an a-list ((a-lzs-global-static . value) ...)

;;; The forms in body are executed with variables in vars bound to the
;;; corresponding values of the LZS-forms in values (computed by eval) and the
;;; variable in rst (unless it is () ) bound to the list of values not used for
;;; the other variables. The macro can be used for handling function
;;; applications and let*-forms of the LZS.

(defmacro with-new-values (vars rst values eval-function . body)
  ; eval-function is applied to every value in values and the result is taken
  ; for the binding; eval-function may be (), then no evaluation occurs and the
  ; values are taken as they are
  `(dynamic-let ((variable-environment (dynamic variable-environment)))
                (initialize-variables ,vars ,rst ,values ,eval-function)
                ,@body))

(defun initialize-variables (vars rst values eval-function)
(cond ((null vars) (initialize-rest rst values eval-function))
      ((null values) (eval-error-too-few-arguments))
      (t (push (cons (first vars) 
                     (if eval-function
                       (funcall eval-function (first values))
                       (first values)))
               (dynamic variable-environment))
         (initialize-variables (rest vars) rst 
                               (rest values) eval-function))))

(defun initialize-rest (rst values eval-function)
  (cond ((and (null rst) values)
         (eval-error-too-many-arguments))
        ((null rst))
        (t (push (cons rst 
                       (if eval-function 
                         (mapcar eval-function values)
                         values))
                 (dynamic variable-environment)))))

#module-end
