;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: The interface of the Eulisp-to-LZS-Transformer
-----------------------------------------------------------------------------------
File:    el2lzs.em
Version: 2.0 (last modification on Mon Jan 31 08:32:25 1994)
State:   proposed

DESCRIPTION:
This module provides a common interface for the transformation from EuLisp to LZS.

DOCUMENTATION:

NOTES:
The module lzs-modules should be included into this module and should then
deleted. 

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/el2lzs.em[2.0]:
  Provides the common interface of the frontend for the other parts
  of the APPLY-compiler.
[1.1] Mon Mar 29 13:32:06 1993 imohr@isst saved
  [Wed Mar 24 17:00:11 1993] Intention for change:
  --- no intent expressed ---
[1.2] Wed Mar 31 10:39:10 1993 imohr@isst proposed
  literals for structures, literal expanders and expose ok
[1.3] Tue May 11 13:40:51 1993 imohr@isst saved
  error when marking exported things removed
[1.4] Tue May 11 14:51:40 1993 imohr@isst published
  expose -> export 
[1.5] Thu Jan 13 15:04:04 1994 wheick@isst saved
  done
[1.6] Mon Jan 31 08:44:17 1994 wheick@isst published
  [Thu Jan 13 14:53:57 1994] Intention for change:
  eulisp0
  done
[2.0] Mon Jan 31 08:44:17 1994 wheick@isst proposed
  [Thu Jan 13 14:53:57 1994] Intention for change:
  eulisp0
  done

-----------------------------------------------------------------------------------
|#

#module el2lzs
(import
 (eulisp0 el2lzs-main)
 
 syntax
 (eulisp0 dynamic)

 export					; for interactive use
(load-module				;(module-id | path | "") loads and translates a module
  find-module
  module-env  ; the list of all modules needed for compilation 
  mark-as-exported
  get-identifier-and-object
  )

expose 
(lzs-modules)
)

(defun make-lzs-expression (form environment)
  (dynamic-let ((lex-env environment))
     (trans form)))

#module-end

