;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-generic -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.
-----------------------------------------------------------------------------------
TITLE: Transformation of generic function definitions into LZS
-----------------------------------------------------------------------------------
File:    el2lzs-generic.em
Version: 2.0 (last modification on Thu Jun 23 13:49:56 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/el2lzs-generic.em[2.0]:
  classes and generic functions ok
[1.1] Fri Apr 16 14:58:34 1993 imohr@isst proposed
  error in modulename removed
[1.2] Wed Sep 15 11:56:37 1993 imohr@isst proposed
  [Mon Sep 13 08:28:19 1993] Intention for change:
  complete generic functions
[1.3] Mon Sep 20 13:19:24 1993 imohr@isst proposed
  handling of specialized lambda-lists moved to el2lzs-rules.em
[1.4] Tue Sep 21 14:51:26 1993 imohr@isst proposed
  [Mon Sep 20 13:20:52 1993] Intention for change:
  --- no intent expressed ---defgeneric and defmethod with setter and converter
[1.5] Wed Sep 22 08:40:05 1993 imohr@isst proposed
  [Wed Sep 22 08:39:15 1993] Intention for change:
  removing simple bug
[1.6] Fri Sep 24 14:57:53 1993 imohr@isst proposed
  [Fri Sep 24 14:49:43 1993] Intention for change:
  method-functions into function list of module
[1.7] Fri Sep 24 15:14:11 1993 imohr@isst proposed
  [Fri Sep 24 15:11:37 1993] Intention for change:
  import listp
[1.8] Fri Sep 24 15:56:18 1993 imohr@isst proposed
  [Fri Sep 24 15:55:45 1993] Intention for change:
[1.9] Wed Oct 20 18:44:34 1993 imohr@isst published
  [Wed Oct 20 17:12:24 1993] Intention for change:
  improve error handling
[1.10] Tue Nov  9 11:35:16 1993 imohr@isst proposed
  [Mon Nov  8 12:54:17 1993] Intention for change:
  new style module header
  .,
[1.11] Tue Dec 14 17:18:36 1993 imohr@isst proposed
  [Tue Dec 14 12:48:20 1993] Intention for change:
  add inheritance of converters
[1.12] Thu Jan 13 16:04:21 1994 wheick@isst published
  done
[1.13] Mon Feb 28 10:46:59 1994 imohr@isst saved
  basic system compilation: first step (not yet error free)
[1.14] Thu May  5 11:52:06 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.15] Wed Jun 22 16:45:26 1994 imohr@isst proposed
  
[1.16] Fri Jun 24 15:51:51 1994 imohr@isst proposed
  [Tue Jun 14 11:26:23 1994] Intention for change:
  + dynamic method table extension of imported generic functions
[2.0] Fri Jun 24 15:51:51 1994 imohr@isst proposed
  [Tue Jun 14 11:26:23 1994] Intention for change:
  + dynamic method table extension of imported generic functions

-----------------------------------------------------------------------------------
|#

#module el2lzs-generic
(import (eulisp1 
         el2lzs-rules
         el2lzs-error
         pair-ext 
         list-ext
         tail-module
         lzs-mop
         quasiquote
         option-lists
         (only (%add-method) apply-funs)
         (only (warn listp append mapcar mapc make-instance vector) 
           common-lisp))
 syntax (eulisp1 
         el2lzs-main)
 )
;;; -----------------------------------------------------------------------------------
;;; defgeneric
;;; -----------------------------------------------------------------------------------

(deftranssyn (defgeneric gf-spec lambda-list . options)
  (with-defining-form
    (when options
           (warn-defgeneric-options-not-analyzed options))
         (setf (cdr (cddr (whole-form))) nil)
         (whole-form)))

(deftransmod (defgeneric gf-spec lambda-list . options)
  (cond ((symbolp gf-spec)
         (add-function (make-instance <global-generic-fun>
                         :identifier gf-spec)))
        ; otherwise no binding must be generated
        (t nil)))

(deftransdef (defgeneric gf-spec lambda-list . options)
  (with-defining-form
  (let* ((name (fun-spec-name gf-spec))
         (type (fun-spec-type gf-spec)) 
         (gf (find-in-lex-env name))) 
    (cond ((null type))
          ((eq type ^setter)
           (setq gf (set-setter gf gf-spec)))
          ((eq type ^converter)
           ;ATTN: in this case gf is a class from which the converter gf must be
           ;taken 
           (setq gf (set-converter gf gf-spec)))
          (t (error-invalid-generic-function-spec gf-spec)
             (setq gf nil)))
    (~initialize gf
                 (list ^name gf-spec
                       ^domain (lambda-specializers lambda-list)
                       ^range %object
                       ;^method-class
                       ^parameters (trans-params 
                                    (lambda-parameters lambda-list) 
                                    nil)
                       ))
    nil)))

(defun set-converter (class-def gf-spec)
  (if (class-def-p class-def)
    (if (?converter class-def)
      (error-converter-redefinition class-def)
      (setf (?converter class-def)
            (add-function 
             (make-instance <global-generic-fun>))))
    (error-class-required-in-converter-spec gf-spec)))

(defun set-setter (fun gf-spec)
  (if (fun-p fun)
    (if (?setter fun)
      (error-setter-redefinition fun)
      (setf (?setter fun)
            (add-function 
             (make-instance <global-generic-fun>))))
    (error-function-required-in-setter-spec gf-spec)))


;;; -----------------------------------------------------------------------------------
;;; defmethod
;;; -----------------------------------------------------------------------------------

(deftranssyn (defmethod gf-spec lambda-list . body)
  (with-defining-form
    (setf (cdr (cddr (whole-form)))
          (list (transsyn-progn body)))
    (whole-form)))

;; transmod isn't necessary because no top level binding must be created

(deftransdef (defmethod gf-spec lambda-list body)
  (with-defining-form
    (let* ((name (fun-spec-name gf-spec))
           (type (fun-spec-type gf-spec))
           (gf (find-in-lex-env name))
           (specializers (lambda-specializers lambda-list)))
      (cond ((null type))
            ((eq type ^setter)
             (setq gf (get-setter gf gf-spec)))
            ((eq type ^converter)
             ;ATTN: in this case gf is a class from which the converter gf must be
             ;taken 
             (setq gf (get-converter gf gf-spec)))
            (t (error-invalid-generic-function-spec gf-spec)
               (setq gf nil)))
      (when gf
        (let ((method (~initialize (make-instance <method-def>)
                                   (list   ^domain specializers
                                           ^range %object
                                           ^function (trans-method-function-lambda
                                                      gf
                                                      <global-fun>
                                                      (lambda-parameters lambda-list)
                                                      specializers
                                                      body)
                                           ^generic-function gf))))
          (~add-method gf method)
          (if (imported-p gf)
            (make-dynamic-add-method-form gf method)
            nil)))
      )))

(defun make-dynamic-add-method-form (gf method)
  (list (make-instance <app>
          :function %add-method
          :arg-list (list gf method)
          )))

(defun get-converter (class-def gf-spec)
  (if (class-def-p class-def)
    (or (?converter class-def)
        (and (error-no-converter class-def) nil))
    (progn (error-class-required-in-converter-spec gf-spec)
           nil)))

(defun get-setter (fun gf-spec)
  (if (fun-p fun)
    (or (?setter fun)
        (and (error-no-setter fun) nil))
    (progn (error-function-required-in-setter-spec gf-spec)
           nil)))

;;; -----------------------------------------------------------------------------------
;;; method-function-lambda
;;; -----------------------------------------------------------------------------------

(defun trans-method-function-lambda (gf function-class lambda-params
                                        lambda-specs body)
  (let ((gf-id (?identifier gf)))
    (unless (listp gf-id) (setq gf-id (list gf-id)))
    (trans-lambda body
                  (add-function
                   (make-instance function-class
                     :identifier (append gf-id
                                         (mapcar #'?identifier lambda-specs))))
                  (trans-params lambda-params nil))))

;;; -----------------------------------------------------------------------------------
;;; %declare-external-generic
;;; -----------------------------------------------------------------------------------

(deftranssyn (%declare-external-generic fun-spec params . options)
  (with-defining-form 
    (check-options () ^(external-name language methods) () options)
    (whole-form)))

(deftransmod (%declare-external-generic fun-spec params . options)
  (let ((ID (first fun-spec)))
    (add-function (make-instance <imported-generic-fun> :identifier ID))))

(deftransdef (%declare-external-generic fun-spec PARAMETERS . OPTIONS)
  ; this transformation doesn't use initialize 
  ; a future reimplementation should work with ~initialize to make handling of
  ; generic functions and methods uniform
  (with-defining-form
    (let* ((ID (first fun-spec))
           (TYPE (second fun-spec))
           (gf (find-in-lex-env ID))
           (external-name (get-option ^external-name OPTIONS nil))
           (language (get-option ^language OPTIONS nil))
           (methods (get-option ^methods OPTIONS nil))
           (domain (lambda-specializers PARAMETERS)))
      (setf (?params gf) 
            (trans-params (lambda-parameters PARAMETERS) nil))
      (setf (?range-and-domain gf) 
            (apply #'vector (trans TYPE) domain))
      (setf (?domain gf) domain)
      (setf (?code-identifier gf) external-name)
      (mapc (lambda (method-spec)
              (add-method-fun (find-in-lex-env (car method-spec)) ; the method function
                              ; the result class is ignored
                              (mapcar #'find-in-lex-env 
                                      (cdr (cdr method-spec))) ; the domain
                              gf))
              methods)
      nil)))

(defun add-method-fun (method-fun domain gf)
  (~add-method gf 
               (~initialize (make-instance <method-def>)
                            (list ^domain domain
                                  ^range %object
                                  ^function method-fun
                                  ^generic-function gf))))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %define-generic
;;; -----------------------------------------------------------------------------------
;
;(deftranssyn (%define-generic genfun-spec spec-lambda-list)
;  (progn (mapc (lambda (slot-description)
;                 (setf (third slot-description)
;                       (transsyn (third slot-description)))) 
;               slot-descriptions)
;         (whole-form)))
;
;(deftransmod (%define-generic genfun-spec spec-lambda-list)
;  (let* ((ID (first class-spec))
;         (class (make-instance <standard-class-def>
;                  :identifier ID)))
;    (add-class class)
;    (nconc (list class) 
;           (transmod-slot-descriptions slot-descriptions)
;           (transmod-class-options class-options))))
;
;
;(deftransdef (%define-generic genfun-spec spec-lambda-list)
;  (let* ((id (first class-spec))
;         (metaclass (second class-spec))
;         (class-def (find-in-lex-env id))
;         (supers (list (find-in-lex-env superclass))))
;    (setf (?class class-def) (find-in-lex-env metaclass))
;;???    (transdef-slot-descriptions slot-descriptions (?direct-slots class-def) class-def)
;    (~initialize class-def
;       (list* ^name id
;              ^direct-superclasses supers
;              ^direct-slot-descriptions (mapcar #'slot-name-type-init 
;                                                slot-descriptions)
;              class-options))
;    (bind-slot-accessors class-def slot-descriptions)
;    (bind-class-functions class-def class-options)
;    nil))


#module-end
