;;;-*- Mode: Lisp; Package: user -*-
;; This code was developed in the joint research project APPLY funded by
;; the German Ministry of Research and Technology under the project code
;; ITW9102D5.
;; 
;; Copyright 1994-2010 Fraunhofer ISST
;; 
;; Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
;; versions of the EUPL (the "Licence");
;; 
;; You may not use this work except in compliance with the Licence.
;; You may obtain a copy of the Licence at:
;; http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
;; Unless required by applicable law or agreed to in
;; writing, software distributed under the Licence is distributed on an "AS IS" basis,
;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;; 
;; See the Licence for the specific language governing permissions and limitations under the Licence.

(in-package user)
(import '(el-modules::module-package 
          el-modules::module-path
          el-modules::*eulisp-modules*))

(defun compile-apply-compiler ()
  (mapc #'compile-eulisp-module *eulisp-modules*))

(defun compile-eulisp-module (module)
  (when (module-path module)
    ;then it is not a module made from a CL package
    (compile-eulisp-module-package (module-package module))))

(defun compile-eulisp-module-package (package)
  (do-symbols (s package)
    ;(compile-el2lzs-transformations s)
    (when (and (fboundp s)
               (null (macro-function s))
               (eq package (symbol-package s)))
      (compile-function-or-method s)
      )))

(defun compile-function-or-method (s)
  (let ((fcn (symbol-function s)))
    (if (subtypep (class-of fcn) 'standard-generic-function)
      ;;method branch
      (dolist (method (clos:generic-function-methods fcn))
        (when (not (compiled-function-p (clos:method-function method)))
          (compile (clos::method-to-definition-spec method)))
        )
      ;;simple function
      (when (not (compiled-function-p (symbol-function s)))
        (compile s)))))

(defun compile-el2lzs-transformations (s)
  (mapc #'(lambda (ind)
            (let ((fun (get s ind nil)))
            (when (and fun
                       (functionp fun)
                       (not (compiled-function-p fun)))
              (setf (get s ind)
                    (compile fun)))))
        ^(trans transmod transdef transsyn)))

(compile-apply-compiler)

