;;;-*- Mode: Lisp; Package: COMMON-LISP-USER -*-
;; This code was developed in the joint research project APPLY funded by
;; the German Ministry of Research and Technology under the project code
;; ITW9102D5.
;; 
;; Copyright 1994-2010 Fraunhofer ISST
;; 
;; Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
;; versions of the EUPL (the "Licence");
;; 
;; You may not use this work except in compliance with the Licence.
;; You may obtain a copy of the Licence at:
;; http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
;; Unless required by applicable law or agreed to in
;; writing, software distributed under the Licence is distributed on an "AS IS" basis,
;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;; 
;; See the Licence for the specific language governing permissions and limitations under the Licence.

(in-package user)

;;; -----------------------------------------------------------------------------------
;;; apply packages for compilation
;;; -----------------------------------------------------------------------------------

(setq *apply-packages* '(

(:eulisp el-modules
         eulisp-kernel
         character
         collection
         el-conditions-0
         el-conditions
         compare
         double
         null
         number
         pair
         spint
         el-stream
         string
         symbol
         table
         vector
         level-0-eulisp
         pair-ext
         list-ext
         dynamic
         control1
         level-1-eulisp
         class-ext
         )

(:lisp defstandardclass
       simple-programming)

(:zs   accessors
       lzs
       mzs)

(:general debugging
          option-lists
          compiler-conditions
          configuration)

(:frontend el2lzs-basic
           el2lzs-error
           el2lzs-load
           el2lzs-main
           lzs-modules
           el2lzs 

           lzs-mop
           whc-classes
           expand-literal
           ;whc-aux
           whc-basic-data-types
           rr-md-read
           ;machine-description
           tail-module
           apply-funs
           eval
           whc-definitions
           representation
          
           el2lzs-rules
           el2lzs-classes
           el2lzs-generic
           el2lzs-literals

           annotate
           
           standard-mop
           standard-init
           mm-initialize
           lzs-class-init)

(:generic  inline-method
           generic-dispatch)

(:ti ti
     ti-codes
     ti-lattice

     ti-exprs
     ti-meet-join
     ti-eqs

     name-of-fun

     ti-write
     ti-copy
     ti-unify
     ti-signature
     ti-const
     type-inference

     ti-init
     type-propagation
     )

(:mzs side-effects-h
      context
      analyse-h
      progn-context
      type-propagation
      side-effects
      lzs-to-mzs-fun
      function-call-context
      gutter
      inline
      function-call
      if-form
      move
      letstar-form
      setq-form
      arg-context
      function-label
      join-label-context
      switch-context
      test-context
      void-context
      cleartypes
      lzs2mzs)

(:codegen mzs-to-lzs
          code-identifier
          c-typing
          c-data
          c-code-syntax
          c-code
          )

(:top code-generator
      generate-header-file
      generate-def-file
      apply-compiler)

)) ; end of *apply-packages*


;;; -----------------------------------------------------------------------------------
;;; compile-apply
;;; -----------------------------------------------------------------------------------

(defun compile-apply (&rest packages)
  (load-apply :lisp)
  (unless packages
    (setq packages (mapcar #'car *apply-packages*)))
  (mapc #'(lambda (package)
            (mapc #'compile-module 
                  (cdr (assoc package *apply-packages*))))
        packages))

(defun compile-module (name)
  (let ((file (some #'(lambda (path)
                        (or 
                         (probe-file 
                          (merge-pathnames
                           (make-pathname :name (string-downcase 
                                                 (string name))
                                          :type "em")
                           path))
                         (probe-file 
                          (merge-pathnames
                           (make-pathname :name (string-downcase 
                                                 (string name))
                                          :type "lisp")
                           path))))
                    *eulisp-module-search-path*)))
    (and file (compile-file file :verbose t))))

