;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: cleartypes -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.


-----------------------------------------------------------------------------------
TITLE: balanced all types and add types to move-statements 
-----------------------------------------------------------------------------------
File:    cleartypes.em
Version: 2.0 (last modification on Thu Mar  3 15:44:55 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR: Dr. Horst Friedrich

CONTACT: horst.friedrich@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/cleartypes.em[2.0]:
  text
[1.1] Thu Mar 18 08:59:29 1993 hfried@isst proposed
  [Fri Mar  5 13:03:15 1993] Intention for change:
[1.2] Wed Mar 24 13:48:03 1993 hfried@isst proposed
  [Thu Mar 18 09:10:58 1993] Intention for change:
  + glob anna
[1.3] Thu Mar 25 11:19:03 1993 hfried@isst proposed
  [Wed Mar 24 14:52:55 1993] Intention for change:
  + gen-fun
  new head
[1.4] Fri Mar 26 09:24:58 1993 hfried@isst proposed
  [Thu Mar 25 11:53:49 1993] Intention for change:
  generic-function wird uebergangen !!
[1.5] Tue Apr 13 14:08:47 1993 hfried@isst proposed
  [Fri Mar 26 09:26:12 1993] Intention for change:
[1.6] Tue Apr 27 09:34:28 1993 hfried@isst proposed
  [Tue Apr 13 14:15:06 1993] Intention for change:
  balance umgeschrieben
[1.7] Tue Apr 27 13:20:04 1993 hfried@isst proposed
  [Tue Apr 27 09:35:34 1993] Intention for change:
  !! balance umgeschrieben
  balance bei moves eingefuegt
[1.8] Thu May 27 09:37:19 1993 hfried@isst proposed
  [Thu May 27 09:21:44 1993] Intention for change:
  moves
[1.9] Fri May 28 08:29:25 1993 hfried@isst proposed
  [Fri May 28 08:09:08 1993] Intention for change:
  ) zuviel
  ) entfernt
[1.10] Wed Jun  2 09:07:25 1993 hfried@isst proposed
  [Wed Jun  2 08:53:57 1993] Intention for change:
  prints einbauen
  druch .
[1.11] Mon Jun 21 11:39:20 1993 hfried@isst saved
  [Fri Jun 18 15:39:39 1993] Intention for change:
[1.12] Tue Jun 29 10:49:05 1993 hfried@isst proposed
  [Tue Jun 29 10:47:41 1993] Intention for change:
  balance auch auf Funktionen!
[1.13] Wed Aug 18 11:47:02 1993 hfried@isst published
  [Tue Aug 10 08:29:23 1993] Intention for change:
  get-move-var-type entfernen
[1.14] Tue Sep 21 13:09:06 1993 hfried@isst proposed
  [Mon Sep 20 07:58:53 1993] Intention for change:
  multiple assignment
[1.15] Tue Sep 21 13:38:41 1993 hfried@isst proposed
  [Tue Sep 21 13:38:24 1993] Intention for change:
[1.16] Fri Oct 15 07:43:15 1993 hfried@isst published
  [Wed Oct 13 07:54:08 1993] Intention for change:
  add convert-to-sys-type-vec
[1.17] Thu Oct 21 15:04:50 1993 akind@isst saved
  [Fri Oct 15 14:40:08 1993] Intention for change:
  global optimizations
[1.18] Tue Nov  2 16:20:24 1993 akind@isst saved
  [Thu Oct 21 15:05:17 1993] Intention for change:
[1.19] Tue Nov 16 11:55:03 1993 hfried@isst proposed
  [Mon Nov  8 11:22:06 1993] Intention for change:
  typepr. II
[1.20] Tue Jan  4 11:41:51 1994 akind@isst saved
  [Tue Dec 14 14:15:07 1993] Intention for change:
[1.21] Mon Jan 24 13:46:04 1994 akind@isst saved
  [Tue Jan 11 09:53:31 1994] Intention for change:
  --- no intent expressed ---
[1.22] Mon Jan 24 15:16:32 1994 hfried@isst saved
  [Mon Jan 24 15:03:50 1994] Intention for change:
  + slot-value
[1.23] Mon Jan 31 09:29:38 1994 akind@isst proposed
  [Tue Jan 25 10:28:46 1994] Intention for change:
  --- no intent expressed ---
[1.24] Mon Feb  7 09:29:48 1994 akind@isst proposed
  [Wed Feb  2 15:32:57 1994] Intention for change:
  --- no intent expressed ---
[1.25] Mon Feb  7 15:25:13 1994 akind@isst proposed
  [Mon Feb  7 14:19:16 1994] Intention for change:
  special treatment of predicate functions
[1.26] Tue Feb  8 16:10:29 1994 akind@isst published
  [Tue Feb  8 09:41:06 1994] Intention for change:
  predicate-function-p -> predicate-fun-p
[1.27] Wed Feb  9 15:07:02 1994 akind@isst proposed
  [Wed Feb  9 11:57:46 1994] Intention for change:
  --- no intent expressed ---
[1.28] Thu Mar  3 11:12:14 1994 hfried@isst proposed
  [Tue Feb 15 08:43:31 1994] Intention for change:
  glob. optimation and rec. function call
[1.29] Fri Mar  4 11:30:16 1994 wheick@isst proposed
  [Thu Mar  3 15:12:14 1994] Intention for change:
  insert eulisp0,1
[2.0] Fri Mar  4 11:30:16 1994 wheick@isst proposed
  [Thu Mar  3 15:12:14 1994] Intention for change:
  insert eulisp0,1

-----------------------------------------------------------------------------------
|#

#module cleartypes

(import 
 ((except (format) eulisp1)
  LZS
  MZS
  type-inference
  ti-signature
  vector
  predicates
  (only (%void) tail-module)
  (only (mapc mapcar format append) common-lisp)
  )

 syntax
 (eulisp1)

 export 
 (clear-types1 
  clear-types2 
  clear-types2-global-optimization 
  clear-types3)
 )



(defvar move-vars ())
(defvar generic-calls ())

;;; Condense generic type schemes (type-descr-s) of statements to one-line
;;; schemes (type-descr).
(defun clear-types1 (fun)
  (if (and (simple-fun-p fun) 
           (or (= (?pass fun) 3)
               (= (?pass fun) 5)))
    (let ((calls (?calls fun))
	  (rcalls (?rec-calls fun)) ; *hf* 17.02
          (tests (?tests fun))
          (moves (?moves fun))
          (get-slot-value (?get-slot-value fun))
          (set-slot-value (?set-slot-value fun)))
;      (format t ".") ; for debug
      (dynamic-let ((move-vars ())
                    (generic-calls ()))
                   (mapc #'balance-and-clear-types-calls calls)
		   (mapc #'balance-and-clear-types rcalls) ; *hf* 17.02
                   (mapc #'balance-and-clear-types tests)
                   (mapc #'balance-and-clear-types get-slot-value)
                   (mapc #'balance-and-clear-types set-slot-value)
                   (mapc #'handle-moves moves)
                   (balance-multiple-assignment (dynamic move-vars))
                   (optimize-generic-calls (dynamic generic-calls))))))

;;; Condense generic type schemes (signature) of functions to one-line
;;; schemes (type-descr). Global optimization is performed.
(defun clear-types2-global-optimization (fun)
  (if (and (simple-fun-p fun) (= (?pass fun) 3))
      (let* ((applications (append (?rec-calls fun) (?applications fun)))
	     (typedescr (cond ((null (?applications fun))  ; e.g. init funs
			       (balance (?signature fun)))
			      ((unknown-applications-p fun); e.g. exported
			       (balance (?signature fun)))
			      (t
			       (balance-applications fun applications)))))
	(setf (?type-descr fun) typedescr)
	(setf (?stat typedescr) fun))
  (setf (?type-descr-s fun) ())))

;;; Condense generic type schemes (signature) of functions to one-line
;;; schemes (type-descr). No global optimization is performed.
(defun clear-types2 (fun)
  (if (and (simple-fun-p fun) (= (?pass fun) 3))
      (progn
	(setf (?type-descr fun) (balance (?signature fun)))
	(setf (?type-descr-s fun) ()))))

;;; Convert type expressions to classes.
(defun clear-types3 (fun)
  (if (null (signature-needed-for-code-generation-p fun))
      (setf (?signature fun) ()))	; no longer needed
  (if (and (simple-fun-p fun) 
	   (or (= (?pass fun) 5)
	       (= (?pass fun) 3)))
    (let ((calls (?calls fun))
	;  (rcalls (?rec-calls fun)) : *hf* 17.02
          (tests (?tests fun))
          (moves (?moves fun))
          (get-slot-value (?get-slot-value fun))
          (set-slot-value (?set-slot-value fun)))
      (convert-types fun)
      (check-if-result-type-%void fun)
      (mapc #'convert-types calls)
     ; (mapc #'convert-types rcalls)
      (mapc #'convert-types tests)
      (mapc #'convert-types moves)
      (mapc #'convert-types get-slot-value)
      (mapc #'convert-types set-slot-value))))

(defun check-if-result-type-%void (fun)
  (if (and (?range-and-domain fun)
	   (eq (vector-ref (?range-and-domain fun) 0) %void))
      (setf (vector-ref (?type-descr fun) 0) %void)))

(defun convert-types (stat)
  (setf (?type-descr stat)
        (convert-to-sys-type-vec (?type-descr stat))))

(defun optimize-generic-calls (call-list)
  (if call-list
      call-list
    ; (format t "~% Generic-calls ~s" call-list)
    ()))

(defun balance-multiple-assignment (vars)
  (if vars
    (progn
      (balance-multiple-assignment-var (car vars))
      (balance-multiple-assignment (cdr vars)))
    ()))

(defun balance-multiple-assignment-var (var)
  (set-joined-result-types (collect-assignment (?link var))))

;(defun union-result-types (list-of-td)
;  (format t "~% Union ~s " list-of-td))

(defun collect-assignment (link)
  (if link
    (if (eq (cdr (car link)) 0)
      (cons (?type-descr (car (car link)))
            (collect-assignment (cdr link)))
      (collect-assignment (cdr link)))
    ()))

(defun balance-and-clear-types (stat)
  (cond ((?type-descr-s stat)
	 (setf (?type-descr stat) (balance (?type-descr-s stat)))
	 (setf (?type-descr-s stat) ()))))

(defun balance-and-clear-types-calls (call)
  (balance-and-clear-types call)
  (if (and (generic-fun-p (?function call))
           (null (member call (dynamic generic-calls))))
      (dynamic-setq generic-calls (cons call (dynamic generic-calls))))
)

(defun handle-moves (move) ; *hf* 27.05
  (let ((tds (?type-descr-s move))
        (td (?type-descr move))
        (var (vector-ref (?var-vec (?var-descr move)) 0)))
    (if tds
      (setf (?type-descr move) (balance tds))
      (setf (?type-descr move) td))
    (if (and (or (tempvar-p var)
                 (local-static-p var))
             (null (member var (dynamic move-vars)))
             (more-than-one-assignment (?link var)))
      (dynamic-setq move-vars (cons var (dynamic move-vars)))
      ()))
  (setf (?type-descr-s move) ())
)

(defun more-than-one-assignment (link)
  (if link
    (if (eq (cdr (car link)) 0)
      (more-than-one-assignment-aux (cdr link))
      (more-than-one-assignment (cdr link)))
    ()))

(defun more-than-one-assignment-aux (link)
  (if link
    (if (eq (cdr (car link)) 0)
      t
      (more-than-one-assignment-aux (cdr link)))
    ()))
                    
#module-end
