;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: binding -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    binding.em
Version: 2.0 (last modification on Thu Feb 10 11:57:30 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/binding.em[2.0]:
  
[1.1] Mon Jan 31 14:48:23 1994 ukriegel@isst proposed
  [Mon Jan 31 14:47:39 1994] Intention for change:
  copyright
  done
[1.2] Mon Feb  7 11:31:27 1994 imohr@isst published
  [Mon Feb  7 10:40:09 1994] Intention for change:
  repair finally-refered-object
[1.3] Fri Feb 11 11:50:48 1994 wheick@isst proposed
  [Thu Feb 10 11:56:24 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Fri Feb 11 11:50:48 1994 wheick@isst proposed
  [Thu Feb 10 11:56:24 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#

#module binding
(import (eulisp0
         apply-standard
         accessors
         (only (make-instance call-next-method)
           common-lisp))
 syntax (eulisp0
         apply-standard)
 export (<binding>
         binding-p
         make-binding
         finally-refered-object 
         get-lzs-object)
 )

;;; -----------------------------------------------------------------------------------
;;; bindings
;;; -----------------------------------------------------------------------------------

(defstandardclass <binding> ()
  (identifier :reader :initarg)
  (code-identifier :accessor :initform ())
  (refers-to :reader :initarg)
  (refers-finally-to :accessor :initform ())
  :predicate)

(defun make-binding options
  (let ((binding (apply #'make-instance <binding> options)))
    (setf (?refers-finally-to binding) 
          (finally-refered-object (?refers-to binding)))
    binding))

(defgeneric finally-refered-object (obj))
(defmethod finally-refered-object (obj) obj)
(defmethod finally-refered-object ((obj <binding>))
  (or (?refers-finally-to obj)
    (setf (?refers-finally-to obj)
          (finally-refered-object (?refers-to obj)))))

(defmethod ?exported ((ref <binding>))
  (?exported (?refers-finally-to ref)))

(defun get-lzs-object (object)
  ;; get-lzs-object returns the object finally refered to if object is a
  ;; renamed object or otherwise returns its argument 
  (if (binding-p object)
    (?refers-finally-to object)
    object))


#module-end
