;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: annotate -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: Transformation of %annotate-forms to LZS
-----------------------------------------------------------------------------------
File:    annotate.em
Version: 2.0 (last modification on Tue Jun 21 15:48:30 1994)
State:   proposed

DESCRIPTION:
This module defines the transformation of %annotate-forms of TAIL to the LZS.

%annotate-function: provide information about a function
%annotate-class:    provide information about a class
%annotate-binding:  provide information about a global variable or a constant

The handlers for the keywords of %annotate-... are defined in the a-list
*annotate-...-handlers*. The handlers are functions of three arguments:
1. the object (%annotate-function: instance of LZS-class <fun>
               %annotate-class: instance of LZS-class <class-def>
               %annotate-binding: instance of LZS-class <global-static>
                                  or <named-const>)
2. the annotate-keyword
3. the form after the keyword (a list or a symbol in most cases)

DOCUMENTATION:

NOTES:

A distinction is made between %annotate-function, %annotate-class and
%annotate-binding to make error detection (no function/class-object, bad
keyword) a bit simpler.

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/annotate.em[2.0]:
  Transformation of %annotate-forms to LZS
[1.1] Thu Mar 18 09:26:07 1993 hfried@isst proposed
  [Fri Mar 12 17:23:03 1993] Intention for change:
  hinzufuegen inline 
  done
[1.2] Wed Mar 24 13:53:31 1993 hfried@isst proposed
  [Mon Mar 22 16:03:07 1993] Intention for change:
  add annotations for side-effects
[1.3] Wed Apr  7 16:12:30 1993 akind@isst proposed
  Included type inference handler to read in signatures.
[1.4] Wed Apr 14 12:03:58 1993 imohr@isst saved
  + handling of constants with function values
[1.5] Wed Apr 14 13:44:31 1993 imohr@isst saved
  
[1.6] Fri Apr 16 17:01:11 1993 akind@isst proposed
  [Fri Apr 16 16:59:57 1993] Intention for change:
  Added handler functions new-signature and extend-signature.
[1.7] Wed Sep 15 11:56:30 1993 imohr@isst proposed
  [Tue Sep 14 08:07:26 1993] Intention for change:
  annotate-function: + is-standard-discriminator
[1.8] Wed Sep 22 17:09:25 1993 akind@isst proposed
  [Wed Sep 22 17:06:36 1993] Intention for change:
  new handler (renew-signature)
[1.9] Mon Oct 11 08:47:33 1993 hfried@isst published
  [Fri Oct  8 10:51:07 1993] Intention for change:
  + -> binary+
[1.10] Tue Nov  9 11:33:43 1993 imohr@isst proposed
  [Mon Nov  8 14:18:40 1993] Intention for change:
  new style module header
[1.11] Tue Jan  4 11:40:40 1994 akind@isst saved
  [Fri Dec 10 14:28:00 1993] Intention for change:
[1.12] Mon Jan 31 09:29:13 1994 akind@isst published
  [Tue Jan 11 09:54:14 1994] Intention for change:
  --- no intent expressed ---
[1.13] Fri Feb 11 11:46:04 1994 wheick@isst proposed
  [Thu Feb 10 12:00:50 1994] Intention for change:
  insert eulisp0,1
  done
[1.14] Mon Feb 28 10:44:20 1994 imohr@isst saved
  + annotations for .def-files
[1.15] Thu May  5 11:51:50 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.16] Wed Jun 22 16:45:21 1994 imohr@isst proposed
  
[2.0] Wed Jun 22 16:45:21 1994 imohr@isst proposed
  

-----------------------------------------------------------------------------------
|#

#module annotate
(import ((except (assoc) eulisp1)
         lzs
         el2lzs-main
         el2lzs-error
         accessors
         (only (set-special-function 
                set-special-class
                set-special-binding
                provide-compiler-info) 
           apply-funs)
         (only (set-interpreter call) eval)
         (only (set-read-side-effect set-write-side-effect) side-effects-h)
         (only (new-signature extend-signature
			      comp-signature renew-signature) ti-signature)
         (only (set-std-discr-fun) generic-dispatch)
         (only (assoc cddr cadr second third remove-if-not mapcar) 
           common-lisp))
 syntax (eulisp1
         el2lzs-main
         (only (push) common-lisp))
 export (get-saved-annotations)
)

;;; -----------------------------------------------------------------------------------
;;; The handler functions for %annotate-function are defined in section
;;; "Handler functions for %annotate-function" (search for this)
;;; -----------------------------------------------------------------------------------

;;; -----------------------------------------------------------------------------------
;;; TAIL: %annotate-function
;;; -----------------------------------------------------------------------------------
;;; syntax: (%annotate-function <function-id> {<key> <description>}*)
;;; <function-id> : global function binding
;;; <key> : symbol
;;; <description> : any literal
;;; %describe-function provides some informations about functions, which are needed
;;; by the compiler but are not computable

(defgeneric get-function (lzs-object))

(defmethod get-function ((object <fun>)) object)
(defmethod get-function ((object <defined-named-const>))
  (if (eq (?value object) ^unknown)
    (error-invalid-object-for-annotate "function")
    (get-function (?value object))))
(defmethod get-function (object)
  (error-invalid-object-for-annotate "function"))

(deftranssyn (%annotate-function id . options) (whole-form))

(deftransdef (%annotate-function id . options)
  (with-defining-form
    (transdef-%annotate (get-function (find-in-lex-env id)) 
                        options
                        *annotate-function-handlers*)))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %annotate-class
;;; -----------------------------------------------------------------------------------
;;; syntax: (%annotate-class <function-id> {<key> <description>}*)
;;; <function-id> : global function binding
;;; <key> : symbol
;;; <description> : any literal
;;; %describe-function provides some informations about functions, which are needed
;;; by the compiler but are not computable

(defgeneric get-class (lzs-object))
(defmethod get-class ((object <class-def>)) object)
(defmethod get-class ((object <defined-named-const>))
  (if (eq (?value object) ^unknown)
    (error-invalid-object-for-annotate "class")
    (get-class (?value object))))
(defmethod get-class (object)
  (error-invalid-object-for-annotate "class"))

(deftranssyn (%annotate-class id . options) (whole-form))

(deftransdef (%annotate-class id . options)
  (with-defining-form
    (transdef-%annotate (get-class (find-in-lex-env id)) 
                        options
                        *annotate-class-handlers*)))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %annotate-binding
;;; -----------------------------------------------------------------------------------
;;; syntax: (%annotate-binding <var-or-const-id> {<key> <description>}*)
;;; <var-or-const-id> : global binding defined by deflocal or defconstant
;;; <key> : symbol
;;; <description> : any literal
;;; %describe-binding provides some informations about variables and constants,
;;; which are needed by the compiler but are not computable

(deftranssyn (%annotate-binding id . options) (whole-form))

(deftransdef (%annotate-binding id . options)
  (with-defining-form
    (transdef-%annotate (find-in-lex-env id) 
                        options
                        *annotate-binding-handlers*)))

;;; -----------------------------------------------------------------------------------
;;; common stuff for %annotate-....
;;; -----------------------------------------------------------------------------------

(deflocal *saved-annotations* ())

(defun transdef-%annotate (object options handler-table)
  (if (null options) 
    nil
    (let* ((key (car options))
           (option (cadr options))
           (handler (find-annotate-handler key handler-table 
                                           object option)))
      (when handler (funcall handler object key option))
      (transdef-%annotate object (cddr options) handler-table))))

(defun find-annotate-handler (key handler-table object option)
  (let ((entry (assoc key handler-table)))
    (if entry
      (progn
        (when (third entry) ; save original form for .def-file?
          (push (list object key option)
                *saved-annotations*))
        (second entry))
      (progn 
        (error-invalid-key-for-annotate key)
        nil))))

(defun get-saved-annotations (object)
  (mapcar #'cdr
          (remove-if-not (lambda (entry)
                           (eq (car entry) object)) 
                         *saved-annotations*)))

;;; -----------------------------------------------------------------------------------
;;; Handler 
;;; -----------------------------------------------------------------------------------

(defun set-inline (fun key value)
  (setf (?inline fun) value))

(defun set-reduce (fun key value)
  ;
  ; syntax of value:
  ;                   ( /binary-function/ 
  ;                     /one-argument-translation/
  ;                     /zero-argument-translation/
  ;                     /translation-type/)
  ; /one-argument-translation/ = self | t | (/function/ /args/*)
  ; args = /constant/ | self
  ; /zero-argument-translation/ = /constant/ | error
  ; /translation-type/ = acc | logical | select1 | select2
  ;
  (setf (car value) (get-function (find-in-lex-env (car value))))
  (if (consp (car (cdr value)))
    (setf (car (car (cdr value)))
          (get-function (find-in-lex-env (car (car (cdr value))))))
    ())
  (setf (?reduce fun) value))

;;; -----------------------------------------------------------------------------------
;;; simple setting of different annotations
;;; -----------------------------------------------------------------------------------

(defun set-code-identifier (obj key value)
  (cond ((eq key ^code-identifier)
         (setf (?code-identifier obj) value))
        ((eq key ^type-identifier) ;needed for classes
         (setf (?type-identifier obj) value))
        ))

(defun set-setter (fun key setter)
  (setf (?setter fun) (find-in-lex-env setter)))

;;; -----------------------------------------------------------------------------------
;;; Handler functions for %annotate-function
;;; -----------------------------------------------------------------------------------
;;; If the save-original-value-flag is t then the value of the option is saved
;;; and later retrieved to put it into the .def-file as it was originally given.

(deflocal *annotate-function-handlers*
  `(;(keyword function save-original-value-flag)
    (,^interpreter ,#'set-interpreter t )
    (,^inline ,#'set-inline () )
    (,^read-location ,#'set-read-side-effect () )
    (,^write-location ,#'set-write-side-effect () )
    (,^new-signature ,#'new-signature () )
    (,^extend-signature ,#'extend-signature () )
    (,^renew-signature ,#'renew-signature () )
    (,^comp-signature ,#'comp-signature () )
    (,^is-standard-discriminator ,#'set-std-discr-fun t )
    (,^reduce ,#'set-reduce () )
    (,^init-function ,#'set-module-init-function () )
    (,^is-special-function ,#'set-special-function t )
    (,^code-identifier ,#'set-code-identifier ())
    (,^setter ,#'set-setter ())
    ))

(deflocal *annotate-class-handlers*
  `(;(keyword function save-original-value-flag)
    (,^is-special-class ,#'set-special-class t )
    (,^code-identifier ,#'set-code-identifier ())
    (,^type-identifier ,#'set-code-identifier ())
    ))

(deflocal *annotate-binding-handlers*
  `(;(keyword function save-original-value-flag)
    (,^is-special-binding ,#'set-special-binding t )
    ))

;;; -----------------------------------------------------------------------------------
;;; %provide-compiler-info
;;; -----------------------------------------------------------------------------------

(deftranssyn (%provide-compiler-info . options) (whole-form))

(deftransdef (%provide-compiler-info . options)
  (with-defining-form
    (labels ((traverse-options (options)
               (unless (null options)
                 (provide-compiler-info (car options)
                                        (cadr options))
                 (traverse-options (cddr options)))))
      (traverse-options options))
    ))

#module-end
